/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.hadoop.mapreduce.lib.jobcontrol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.PipelineCallable;
import org.apache.crunch.Target;
import org.apache.crunch.hadoop.mapreduce.lib.jobcontrol.CrunchControlledJob;
import org.apache.crunch.impl.mr.MRJob;
import org.apache.hadoop.conf.Configuration;

public class CrunchJobControl {
    private Map<Integer, CrunchControlledJob> waitingJobs;
    private Map<Integer, CrunchControlledJob> readyJobs;
    private Map<Integer, CrunchControlledJob> runningJobs;
    private Map<Integer, CrunchControlledJob> successfulJobs;
    private Map<Integer, CrunchControlledJob> failedJobs;
    private Map<PipelineCallable<?>, Set<Target>> allPipelineCallables;
    private Set<PipelineCallable<?>> activePipelineCallables;
    private List<PipelineCallable<?>> failedCallables;
    private Log log = LogFactory.getLog(CrunchJobControl.class);
    private final String groupName;
    private final int maxRunningJobs;
    private int jobSequence = 1;

    public CrunchJobControl(Configuration conf, String groupName, Map<PipelineCallable<?>, Set<Target>> pipelineCallables) {
        this.waitingJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.readyJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.runningJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.successfulJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.failedJobs = new Hashtable<Integer, CrunchControlledJob>();
        this.groupName = groupName;
        this.maxRunningJobs = conf.getInt("crunch.max.running.jobs", 5);
        this.allPipelineCallables = pipelineCallables;
        this.activePipelineCallables = this.allPipelineCallables.keySet();
        this.failedCallables = Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CrunchControlledJob> toList(Map<Integer, CrunchControlledJob> jobs) {
        ArrayList<CrunchControlledJob> retv = new ArrayList<CrunchControlledJob>();
        Map<Integer, CrunchControlledJob> map = jobs;
        synchronized (map) {
            for (CrunchControlledJob job : jobs.values()) {
                retv.add(job);
            }
        }
        return retv;
    }

    public List<CrunchControlledJob> getWaitingJobList() {
        return CrunchJobControl.toList(this.waitingJobs);
    }

    public List<CrunchControlledJob> getRunningJobList() {
        return CrunchJobControl.toList(this.runningJobs);
    }

    public List<CrunchControlledJob> getReadyJobsList() {
        return CrunchJobControl.toList(this.readyJobs);
    }

    public List<CrunchControlledJob> getSuccessfulJobList() {
        return CrunchJobControl.toList(this.successfulJobs);
    }

    public List<CrunchControlledJob> getFailedJobList() {
        return CrunchJobControl.toList(this.failedJobs);
    }

    public synchronized List<CrunchControlledJob> getAllJobs() {
        return ImmutableList.builder().addAll(this.waitingJobs.values()).addAll(this.readyJobs.values()).addAll(this.runningJobs.values()).addAll(this.successfulJobs.values()).addAll(this.failedJobs.values()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToQueue(CrunchControlledJob aJob, Map<Integer, CrunchControlledJob> queue) {
        Map<Integer, CrunchControlledJob> map = queue;
        synchronized (map) {
            queue.put(aJob.getJobID(), aJob);
        }
    }

    private void addToQueue(CrunchControlledJob aJob) {
        Map<Integer, CrunchControlledJob> queue = this.getQueue(aJob.getJobState());
        CrunchJobControl.addToQueue(aJob, queue);
    }

    private Map<Integer, CrunchControlledJob> getQueue(MRJob.State state) {
        Map<Integer, CrunchControlledJob> retv = null;
        if (state == MRJob.State.WAITING) {
            retv = this.waitingJobs;
        } else if (state == MRJob.State.READY) {
            retv = this.readyJobs;
        } else if (state == MRJob.State.RUNNING) {
            retv = this.runningJobs;
        } else if (state == MRJob.State.SUCCESS) {
            retv = this.successfulJobs;
        } else if (state == MRJob.State.FAILED || state == MRJob.State.DEPENDENT_FAILED) {
            retv = this.failedJobs;
        }
        return retv;
    }

    public synchronized void addJob(CrunchControlledJob aJob) {
        aJob.setJobState(MRJob.State.WAITING);
        this.addToQueue(aJob);
    }

    private synchronized void checkRunningJobs() throws IOException, InterruptedException {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.runningJobs;
        this.runningJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private synchronized void checkWaitingJobs() throws IOException, InterruptedException {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.waitingJobs;
        this.waitingJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            nextJob.checkState();
            this.addToQueue(nextJob);
        }
    }

    private Set<Target> getUnfinishedTargets() {
        HashSet unfinished = Sets.newHashSet();
        for (CrunchControlledJob job : this.runningJobs.values()) {
            unfinished.addAll(job.getAllTargets());
        }
        for (CrunchControlledJob job : this.readyJobs.values()) {
            unfinished.addAll(job.getAllTargets());
        }
        for (CrunchControlledJob job : this.waitingJobs.values()) {
            unfinished.addAll(job.getAllTargets());
        }
        return unfinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeReadySeqDoFns() {
        Set<Target> unfinished = this.getUnfinishedTargets();
        Set<PipelineCallable<?>> oldPipelineCallables = this.activePipelineCallables;
        this.activePipelineCallables = Sets.newHashSet();
        ArrayList callablesToRun = Lists.newArrayList();
        for (PipelineCallable<?> pipelineCallable : oldPipelineCallables) {
            if (Sets.intersection(this.allPipelineCallables.get(pipelineCallable), unfinished).isEmpty()) {
                if (pipelineCallable.runSingleThreaded()) {
                    try {
                        if (pipelineCallable.call() == PipelineCallable.Status.SUCCESS) continue;
                        this.failedCallables.add(pipelineCallable);
                    }
                    catch (Throwable t) {
                        pipelineCallable.setMessage(t.getLocalizedMessage());
                        this.failedCallables.add(pipelineCallable);
                    }
                    continue;
                }
                callablesToRun.add(pipelineCallable);
                continue;
            }
            this.activePipelineCallables.add(pipelineCallable);
        }
        ListeningExecutorService es = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        try {
            List res = es.invokeAll((Collection)callablesToRun);
            for (int i = 0; i < res.size(); ++i) {
                if (((Future)res.get(i)).get() == PipelineCallable.Status.SUCCESS) continue;
                this.failedCallables.add((PipelineCallable)callablesToRun.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failedCallables.addAll(callablesToRun);
        }
        finally {
            es.shutdownNow();
        }
    }

    private synchronized void startReadyJobs() {
        Map<Integer, CrunchControlledJob> oldJobs = null;
        oldJobs = this.readyJobs;
        this.readyJobs = new Hashtable<Integer, CrunchControlledJob>();
        for (CrunchControlledJob nextJob : oldJobs.values()) {
            if (this.runningJobs.size() < this.maxRunningJobs) {
                nextJob.setJobSequence(this.jobSequence);
                ++this.jobSequence;
                nextJob.submit();
            }
            this.addToQueue(nextJob);
        }
    }

    public synchronized void killAllRunningJobs() {
        for (CrunchControlledJob job : this.runningJobs.values()) {
            if (job.isCompleted()) continue;
            try {
                job.killJob();
            }
            catch (Exception e) {
                this.log.error((Object)("Exception killing job: " + job.getJobName()), (Throwable)e);
            }
        }
    }

    public synchronized boolean allFinished() {
        return this.waitingJobs.size() == 0 && this.readyJobs.size() == 0 && this.runningJobs.size() == 0;
    }

    public synchronized boolean anyFailures() {
        return this.failedJobs.size() > 0 || this.failedCallables.size() > 0;
    }

    public List<PipelineCallable<?>> getFailedCallables() {
        return this.failedCallables;
    }

    public void pollJobStatusAndStartNewOnes() throws IOException, InterruptedException {
        this.checkRunningJobs();
        this.checkWaitingJobs();
        this.executeReadySeqDoFns();
        this.startReadyJobs();
    }
}

