/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.fn;

import org.apache.crunch.Emitter;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class PairMapFn<K, V, S, T>
extends MapFn<Pair<K, V>, Pair<S, T>> {
    private MapFn<K, S> keys;
    private MapFn<V, T> values;

    public PairMapFn(MapFn<K, S> keys, MapFn<V, T> values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public void configure(Configuration conf) {
        this.keys.configure(conf);
        this.values.configure(conf);
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.keys.setConfiguration(conf);
        this.values.setConfiguration(conf);
    }

    @Override
    public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
        this.keys.setContext(context);
        this.values.setContext(context);
    }

    @Override
    public void initialize() {
        this.keys.initialize();
        this.values.initialize();
    }

    @Override
    public Pair<S, T> map(Pair<K, V> input) {
        return Pair.of(this.keys.map(input.first()), this.values.map(input.second()));
    }

    @Override
    public void cleanup(Emitter<Pair<S, T>> emitter) {
        this.keys.cleanup(null);
        this.values.cleanup(null);
    }
}

