/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.fn;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.crunch.FilterFn;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public final class FilterFns {
    private FilterFns() {
    }

    public static <S> FilterFn<S> and(FilterFn<S> fn1, FilterFn<S> fn2) {
        return new AndFn(fn1, fn2);
    }

    public static <S> FilterFn<S> and(FilterFn<S> ... fns) {
        return new AndFn<S>(fns);
    }

    public static <S> FilterFn<S> or(FilterFn<S> fn1, FilterFn<S> fn2) {
        return new OrFn(fn1, fn2);
    }

    public static <S> FilterFn<S> or(FilterFn<S> ... fns) {
        return new OrFn<S>(fns);
    }

    public static <S> FilterFn<S> not(FilterFn<S> fn) {
        return new NotFn<S>(fn);
    }

    public static <S> FilterFn<S> ACCEPT_ALL() {
        return new AcceptAllFn();
    }

    public static <S> FilterFn<S> REJECT_ALL() {
        return FilterFns.not(new AcceptAllFn());
    }

    private static class AcceptAllFn<S>
    extends FilterFn<S> {
        private AcceptAllFn() {
        }

        @Override
        public boolean accept(S input) {
            return true;
        }

        @Override
        public float scaleFactor() {
            return 1.0f;
        }
    }

    private static class NotFn<S>
    extends FilterFn<S> {
        private final FilterFn<S> base;

        public NotFn(FilterFn<S> base) {
            this.base = base;
        }

        @Override
        public void configure(Configuration conf) {
            this.base.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.base.setContext(context);
        }

        @Override
        public void initialize() {
            this.base.initialize();
        }

        @Override
        public void cleanup() {
            this.base.cleanup();
        }

        @Override
        public boolean accept(S input) {
            return !this.base.accept(input);
        }

        @Override
        public float scaleFactor() {
            return 1.0f - this.base.scaleFactor();
        }
    }

    private static class OrFn<S>
    extends FilterFn<S> {
        private final List<FilterFn<S>> fns;

        public OrFn(FilterFn<S> ... fns) {
            this.fns = ImmutableList.copyOf((Object[])fns);
        }

        @Override
        public void configure(Configuration conf) {
            for (FilterFn<S> fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (FilterFn<S> fn : this.fns) {
                fn.setContext(context);
            }
        }

        @Override
        public void initialize() {
            for (FilterFn<S> fn : this.fns) {
                fn.initialize();
            }
        }

        @Override
        public void cleanup() {
            for (FilterFn<S> fn : this.fns) {
                fn.cleanup();
            }
        }

        @Override
        public boolean accept(S input) {
            for (FilterFn<S> fn : this.fns) {
                if (!fn.accept(input)) continue;
                return true;
            }
            return false;
        }

        @Override
        public float scaleFactor() {
            float scaleFactor = 0.0f;
            for (FilterFn<S> fn : this.fns) {
                scaleFactor += fn.scaleFactor();
            }
            return Math.min(1.0f, scaleFactor);
        }
    }

    private static class AndFn<S>
    extends FilterFn<S> {
        private final List<FilterFn<S>> fns;

        public AndFn(FilterFn<S> ... fns) {
            this.fns = ImmutableList.copyOf((Object[])fns);
        }

        @Override
        public void configure(Configuration conf) {
            for (FilterFn<S> fn : this.fns) {
                fn.configure(conf);
            }
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            for (FilterFn<S> fn : this.fns) {
                fn.setContext(context);
            }
        }

        @Override
        public void initialize() {
            for (FilterFn<S> fn : this.fns) {
                fn.initialize();
            }
        }

        @Override
        public void cleanup() {
            for (FilterFn<S> fn : this.fns) {
                fn.cleanup();
            }
        }

        @Override
        public boolean accept(S input) {
            for (FilterFn<S> fn : this.fns) {
                if (fn.accept(input)) continue;
                return false;
            }
            return true;
        }

        @Override
        public float scaleFactor() {
            float scaleFactor = 1.0f;
            for (FilterFn<S> fn : this.fns) {
                scaleFactor *= fn.scaleFactor();
            }
            return scaleFactor;
        }
    }
}

