/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.PCollection;
import org.apache.crunch.Pipeline;
import org.apache.crunch.Target;
import org.apache.hadoop.conf.Configuration;
import parquet.Preconditions;

public abstract class PipelineCallable<Output>
implements Callable<Status> {
    private static final Log LOG = LogFactory.getLog(PipelineCallable.class);
    private String name;
    private String message;
    private Map<String, Target> namedTargets = Maps.newHashMap();
    private Map<String, PCollection<?>> namedPCollections = Maps.newHashMap();
    private Configuration conf;
    private boolean outputsGenerated = false;

    protected abstract Output getOutput(Pipeline var1);

    public boolean runSingleThreaded() {
        return false;
    }

    public PipelineCallable<Output> dependsOn(String label, Target t) {
        Preconditions.checkNotNull((Object)label, (String)"label");
        if (this.outputsGenerated) {
            throw new IllegalStateException("Dependencies may not be added to a PipelineCallable after its outputs have been generated");
        }
        if (this.namedTargets.containsKey(label)) {
            throw new IllegalStateException("Label " + label + " cannot be reused for multiple targets");
        }
        this.namedTargets.put(label, t);
        return this;
    }

    public PipelineCallable<Output> dependsOn(String label, PCollection<?> pcollect) {
        Preconditions.checkNotNull((Object)label, (String)"label");
        if (this.outputsGenerated) {
            throw new IllegalStateException("Dependencies may not be added to a PipelineCallable after its outputs have been generated");
        }
        if (this.namedPCollections.containsKey(label)) {
            throw new IllegalStateException("Label " + label + " cannot be reused for multiple PCollections");
        }
        this.namedPCollections.put(label, pcollect);
        return this;
    }

    public Output generateOutput(Pipeline pipeline) {
        if (this.outputsGenerated) {
            throw new IllegalStateException("PipelineCallable.generateOutput should only be called once");
        }
        this.outputsGenerated = true;
        this.conf = pipeline.getConfiguration();
        return this.getOutput(pipeline);
    }

    public String getName() {
        return this.name == null ? this.getClass().getName() : this.name;
    }

    public PipelineCallable<Output> named(String name) {
        this.name = name;
        return this;
    }

    public String getMessage() {
        if (this.message == null) {
            LOG.warn((Object)("No message specified for PipelineCallable instance \"" + this.getName() + "\". Consider overriding PipelineCallable.getMessage()"));
            return this.toString();
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected Configuration getConfiguration() {
        return this.conf;
    }

    protected Target getTarget(String label) {
        return this.namedTargets.get(label);
    }

    protected PCollection getPCollection(String label) {
        return this.namedPCollections.get(label);
    }

    protected PCollection getOnlyPCollection() {
        return (PCollection)Iterables.getOnlyElement(this.namedPCollections.values());
    }

    public Map<String, PCollection<?>> getAllPCollections() {
        return ImmutableMap.copyOf(this.namedPCollections);
    }

    public Map<String, Target> getAllTargets() {
        return ImmutableMap.copyOf(this.namedTargets);
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

