/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.Tuple;

public class Pair<K, V>
implements Tuple,
Comparable<Pair<K, V>>,
Serializable {
    private final K first;
    private final V second;

    public static <T, U> Pair<T, U> of(T first, U second) {
        return new Pair<T, U>(first, second);
    }

    public Pair(K first, V second) {
        this.first = first;
        this.second = second;
    }

    public K first() {
        return this.first;
    }

    public V second() {
        return this.second;
    }

    @Override
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return 2;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append(this.first).append(this.second).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        return (this.first == other.first || this.first != null && this.first.equals(other.first)) && (this.second == other.second || this.second != null && this.second.equals(other.second));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.first).append(",").append(this.second).append("]");
        return sb.toString();
    }

    private int cmp(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs != null && Comparable.class.isAssignableFrom(lhs.getClass())) {
            return ((Comparable)lhs).compareTo(rhs);
        }
        return (lhs == null ? 0 : lhs.hashCode()) - (rhs == null ? 0 : rhs.hashCode());
    }

    @Override
    public int compareTo(Pair<K, V> o) {
        int diff = this.cmp(this.first, o.first);
        if (diff == 0) {
            diff = this.cmp(this.second, o.second);
        }
        return diff;
    }
}

