/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.SourceTarget;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;

public class GroupingOptions
implements Serializable {
    private final Class<? extends Partitioner> partitionerClass;
    private final Class<? extends RawComparator> groupingComparatorClass;
    private final Class<? extends RawComparator> sortComparatorClass;
    private final boolean requireSortedKeys;
    private final int numReducers;
    private final Map<String, String> extraConf;
    private transient Set<SourceTarget<?>> sourceTargets;

    private GroupingOptions(Class<? extends Partitioner> partitionerClass, Class<? extends RawComparator> groupingComparatorClass, Class<? extends RawComparator> sortComparatorClass, boolean requireSortedKeys, int numReducers, Map<String, String> extraConf, Set<SourceTarget<?>> sourceTargets) {
        this.partitionerClass = partitionerClass;
        this.groupingComparatorClass = groupingComparatorClass;
        this.sortComparatorClass = sortComparatorClass;
        this.requireSortedKeys = requireSortedKeys;
        this.numReducers = numReducers;
        this.extraConf = extraConf;
        this.sourceTargets = sourceTargets;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public boolean requireSortedKeys() {
        return this.requireSortedKeys;
    }

    public Class<? extends RawComparator> getSortComparatorClass() {
        return this.sortComparatorClass;
    }

    public Class<? extends RawComparator> getGroupingComparatorClass() {
        return this.groupingComparatorClass;
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.partitionerClass;
    }

    public Set<SourceTarget<?>> getSourceTargets() {
        return this.sourceTargets;
    }

    public void configure(Job job) {
        if (this.partitionerClass != null) {
            job.setPartitionerClass(this.partitionerClass);
        }
        if (this.groupingComparatorClass != null) {
            job.setGroupingComparatorClass(this.groupingComparatorClass);
        }
        if (this.sortComparatorClass != null) {
            job.setSortComparatorClass(this.sortComparatorClass);
        }
        if (this.numReducers > 0) {
            job.setNumReduceTasks(this.numReducers);
        }
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            job.getConfiguration().set(e.getKey(), e.getValue());
        }
    }

    public boolean isCompatibleWith(GroupingOptions other) {
        if (this.partitionerClass != other.partitionerClass) {
            return false;
        }
        if (this.groupingComparatorClass != other.groupingComparatorClass) {
            return false;
        }
        if (this.sortComparatorClass != other.sortComparatorClass) {
            return false;
        }
        return this.extraConf.equals(other.extraConf);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Class<? extends Partitioner> partitionerClass;
        private Class<? extends RawComparator> groupingComparatorClass;
        private Class<? extends RawComparator> sortComparatorClass;
        private boolean requireSortedKeys;
        private int numReducers;
        private Map<String, String> extraConf = Maps.newHashMap();
        private Set<SourceTarget<?>> sourceTargets = Sets.newHashSet();

        public Builder partitionerClass(Class<? extends Partitioner> partitionerClass) {
            this.partitionerClass = partitionerClass;
            return this;
        }

        public Builder groupingComparatorClass(Class<? extends RawComparator> groupingComparatorClass) {
            this.groupingComparatorClass = groupingComparatorClass;
            return this;
        }

        public Builder sortComparatorClass(Class<? extends RawComparator> sortComparatorClass) {
            this.sortComparatorClass = sortComparatorClass;
            return this;
        }

        public Builder requireSortedKeys() {
            this.requireSortedKeys = true;
            return this;
        }

        public Builder numReducers(int numReducers) {
            if (numReducers <= 0) {
                throw new IllegalArgumentException("Invalid number of reducers: " + numReducers);
            }
            this.numReducers = numReducers;
            return this;
        }

        public Builder conf(String confKey, String confValue) {
            this.extraConf.put(confKey, confValue);
            return this;
        }

        @Deprecated
        public Builder sourceTarget(SourceTarget<?> st) {
            this.sourceTargets.add(st);
            return this;
        }

        public Builder sourceTargets(SourceTarget<?> ... st) {
            Collections.addAll(this.sourceTargets, st);
            return this;
        }

        public Builder sourceTargets(Collection<SourceTarget<?>> st) {
            this.sourceTargets.addAll(st);
            return this;
        }

        public GroupingOptions build() {
            return new GroupingOptions(this.partitionerClass, this.groupingComparatorClass, this.sortComparatorClass, this.requireSortedKeys, this.numReducers, this.extraConf, this.sourceTargets);
        }
    }
}

