/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.PropertyDispatcher;

public interface AnnotationDescription {
    public Object getValue(MethodDescription var1);

    public <T> T getValue(MethodDescription var1, Class<T> var2);

    public TypeDescription getAnnotationType();

    public <T extends Annotation> Loadable<T> prepare(Class<T> var1);

    public static class Builder {
        protected final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        public static Builder forType(Class<? extends Annotation> annotationType) {
            return Builder.forType(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(annotationType)));
        }

        public static Builder forType(TypeDescription annotationType) {
            if (!annotationType.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + annotationType);
            }
            return new Builder(annotationType, Collections.<String, AnnotationValue<?, ?>>emptyMap());
        }

        protected Builder(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        public Builder define(String property, AnnotationValue<?, ?> value) {
            MethodList methodDescriptions = (MethodList)this.annotationType.getDeclaredMethods().filter(ElementMatchers.named(ByteBuddyCommons.nonNull(property)));
            if (methodDescriptions.isEmpty()) {
                throw new IllegalArgumentException(this.annotationType + " does not define a property named " + property);
            }
            if (!((MethodDescription)methodDescriptions.getOnly()).getReturnType().isAnnotationValue(value.resolve())) {
                throw new IllegalArgumentException(value + " cannot be assigned to " + property);
            }
            HashMap annotationValues = new HashMap(this.annotationValues.size() + 1);
            annotationValues.putAll(this.annotationValues);
            if (annotationValues.put(((MethodDescription)methodDescriptions.getOnly()).getName(), ByteBuddyCommons.nonNull(value)) != null) {
                throw new IllegalArgumentException("Property already defined: " + property);
            }
            return new Builder(this.annotationType, annotationValues);
        }

        public Builder define(String property, Enum<?> value) {
            return this.define(property, new EnumerationDescription.ForLoadedEnumeration(ByteBuddyCommons.nonNull(value)));
        }

        public Builder define(String property, TypeDescription enumerationType, String value) {
            return this.define(property, new EnumerationDescription.Latent(ByteBuddyCommons.nonNull(enumerationType), ByteBuddyCommons.nonNull(value)));
        }

        public Builder define(String property, EnumerationDescription value) {
            return this.define(property, AnnotationValue.ForEnumeration.of(ByteBuddyCommons.nonNull(value)));
        }

        public Builder define(String property, Annotation annotation) {
            return this.define(property, new ForLoadedAnnotation<Annotation>(ByteBuddyCommons.nonNull(annotation)));
        }

        public Builder define(String property, AnnotationDescription annotationDescription) {
            return this.define(property, new AnnotationValue.ForAnnotation(ByteBuddyCommons.nonNull(annotationDescription)));
        }

        public Builder define(String property, Class<?> type) {
            return this.define(property, new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)));
        }

        public Builder define(String property, TypeDescription typeDescription) {
            return this.define(property, AnnotationValue.ForType.of(typeDescription));
        }

        public <T extends Enum<?>> Builder defineEnumerationArray(String property, Class<T> enumerationType, T ... value) {
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            int index = 0;
            for (T aValue : value) {
                enumerationDescription[index++] = new EnumerationDescription.ForLoadedEnumeration((Enum)ByteBuddyCommons.nonNull(aValue));
            }
            return this.defineEnumerationArray(property, (TypeDescription)new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(enumerationType)), enumerationDescription);
        }

        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, String ... value) {
            if (!enumerationType.isEnum()) {
                throw new IllegalArgumentException("Not an enumeration type: " + enumerationType);
            }
            EnumerationDescription[] enumerationDescription = new EnumerationDescription[value.length];
            for (int i = 0; i < value.length; ++i) {
                enumerationDescription[i] = new EnumerationDescription.Latent(ByteBuddyCommons.nonNull(enumerationType), ByteBuddyCommons.nonNull(value[i]));
            }
            return this.defineEnumerationArray(property, enumerationType, enumerationDescription);
        }

        public Builder defineEnumerationArray(String property, TypeDescription enumerationType, EnumerationDescription ... value) {
            return this.define(property, AnnotationValue.ForComplexArray.of(enumerationType, ByteBuddyCommons.nonNull(value)));
        }

        public <T extends Annotation> Builder defineAnnotationArray(String property, Class<T> annotationType, T ... annotation) {
            return this.defineAnnotationArray(property, new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(annotationType)), new AnnotationList.ForLoadedAnnotation((Annotation[])ByteBuddyCommons.nonNull(annotation)).toArray(new AnnotationDescription[annotation.length]));
        }

        public Builder defineAnnotationArray(String property, TypeDescription annotationType, AnnotationDescription ... annotationDescription) {
            return this.define(property, AnnotationValue.ForComplexArray.of(annotationType, ByteBuddyCommons.nonNull(annotationDescription)));
        }

        public Builder defineTypeArray(String property, Class<?> ... type) {
            return this.defineTypeArray(property, new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(type)).toArray(new TypeDescription[type.length]));
        }

        public Builder defineTypeArray(String property, TypeDescription ... typeDescription) {
            return this.define(property, AnnotationValue.ForComplexArray.of(typeDescription));
        }

        public Builder define(String property, boolean value) {
            return this.define(property, new AnnotationValue.Trivial<Boolean>(value));
        }

        public Builder define(String property, byte value) {
            return this.define(property, new AnnotationValue.Trivial<Byte>(value));
        }

        public Builder define(String property, char value) {
            return this.define(property, new AnnotationValue.Trivial<Character>(Character.valueOf(value)));
        }

        public Builder define(String property, short value) {
            return this.define(property, new AnnotationValue.Trivial<Short>(value));
        }

        public Builder define(String property, int value) {
            return this.define(property, new AnnotationValue.Trivial<Integer>(value));
        }

        public Builder define(String property, long value) {
            return this.define(property, new AnnotationValue.Trivial<Long>(value));
        }

        public Builder define(String property, float value) {
            return this.define(property, new AnnotationValue.Trivial<Float>(Float.valueOf(value)));
        }

        public Builder define(String property, double value) {
            return this.define(property, new AnnotationValue.Trivial<Double>(value));
        }

        public Builder define(String property, String value) {
            return this.define(property, new AnnotationValue.Trivial<String>(value));
        }

        public Builder defineArray(String property, boolean ... value) {
            return this.define(property, new AnnotationValue.Trivial<boolean[]>(value));
        }

        public Builder defineArray(String property, byte ... value) {
            return this.define(property, new AnnotationValue.Trivial<byte[]>(value));
        }

        public Builder defineArray(String property, char ... value) {
            return this.define(property, new AnnotationValue.Trivial<char[]>(value));
        }

        public Builder defineArray(String property, short ... value) {
            return this.define(property, new AnnotationValue.Trivial<short[]>(value));
        }

        public Builder defineArray(String property, int ... value) {
            return this.define(property, new AnnotationValue.Trivial<int[]>(value));
        }

        public Builder defineArray(String property, long ... value) {
            return this.define(property, new AnnotationValue.Trivial<long[]>(value));
        }

        public Builder defineArray(String property, float ... value) {
            return this.define(property, new AnnotationValue.Trivial<float[]>(value));
        }

        public Builder defineArray(String property, double ... value) {
            return this.define(property, new AnnotationValue.Trivial<double[]>(value));
        }

        public Builder defineArray(String property, String ... value) {
            return this.define(property, new AnnotationValue.Trivial<String[]>(value));
        }

        public AnnotationDescription make() {
            for (MethodDescription methodDescription : this.annotationType.getDeclaredMethods()) {
                if (this.annotationValues.get(methodDescription.getName()) != null || methodDescription.getDefaultValue() != null) continue;
                throw new IllegalStateException("No value or default value defined for " + methodDescription.getName());
            }
            return new Latent(this.annotationType, this.annotationValues);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotationType.equals(((Builder)other).annotationType) && this.annotationValues.equals(((Builder)other).annotationValues);
        }

        public int hashCode() {
            int result = this.annotationType.hashCode();
            result = 31 * result + this.annotationValues.hashCode();
            return result;
        }

        public String toString() {
            return "AnnotationDescription.Builder{annotationType=" + this.annotationType + ", annotationValues=" + this.annotationValues + '}';
        }
    }

    public static class Latent
    extends AbstractAnnotationDescription {
        private final TypeDescription annotationType;
        private final Map<String, AnnotationValue<?, ?>> annotationValues;

        protected Latent(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
            this.annotationType = annotationType;
            this.annotationValues = annotationValues;
        }

        @Override
        public Object getValue(MethodDescription methodDescription) {
            AnnotationValue<?, ?> value = this.annotationValues.get(methodDescription.getName());
            if (value != null) {
                return value.resolve();
            }
            Object defaultValue = methodDescription.getDefaultValue();
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new IllegalArgumentException("No value defined for: " + methodDescription);
        }

        @Override
        public TypeDescription getAnnotationType() {
            return this.annotationType;
        }

        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (!this.annotationType.represents(annotationType)) {
                throw new IllegalArgumentException("Not a compatible annotation type: " + annotationType);
            }
            return new Loadable<T>(annotationType);
        }

        protected class Loadable<S extends Annotation>
        extends AbstractAnnotationDescription.ForPrepared<S> {
            private final Class<S> annotationType;

            protected Loadable(Class<S> annotationType) {
                this.annotationType = annotationType;
            }

            @Override
            public S load() throws ClassNotFoundException {
                return this.load(this.annotationType.getClassLoader());
            }

            @Override
            public S load(ClassLoader classLoader) throws ClassNotFoundException {
                return (S)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{this.annotationType}, AnnotationInvocationHandler.of(classLoader, this.annotationType, Latent.this.annotationValues)));
            }

            @Override
            public Object getValue(MethodDescription methodDescription) {
                return Latent.this.getValue(methodDescription);
            }

            @Override
            public TypeDescription getAnnotationType() {
                return Latent.this.getAnnotationType();
            }

            @Override
            public <T extends Annotation> net.bytebuddy.description.annotation.AnnotationDescription$Loadable<T> prepare(Class<T> annotationType) {
                return Latent.this.prepare((Class)annotationType);
            }
        }
    }

    public static class ForLoadedAnnotation<S extends Annotation>
    extends AbstractAnnotationDescription.ForPrepared<S>
    implements Loadable<S> {
        private final S annotation;

        protected ForLoadedAnnotation(S annotation) {
            this.annotation = annotation;
        }

        public static <U extends Annotation> Loadable<U> of(U annotation) {
            return new ForLoadedAnnotation<U>(annotation);
        }

        public static Object describe(Object value, TypeDescription typeDescription) {
            if (typeDescription.represents(Class.class)) {
                value = new TypeDescription.ForLoadedType((Class)value);
            } else if (typeDescription.represents(Class[].class)) {
                value = new TypeList.ForLoadedType((Class[])value).toArray(new TypeDescription[((Class[])value).length]);
            } else if (typeDescription.isAssignableTo(Enum.class)) {
                value = new EnumerationDescription.ForLoadedEnumeration((Enum)value);
            } else if (typeDescription.isAssignableTo(Enum[].class)) {
                value = EnumerationDescription.ForLoadedEnumeration.asList((Enum[])value).toArray(new EnumerationDescription[((Enum[])value).length]);
            } else if (typeDescription.isAssignableTo(Annotation.class)) {
                value = ForLoadedAnnotation.of((Annotation)value);
            } else if (typeDescription.isAssignableTo(Annotation[].class)) {
                value = new AnnotationList.ForLoadedAnnotation((Annotation[])value).toArray(new AnnotationDescription[((Annotation[])value).length]);
            }
            return value;
        }

        @Override
        public S load() {
            return this.annotation;
        }

        @Override
        public S load(ClassLoader classLoader) {
            ClassLoader otherClassLoader;
            ClassLoader thisClassLoader = this.annotation.getClass().getClassLoader();
            for (otherClassLoader = classLoader; otherClassLoader != null && otherClassLoader != thisClassLoader; otherClassLoader = otherClassLoader.getParent()) {
            }
            if (otherClassLoader != thisClassLoader) {
                throw new IllegalArgumentException(this.annotation + " is not loaded using " + classLoader);
            }
            return this.load();
        }

        @Override
        public Object getValue(MethodDescription methodDescription) {
            if (!methodDescription.getDeclaringType().represents(this.annotation.annotationType())) {
                throw new IllegalArgumentException(methodDescription + " does not represent " + this.annotation.annotationType());
            }
            try {
                Method method;
                boolean visible = methodDescription.isVisibleTo(new TypeDescription.ForLoadedType(this.getClass()));
                Method method2 = method = methodDescription instanceof MethodDescription.ForLoadedMethod ? ((MethodDescription.ForLoadedMethod)methodDescription).getLoadedMethod() : null;
                if (method == null || !visible && !method.isAccessible()) {
                    method = this.annotation.annotationType().getDeclaredMethod(methodDescription.getName(), new Class[0]);
                    if (!visible) {
                        method.setAccessible(true);
                    }
                }
                return ForLoadedAnnotation.describe(method.invoke(this.annotation, new Object[0]), methodDescription.getReturnType());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot access annotation property " + methodDescription, e);
            }
        }

        @Override
        public <T extends Annotation> Loadable<T> prepare(Class<T> annotationType) {
            if (this.annotation.annotationType() != annotationType) {
                throw new IllegalArgumentException(this.annotation + " type is not of identical to " + annotationType);
            }
            return this;
        }

        @Override
        public TypeDescription getAnnotationType() {
            return new TypeDescription.ForLoadedType(this.annotation.annotationType());
        }
    }

    public static abstract class AbstractAnnotationDescription
    implements AnnotationDescription {
        @Override
        public <T> T getValue(MethodDescription methodDescription, Class<T> type) {
            return type.cast(this.getValue(methodDescription));
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof AnnotationDescription)) {
                return false;
            }
            AnnotationDescription annotationDescription = (AnnotationDescription)other;
            if (!annotationDescription.getAnnotationType().equals(this.getAnnotationType())) {
                return false;
            }
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription);
                if (PropertyDispatcher.of(value.getClass()).equals(value, annotationDescription.getValue(methodDescription))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                Object value = this.getValue(methodDescription);
                hashCode += 31 * PropertyDispatcher.of(value.getClass()).hashCode(value);
            }
            return hashCode;
        }

        public String toString() {
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            toString.append(this.getAnnotationType().getName());
            toString.append('(');
            boolean firstMember = true;
            for (MethodDescription methodDescription : this.getAnnotationType().getDeclaredMethods()) {
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                toString.append(methodDescription.getName());
                toString.append('=');
                Object value = this.getValue(methodDescription);
                toString.append(PropertyDispatcher.of(value.getClass()).toString(value));
            }
            toString.append(')');
            return toString.toString();
        }

        public static abstract class ForPrepared<S extends Annotation>
        extends AbstractAnnotationDescription
        implements Loadable<S> {
            public static final String ERROR_MESSAGE = "Could not load a type that is linked by the annotation value";

            @Override
            public S loadSilent() {
                try {
                    return this.load();
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(ERROR_MESSAGE, e);
                }
            }

            @Override
            public S loadSilent(ClassLoader classLoader) {
                try {
                    return this.load(classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(ERROR_MESSAGE, e);
                }
            }
        }
    }

    public static interface Loadable<S extends Annotation>
    extends AnnotationDescription {
        public S load() throws ClassNotFoundException;

        public S load(ClassLoader var1) throws ClassNotFoundException;

        public S loadSilent();

        public S loadSilent(ClassLoader var1);
    }

    public static class AnnotationInvocationHandler<T extends Annotation>
    implements InvocationHandler {
        private static final String HASH_CODE = "hashCode";
        private static final String EQUALS = "equals";
        private static final String TO_STRING = "toString";
        private final ClassLoader classLoader;
        private final Class<? extends Annotation> annotationType;
        private final LinkedHashMap<Method, AnnotationValue.Loaded<?>> values;

        public static <S extends Annotation> InvocationHandler of(ClassLoader classLoader, Class<S> annotationType, Map<String, AnnotationValue<?, ?>> values) throws ClassNotFoundException {
            Method[] declaredMethod = annotationType.getDeclaredMethods();
            LinkedHashMap loadedValues = new LinkedHashMap(declaredMethod.length);
            Method[] methodArray = declaredMethod;
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method method;
                AnnotationValue<?, ?> annotationValue = values.get((method = methodArray[i]).getName());
                loadedValues.put(method, annotationValue == null ? DefaultValue.of(method) : annotationValue.load(classLoader));
            }
            return new AnnotationInvocationHandler<S>(classLoader, annotationType, loadedValues);
        }

        protected AnnotationInvocationHandler(ClassLoader classLoader, Class<T> annotationType, LinkedHashMap<Method, AnnotationValue.Loaded<?>> values) {
            this.classLoader = classLoader;
            this.annotationType = annotationType;
            this.values = values;
        }

        private static Class<?> asWrapper(Class<?> type) {
            if (type.isPrimitive()) {
                if (type == Boolean.TYPE) {
                    return Boolean.class;
                }
                if (type == Byte.TYPE) {
                    return Byte.class;
                }
                if (type == Short.TYPE) {
                    return Short.class;
                }
                if (type == Character.TYPE) {
                    return Character.class;
                }
                if (type == Integer.TYPE) {
                    return Integer.class;
                }
                if (type == Long.TYPE) {
                    return Long.class;
                }
                if (type == Float.TYPE) {
                    return Float.class;
                }
                if (type == Double.TYPE) {
                    return Double.class;
                }
            }
            return type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) {
            if (method.getDeclaringClass() != this.annotationType) {
                if (method.getName().equals(HASH_CODE)) {
                    return this.hashCodeRepresentation();
                }
                if (method.getName().equals(EQUALS) && method.getParameterTypes().length == 1) {
                    return this.equalsRepresentation(proxy, arguments[0]);
                }
                if (method.getName().equals(TO_STRING)) {
                    return this.toStringRepresentation();
                }
                return this.annotationType;
            }
            Object value = this.values.get(method).resolve();
            if (!AnnotationInvocationHandler.asWrapper(method.getReturnType()).isAssignableFrom(value.getClass())) {
                throw new AnnotationTypeMismatchException(method, value.getClass().toString());
            }
            return value;
        }

        protected String toStringRepresentation() {
            StringBuilder toString = new StringBuilder();
            toString.append('@');
            toString.append(this.annotationType.getName());
            toString.append('(');
            boolean firstMember = true;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                if (firstMember) {
                    firstMember = false;
                } else {
                    toString.append(", ");
                }
                toString.append(entry.getKey().getName());
                toString.append('=');
                toString.append(entry.getValue().toString());
            }
            toString.append(')');
            return toString.toString();
        }

        private int hashCodeRepresentation() {
            int hashCode = 0;
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                if (!entry.getValue().getState().isDefined()) continue;
                hashCode += 127 * entry.getKey().getName().hashCode() ^ entry.getValue().hashCode();
            }
            return hashCode;
        }

        private boolean equalsRepresentation(Object self, Object other) {
            Object invocationHandler;
            if (self == other) {
                return true;
            }
            if (!this.annotationType.isInstance(other)) {
                return false;
            }
            if (Proxy.isProxyClass(other.getClass()) && (invocationHandler = Proxy.getInvocationHandler(other)) instanceof AnnotationInvocationHandler) {
                return invocationHandler.equals(this);
            }
            try {
                for (Map.Entry entry : this.values.entrySet()) {
                    if (((AnnotationValue.Loaded)entry.getValue()).getState().isResolved()) {
                        try {
                            if (PropertyDispatcher.of(((Method)entry.getKey()).getReturnType()).equals(((AnnotationValue.Loaded)entry.getValue()).resolve(), ((Method)entry.getKey()).invoke(other, new Object[0]))) continue;
                            return false;
                        }
                        catch (RuntimeException e) {
                            return false;
                        }
                    }
                    return false;
                }
            }
            catch (InvocationTargetException ignored) {
                return false;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationInvocationHandler)) {
                return false;
            }
            AnnotationInvocationHandler that = (AnnotationInvocationHandler)other;
            if (!this.annotationType.equals(that.annotationType)) {
                return false;
            }
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                AnnotationValue.Loaded<?> value = that.values.get(entry.getKey());
                if (PropertyDispatcher.of(value.getClass()).equals(value, entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.annotationType.hashCode();
            result = 31 * result + this.values.hashCode();
            for (Map.Entry<Method, AnnotationValue.Loaded<?>> entry : this.values.entrySet()) {
                result = 31 * result + PropertyDispatcher.of(entry.getValue().getClass()).hashCode(entry.getValue());
            }
            return result;
        }

        public String toString() {
            return "TypePool.LazyTypeDescription.AnnotationInvocationHandler{annotationType=" + this.annotationType + ", classLoader=" + this.classLoader + ", values=" + this.values + '}';
        }

        private static class Missing
        implements AnnotationValue.Loaded<Void> {
            private final Class<? extends Annotation> annotationType;
            private final String property;

            private Missing(Class<? extends Annotation> annotationType, String property) {
                this.annotationType = annotationType;
                this.property = property;
            }

            @Override
            public AnnotationValue.Loaded.State getState() {
                return AnnotationValue.Loaded.State.NON_DEFINED;
            }

            @Override
            public Void resolve() {
                throw new IncompleteAnnotationException(this.annotationType, this.property);
            }
        }

        protected static class DefaultValue
        implements AnnotationValue.Loaded<Object> {
            private final Object defaultValue;
            private final PropertyDispatcher propertyDispatcher;

            private DefaultValue(Object defaultValue) {
                this.defaultValue = defaultValue;
                this.propertyDispatcher = PropertyDispatcher.of(defaultValue.getClass());
            }

            protected static AnnotationValue.Loaded<?> of(Method method) {
                Object defaultValue = method.getDefaultValue();
                return defaultValue == null ? new Missing(method.getDeclaringClass(), method.getName()) : new DefaultValue(defaultValue);
            }

            @Override
            public AnnotationValue.Loaded.State getState() {
                return AnnotationValue.Loaded.State.RESOLVED;
            }

            @Override
            public Object resolve() {
                return this.propertyDispatcher.conditionalClone(this.defaultValue);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationValue.Loaded)) {
                    return false;
                }
                AnnotationValue.Loaded loaded = (AnnotationValue.Loaded)other;
                return loaded.getState().isResolved() && this.propertyDispatcher.equals(this.defaultValue, loaded.resolve());
            }

            public int hashCode() {
                return this.propertyDispatcher.hashCode(this.defaultValue);
            }

            public String toString() {
                return this.propertyDispatcher.toString(this.defaultValue);
            }
        }
    }

    public static interface AnnotationValue<T, S> {
        public T resolve();

        public Loaded<S> load(ClassLoader var1) throws ClassNotFoundException;

        public static class ForComplexArray<U, V>
        implements AnnotationValue<U[], V[]> {
            private final Class<?> unloadedComponentType;
            private final TypeDescription componentType;
            private final List<? extends AnnotationValue<?, ?>> annotationValues;

            protected ForComplexArray(Class<?> unloadedComponentType, TypeDescription componentType, List<? extends AnnotationValue<?, ?>> annotationValues) {
                this.unloadedComponentType = unloadedComponentType;
                this.componentType = componentType;
                this.annotationValues = annotationValues;
            }

            @Override
            public U[] resolve() {
                Object[] value = (Object[])Array.newInstance(this.unloadedComponentType, this.annotationValues.size());
                int index = 0;
                for (AnnotationValue<?, ?> annotationValue : this.annotationValues) {
                    Array.set(value, index++, annotationValue.resolve());
                }
                return value;
            }

            @Override
            public net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<V[]> load(ClassLoader classLoader) throws ClassNotFoundException {
                ArrayList loadedValues = new ArrayList(this.annotationValues.size());
                for (AnnotationValue<?, ?> value : this.annotationValues) {
                    loadedValues.add(value.load(classLoader));
                }
                return new Loaded(classLoader.loadClass(this.componentType.getName()), loadedValues);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForComplexArray that = (ForComplexArray)other;
                return this.annotationValues.equals(that.annotationValues) && this.componentType.equals(that.componentType) && this.unloadedComponentType.equals(that.unloadedComponentType);
            }

            public int hashCode() {
                int result = this.unloadedComponentType.hashCode();
                result = 31 * result + this.componentType.hashCode();
                result = 31 * result + this.annotationValues.hashCode();
                return result;
            }

            public String toString() {
                return "AnnotationDescription.AnnotationValue.ForComplexArra{unloadedComponentType=" + this.unloadedComponentType + ", componentType=" + this.componentType + ", annotationValues=" + this.annotationValues + '}';
            }

            public static <W extends Enum<W>> AnnotationValue<EnumerationDescription[], W[]> of(TypeDescription enumerationType, EnumerationDescription[] enumerationDescription) {
                ArrayList values = new ArrayList(enumerationDescription.length);
                for (EnumerationDescription value : enumerationDescription) {
                    if (!value.getEnumerationType().equals(enumerationType)) {
                        throw new IllegalArgumentException(value + " is not of " + enumerationType);
                    }
                    values.add(ForEnumeration.of(value));
                }
                return new ForComplexArray(EnumerationDescription.class, enumerationType, values);
            }

            public static <W extends Annotation> AnnotationValue<AnnotationDescription[], W[]> of(TypeDescription annotationType, AnnotationDescription[] annotationDescription) {
                ArrayList values = new ArrayList(annotationDescription.length);
                for (AnnotationDescription value : annotationDescription) {
                    if (!value.getAnnotationType().equals(annotationType)) {
                        throw new IllegalArgumentException(value + " is not of " + annotationType);
                    }
                    values.add(new ForAnnotation(value));
                }
                return new ForComplexArray(AnnotationDescription.class, annotationType, values);
            }

            public static AnnotationValue<TypeDescription[], Class<?>[]> of(TypeDescription[] typeDescription) {
                ArrayList values = new ArrayList(typeDescription.length);
                for (TypeDescription value : typeDescription) {
                    values.add(ForType.of(value));
                }
                return new ForComplexArray(TypeDescription.class, TypeDescription.CLASS, values);
            }

            protected static class Loaded<W>
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<W[]> {
                private final Class<W> componentType;
                private final List<net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?>> values;

                protected Loaded(Class<W> componentType, List<net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?>> values) {
                    this.componentType = componentType;
                    this.values = values;
                }

                @Override
                public Loaded.State getState() {
                    for (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?> value : this.values) {
                        if (value.getState().isResolved()) continue;
                        return Loaded.State.NON_RESOLVED;
                    }
                    return Loaded.State.RESOLVED;
                }

                @Override
                public W[] resolve() {
                    Object[] array = (Object[])Array.newInstance(this.componentType, this.values.size());
                    int index = 0;
                    for (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?> annotationValue : this.values) {
                        Array.set(array, index++, annotationValue.resolve());
                    }
                    return array;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)) {
                        return false;
                    }
                    net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)other;
                    if (!loadedOther.getState().isResolved()) {
                        return false;
                    }
                    Object otherValue = loadedOther.resolve();
                    if (!(otherValue instanceof Object[])) {
                        return false;
                    }
                    Object[] otherArrayValue = (Object[])otherValue;
                    if (this.values.size() != otherArrayValue.length) {
                        return false;
                    }
                    Iterator<net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?>> iterator = this.values.iterator();
                    for (Object value : otherArrayValue) {
                        net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?> self = iterator.next();
                        if (self.getState().isResolved() && self.resolve().equals(value)) continue;
                        return false;
                    }
                    return true;
                }

                public int hashCode() {
                    int result = 1;
                    for (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?> value : this.values) {
                        result = 31 * result + value.hashCode();
                    }
                    return result;
                }

                public String toString() {
                    StringBuilder stringBuilder = new StringBuilder("[");
                    for (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<?> value : this.values) {
                        stringBuilder.append(value.toString());
                    }
                    return stringBuilder.append("]").toString();
                }
            }
        }

        public static class ForType<U extends Class<U>>
        implements AnnotationValue<TypeDescription, U> {
            private static final boolean NO_INITIALIZATION = false;
            private final TypeDescription typeDescription;

            public static <V extends Class<V>> AnnotationValue<TypeDescription, V> of(TypeDescription typeDescription) {
                return new ForType(typeDescription);
            }

            public ForType(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public TypeDescription resolve() {
                return this.typeDescription;
            }

            @Override
            public net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
                return new Loaded(Class.forName(this.typeDescription.getName(), false, classLoader));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForType forType = (ForType)other;
                return this.typeDescription.equals(forType.typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "AnnotationDescription.AnnotationValue.ForType{typeDescription=" + this.typeDescription + '}';
            }

            protected static class Loaded<U extends Class<U>>
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<U> {
                private final U type;

                public Loaded(U type) {
                    this.type = type;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.RESOLVED;
                }

                @Override
                public U resolve() {
                    return this.type;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)) {
                        return false;
                    }
                    net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)other;
                    return loadedOther.getState().isResolved() && this.type.equals(loadedOther.resolve());
                }

                public int hashCode() {
                    return this.type.hashCode();
                }

                public String toString() {
                    return ((Class)this.type).toString();
                }
            }
        }

        public static class ForEnumeration<U extends Enum<U>>
        implements AnnotationValue<EnumerationDescription, U> {
            private final EnumerationDescription enumerationDescription;

            public static <V extends Enum<V>> AnnotationValue<EnumerationDescription, V> of(EnumerationDescription value) {
                return new ForEnumeration(value);
            }

            public ForEnumeration(EnumerationDescription enumerationDescription) {
                this.enumerationDescription = enumerationDescription;
            }

            @Override
            public EnumerationDescription resolve() {
                return this.enumerationDescription;
            }

            @Override
            public net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> enumerationType = classLoader.loadClass(this.enumerationDescription.getEnumerationType().getName());
                return new Loaded(this.enumerationDescription.load(enumerationType));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForEnumeration that = (ForEnumeration)other;
                return this.enumerationDescription.equals(that.enumerationDescription);
            }

            public int hashCode() {
                return this.enumerationDescription.hashCode();
            }

            public String toString() {
                return "AnnotationDescription.AnnotationValue.ForEnumeration{enumerationDescription=" + this.enumerationDescription + '}';
            }

            public static class IncompatibleRuntimeType
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<Enum<?>> {
                private final Class<?> type;

                public IncompatibleRuntimeType(Class<?> type) {
                    this.type = type;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.NON_RESOLVED;
                }

                @Override
                public Enum<?> resolve() {
                    throw new IncompatibleClassChangeError("Not an enumeration type: " + this.type.toString());
                }
            }

            public static class UnknownRuntimeEnumeration
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<Enum<?>> {
                private final Class<? extends Enum<?>> enumType;
                private final String value;

                public UnknownRuntimeEnumeration(Class<? extends Enum<?>> enumType, String value) {
                    this.enumType = enumType;
                    this.value = value;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.NON_RESOLVED;
                }

                @Override
                public Enum<?> resolve() {
                    throw new EnumConstantNotPresentException(this.enumType, this.value);
                }
            }

            public static class Loaded<V extends Enum<V>>
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<V> {
                private final V enumeration;

                public Loaded(V enumeration) {
                    this.enumeration = enumeration;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.RESOLVED;
                }

                @Override
                public V resolve() {
                    return this.enumeration;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)) {
                        return false;
                    }
                    Loaded loadedOther = (Loaded)other;
                    return loadedOther.getState().isResolved() && ((Enum)this.enumeration).equals(loadedOther.resolve());
                }

                public int hashCode() {
                    return ((Enum)this.enumeration).hashCode();
                }

                public String toString() {
                    return ((Enum)this.enumeration).toString();
                }
            }
        }

        public static class ForAnnotation<U extends Annotation>
        implements AnnotationValue<AnnotationDescription, U> {
            private final AnnotationDescription annotationDescription;

            public static <V extends Annotation> AnnotationValue<AnnotationDescription, V> of(TypeDescription annotationType, Map<String, AnnotationValue<?, ?>> annotationValues) {
                return new ForAnnotation(new Latent(annotationType, annotationValues));
            }

            public ForAnnotation(AnnotationDescription annotationDescription) {
                this.annotationDescription = annotationDescription;
            }

            @Override
            public AnnotationDescription resolve() {
                return this.annotationDescription;
            }

            @Override
            public net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<U> load(ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> annotationType = classLoader.loadClass(this.annotationDescription.getAnnotationType().getName());
                return new Loaded(this.annotationDescription.prepare(annotationType).load(classLoader));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForAnnotation that = (ForAnnotation)other;
                return this.annotationDescription.equals(that.annotationDescription);
            }

            public int hashCode() {
                return this.annotationDescription.hashCode();
            }

            public String toString() {
                return "AnnotationDescription.AnnotationValue.ForAnnotation{annotationDescription=" + this.annotationDescription + '}';
            }

            public static class IncompatibleRuntimeType
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<Annotation> {
                private final Class<?> incompatibleType;

                public IncompatibleRuntimeType(Class<?> incompatibleType) {
                    this.incompatibleType = incompatibleType;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.NON_RESOLVED;
                }

                @Override
                public Annotation resolve() {
                    throw new IncompatibleClassChangeError("Not an annotation type: " + this.incompatibleType.toString());
                }
            }

            public static class Loaded<V extends Annotation>
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<V> {
                private final V annotation;

                public Loaded(V annotation) {
                    this.annotation = annotation;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.RESOLVED;
                }

                @Override
                public V resolve() {
                    return this.annotation;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)) {
                        return false;
                    }
                    net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)other;
                    return loadedOther.getState().isResolved() && this.annotation.equals(loadedOther.resolve());
                }

                public int hashCode() {
                    return this.annotation.hashCode();
                }

                public String toString() {
                    return this.annotation.toString();
                }
            }
        }

        public static class Trivial<U>
        implements AnnotationValue<U, U> {
            private final U value;
            private final PropertyDispatcher propertyDispatcher;

            public Trivial(U value) {
                this.value = value;
                this.propertyDispatcher = PropertyDispatcher.of(value.getClass());
            }

            @Override
            public U resolve() {
                return this.value;
            }

            @Override
            public net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<U> load(ClassLoader classLoader) {
                return new Loaded<U>(this.value, this.propertyDispatcher);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.propertyDispatcher.equals(this.value, ((Trivial)other).value);
            }

            public int hashCode() {
                return this.propertyDispatcher.hashCode(this.value);
            }

            public String toString() {
                return "AnnotationDescription.AnnotationValue.Trivial{value=" + this.value + ", propertyDispatcher=" + (Object)((Object)this.propertyDispatcher) + '}';
            }

            public static class Loaded<V>
            implements net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded<V> {
                private final V value;
                private final PropertyDispatcher propertyDispatcher;

                public Loaded(V value, PropertyDispatcher propertyDispatcher) {
                    this.value = value;
                    this.propertyDispatcher = propertyDispatcher;
                }

                @Override
                public Loaded.State getState() {
                    return Loaded.State.RESOLVED;
                }

                @Override
                public V resolve() {
                    return this.propertyDispatcher.conditionalClone(this.value);
                }

                public int hashCode() {
                    return this.propertyDispatcher.hashCode(this.value);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)) {
                        return false;
                    }
                    net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded loadedOther = (net.bytebuddy.description.annotation.AnnotationDescription$AnnotationValue$Loaded)other;
                    return loadedOther.getState().isResolved() && this.propertyDispatcher.equals(this.value, loadedOther.resolve());
                }

                public String toString() {
                    return this.propertyDispatcher.toString(this.value);
                }
            }
        }

        public static interface Loaded<U> {
            public State getState();

            public U resolve();

            public static enum State {
                NON_DEFINED,
                NON_RESOLVED,
                RESOLVED;


                public boolean isDefined() {
                    return this != NON_DEFINED;
                }

                public boolean isResolved() {
                    return this == RESOLVED;
                }

                public String toString() {
                    return "TypePool.LazyTypeDescription.AnnotationValue.Loaded.State." + this.name();
                }
            }
        }
    }
}

