/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import ma.glasnost.orika.BoundMapperFacade;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.Filter;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.MappingHint;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.Properties;
import ma.glasnost.orika.StateReporter;
import ma.glasnost.orika.constructor.ConstructorResolverStrategy;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.converter.builtin.BuiltinConverters;
import ma.glasnost.orika.impl.DefaultBoundMapperFacade;
import ma.glasnost.orika.impl.DefaultCodeGenerationStrategy;
import ma.glasnost.orika.impl.DefaultConcreteTypeMap;
import ma.glasnost.orika.impl.DefaultConstructorObjectFactory;
import ma.glasnost.orika.impl.ExceptionUtility;
import ma.glasnost.orika.impl.GeneratedMapperBase;
import ma.glasnost.orika.impl.GeneratedObjectFactory;
import ma.glasnost.orika.impl.MapperFacadeImpl;
import ma.glasnost.orika.impl.NonCyclicMappingContext;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.impl.UtilityResolver;
import ma.glasnost.orika.impl.generator.CodeGenerationStrategy;
import ma.glasnost.orika.impl.generator.CompilerStrategy;
import ma.glasnost.orika.impl.generator.MapperGenerator;
import ma.glasnost.orika.impl.generator.ObjectFactoryGenerator;
import ma.glasnost.orika.inheritance.DefaultSuperTypeResolverStrategy;
import ma.glasnost.orika.inheritance.SuperTypeResolverStrategy;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.ClassMapBuilder;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.ClassMapBuilderForArrays;
import ma.glasnost.orika.metadata.ClassMapBuilderForLists;
import ma.glasnost.orika.metadata.ClassMapBuilderForMaps;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolverStrategy;
import ma.glasnost.orika.unenhance.BaseUnenhancer;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;
import ma.glasnost.orika.util.HashMapUtility;
import ma.glasnost.orika.util.Ordering;
import ma.glasnost.orika.util.SortedCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMapperFactory
implements MapperFactory,
StateReporter.Reportable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMapperFactory.class);
    protected final MapperFacade mapperFacade;
    protected final MapperGenerator mapperGenerator;
    protected final ObjectFactoryGenerator objectFactoryGenerator;
    protected final ConcurrentLinkedHashMap<MapperKey, ClassMap<Object, Object>> classMapRegistry;
    protected final SortedCollection<Mapper<Object, Object>> mappersRegistry;
    protected final SortedCollection<Filter<Object, Object>> filtersRegistry;
    protected final MappingContextFactory contextFactory;
    protected final MappingContextFactory nonCyclicContextFactory;
    protected final ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ObjectFactory<? extends Object>>> objectFactoryRegistry;
    protected final ConcurrentHashMap<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> explicitAToBRegistry;
    protected final ConcurrentHashMap<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> dynamicAToBRegistry;
    protected final List<DefaultFieldMapper> defaultFieldMappers;
    protected final UnenhanceStrategy unenhanceStrategy;
    protected final UnenhanceStrategy userUnenahanceStrategy;
    protected final ConverterFactory converterFactory;
    protected final CompilerStrategy compilerStrategy;
    protected final PropertyResolverStrategy propertyResolverStrategy;
    protected final Map<Type, ma.glasnost.orika.metadata.Type<?>> concreteTypeRegistry;
    protected final ClassMapBuilderFactory classMapBuilderFactory;
    protected ClassMapBuilderFactory chainClassMapBuilderFactory;
    protected final Map<MapperKey, Set<ClassMap<Object, Object>>> usedMapperMetadataRegistry;
    protected final boolean useAutoMapping;
    protected final boolean useBuiltinConverters;
    protected final boolean favorExtension;
    protected volatile boolean isBuilt = false;
    protected volatile boolean isBuilding = false;
    protected final ExceptionUtility exceptionUtil;

    protected DefaultMapperFactory(MapperFactoryBuilder<?, ?> builder) {
        this.converterFactory = new ConverterFactoryFacade(builder.converterFactory);
        this.compilerStrategy = builder.compilerStrategy;
        this.classMapRegistry = HashMapUtility.getConcurrentLinkedHashMap(Integer.MAX_VALUE);
        this.mappersRegistry = new SortedCollection<Mapper<Object, Object>>(Ordering.MAPPER);
        this.filtersRegistry = new SortedCollection<Filter<Object, Object>>(Ordering.FILTER);
        this.explicitAToBRegistry = new ConcurrentHashMap();
        this.dynamicAToBRegistry = new ConcurrentHashMap();
        this.usedMapperMetadataRegistry = new ConcurrentHashMap<MapperKey, Set<ClassMap<Object, Object>>>();
        this.objectFactoryRegistry = new ConcurrentHashMap();
        this.defaultFieldMappers = new CopyOnWriteArrayList<DefaultFieldMapper>();
        this.userUnenahanceStrategy = builder.unenhanceStrategy;
        this.unenhanceStrategy = this.buildUnenhanceStrategy(builder.unenhanceStrategy, builder.superTypeStrategy);
        this.contextFactory = builder.mappingContextFactory;
        this.nonCyclicContextFactory = new NonCyclicMappingContext.Factory(this.contextFactory.getGlobalProperties());
        this.exceptionUtil = new ExceptionUtility(this, builder.dumpStateOnException);
        this.mapperFacade = this.buildMapperFacade(this.contextFactory, this.unenhanceStrategy);
        this.concreteTypeRegistry = new ConcurrentHashMap();
        if (builder.classMaps != null) {
            for (ClassMap<?, ?> classMap : builder.classMaps) {
                this.registerClassMap(classMap);
            }
        }
        this.propertyResolverStrategy = builder.propertyResolverStrategy;
        this.classMapBuilderFactory = builder.classMapBuilderFactory;
        this.classMapBuilderFactory.setPropertyResolver(this.propertyResolverStrategy);
        this.classMapBuilderFactory.setMapperFactory(this);
        this.addClassMapBuilderFactory(new ClassMapBuilderForArrays.Factory());
        this.addClassMapBuilderFactory(new ClassMapBuilderForLists.Factory());
        this.addClassMapBuilderFactory(new ClassMapBuilderForMaps.Factory());
        this.mapperGenerator = new MapperGenerator(this, builder.compilerStrategy);
        this.objectFactoryGenerator = new ObjectFactoryGenerator(this, builder.constructorResolverStrategy, builder.compilerStrategy);
        this.useAutoMapping = builder.useAutoMapping;
        this.favorExtension = builder.favorExtension;
        this.useBuiltinConverters = builder.useBuiltinConverters;
        builder.codeGenerationStrategy.setMapperFactory(this);
        Map<Object, Object> props = this.contextFactory.getGlobalProperties();
        props.put((Object)Properties.SHOULD_MAP_NULLS, builder.mapNulls);
        props.put((Object)Properties.CODE_GENERATION_STRATEGY, builder.codeGenerationStrategy);
        props.put((Object)Properties.COMPILER_STRATEGY, builder.compilerStrategy);
        props.put((Object)Properties.PROPERTY_RESOLVER_STRATEGY, builder.propertyResolverStrategy);
        props.put((Object)Properties.UNENHANCE_STRATEGY, this.unenhanceStrategy);
        props.put((Object)Properties.MAPPER_FACTORY, this);
        props.put((Object)Properties.FILTERS, this.filtersRegistry);
        props.put((Object)Properties.CAPTURE_FIELD_CONTEXT, builder.captureFieldContext);
        for (Map.Entry<Class, Class> concreteTypeMap : DefaultConcreteTypeMap.getAll()) {
            this.registerConcreteType(concreteTypeMap.getKey(), concreteTypeMap.getValue());
        }
    }

    protected void addClassMapBuilderFactory(ClassMapBuilderFactory factory) {
        factory.setChainClassMapBuilderFactory(this.chainClassMapBuilderFactory);
        this.chainClassMapBuilderFactory = factory;
        factory.setPropertyResolver(this.propertyResolverStrategy);
        factory.setMapperFactory(this);
    }

    protected UnenhanceStrategy buildUnenhanceStrategy(UnenhanceStrategy unenhanceStrategy, SuperTypeResolverStrategy superTypeStrategy) {
        BaseUnenhancer unenhancer = new BaseUnenhancer();
        if (unenhanceStrategy != null) {
            unenhancer.addUnenhanceStrategy(unenhanceStrategy);
        }
        if (superTypeStrategy != null) {
            unenhancer.addSuperTypeResolverStrategy(superTypeStrategy);
        }
        DefaultSuperTypeResolverStrategy inaccessibleTypeStrategy = new DefaultSuperTypeResolverStrategy(){

            public boolean isTypeAccessible(ma.glasnost.orika.metadata.Type<?> type) {
                try {
                    DefaultMapperFactory.this.compilerStrategy.assureTypeIsAccessible((Class<?>)type.getRawType());
                    return true;
                }
                catch (CompilerStrategy.SourceCodeGenerationException e) {
                    return false;
                }
            }

            @Override
            public boolean isAcceptable(ma.glasnost.orika.metadata.Type<?> type) {
                return this.isTypeAccessible(type) && !Proxy.class.equals((Object)type.getRawType());
            }
        };
        unenhancer.addSuperTypeResolverStrategy(inaccessibleTypeStrategy);
        return unenhancer;
    }

    protected MapperFacade buildMapperFacade(MappingContextFactory contextFactory, UnenhanceStrategy unenhanceStrategy) {
        return new MapperFacadeImpl(this, contextFactory, unenhanceStrategy, this.exceptionUtil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A, B> Mapper<A, B> lookupMapper(MapperKey mapperKey) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Mapper<Object, Object> mapper = this.lookupMapper(mapperKey, context);
            return mapper;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper<Object, Object> lookupMapper(MapperKey mapperKey, MappingContext context) {
        GeneratedMapperBase mapper = this.getRegisteredMapper(mapperKey.getAType(), mapperKey.getBType(), false);
        if (mapper == null && this.useAutoMapping) {
            DefaultMapperFactory defaultMapperFactory = this;
            synchronized (defaultMapperFactory) {
                mapper = this.getRegisteredMapper(mapperKey.getAType(), mapperKey.getBType(), false);
                if (mapper == null) {
                    try {
                        if (mapperKey.getBType().isImmutable() && !this.objectFactoryRegistry.containsKey(mapperKey.getBType())) {
                            throw new MappingException("No converter registered for conversion from " + mapperKey.getAType() + " to " + mapperKey.getBType() + ", nor any ObjectFactory which can generate " + mapperKey.getBType() + " from " + mapperKey.getAType());
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("No mapper registered for " + mapperKey + ": attempting to generate");
                        }
                        ClassMapBuilder<Object, Object> builder = this.classMap(mapperKey.getAType(), mapperKey.getBType()).byDefault(new DefaultFieldMapper[0]);
                        for (MapperKey key : this.discoverUsedMappers(builder)) {
                            builder.use(key.getAType(), key.getBType());
                        }
                        ClassMap<Object, Object> classMap = builder.toClassMap();
                        this.buildObjectFactories(classMap, context);
                        mapper = this.buildMapper(classMap, true, context);
                        this.initializeUsedMappers(classMap, context);
                    }
                    catch (MappingException e) {
                        e.setSourceType(mapperKey.getAType());
                        e.setDestinationType(mapperKey.getBType());
                        throw this.exceptionUtil.decorate(e);
                    }
                }
            }
        }
        return mapper;
    }

    @Override
    public boolean existsRegisteredMapper(ma.glasnost.orika.metadata.Type<?> sourceType, ma.glasnost.orika.metadata.Type<?> destinationType, boolean includeAutoGeneratedMappers) {
        return this.getRegisteredMapper(sourceType, destinationType, includeAutoGeneratedMappers) != null;
    }

    protected <A, B> Mapper<A, B> getRegisteredMapper(MapperKey mapperKey) {
        return this.getRegisteredMapper(mapperKey.getAType(), mapperKey.getBType(), false);
    }

    protected <A, B> Mapper<A, B> getRegisteredMapper(ma.glasnost.orika.metadata.Type<A> typeA, ma.glasnost.orika.metadata.Type<B> typeB, boolean includeAutoGeneratedMappers) {
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            if (mapper.getAType().equals(typeA) && mapper.getBType().equals(typeB) || mapper.getAType().equals(typeB) && mapper.getBType().equals(typeA)) {
                return mapper;
            }
            if ((!mapper.getAType().isAssignableFrom(typeA) || !mapper.getBType().isAssignableFrom(typeB)) && (!mapper.getAType().isAssignableFrom(typeB) || !mapper.getBType().isAssignableFrom(typeA)) || this.favorsExtension(mapper) && this.canBeExtended(typeA, typeB, mapper)) continue;
            if (includeAutoGeneratedMappers || !(mapper instanceof GeneratedMapperBase)) {
                return mapper;
            }
            if (((GeneratedMapperBase)mapper).isFromAutoMapping()) continue;
            return mapper;
        }
        return null;
    }

    private boolean favorsExtension(Mapper<?, ?> mapper) {
        return mapper.favorsExtension() == null ? this.favorExtension : mapper.favorsExtension();
    }

    private boolean canBeExtended(ma.glasnost.orika.metadata.Type<?> typeA, ma.glasnost.orika.metadata.Type<?> typeB, Mapper<?, ?> mapper) {
        boolean extensible;
        try {
            this.compilerStrategy.assureTypeIsAccessible((Class<?>)typeA.getRawType());
            this.compilerStrategy.assureTypeIsAccessible((Class<?>)typeB.getRawType());
            extensible = true;
        }
        catch (CompilerStrategy.SourceCodeGenerationException e) {
            extensible = false;
        }
        return extensible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperFacade getMapperFacade() {
        if (!this.isBuilt) {
            MapperFacade mapperFacade = this.mapperFacade;
            synchronized (mapperFacade) {
                if (!this.isBuilt) {
                    this.build();
                }
            }
        }
        return this.mapperFacade;
    }

    public <D> void registerObjectFactory(ObjectFactory<D> objectFactory, ma.glasnost.orika.metadata.Type<D> destinationType) {
        this.registerObjectFactory(objectFactory, destinationType, (ma.glasnost.orika.metadata.Type<S>)TypeFactory.TYPE_OF_OBJECT);
    }

    public <D, S> void registerObjectFactory(ObjectFactory<D> objectFactory, ma.glasnost.orika.metadata.Type<D> destinationType, ma.glasnost.orika.metadata.Type<S> sourceType) {
        ConcurrentHashMap<ma.glasnost.orika.metadata.Type<Object>, ObjectFactory<Object>> localCache = this.objectFactoryRegistry.get(destinationType);
        if (localCache == null) {
            localCache = new ConcurrentHashMap();
            this.objectFactoryRegistry.put(destinationType, localCache);
        }
        localCache.put(sourceType, objectFactory);
        if (this.isBuilding || this.isBuilt) {
            this.mapperFacade.factoryModified(this);
        }
    }

    @Override
    @Deprecated
    public void registerMappingHint(MappingHint ... hints) {
        DefaultFieldMapper[] mappers = new DefaultFieldMapper[hints.length];
        int len = hints.length;
        for (int i = 0; i < len; ++i) {
            mappers[i] = new MappingHint.DefaultFieldMappingConverter(hints[i]);
        }
        this.registerDefaultFieldMapper(mappers);
    }

    @Override
    public void registerDefaultFieldMapper(DefaultFieldMapper ... mappers) {
        this.defaultFieldMappers.addAll(Arrays.asList(mappers));
    }

    @Override
    public void registerConcreteType(ma.glasnost.orika.metadata.Type<?> abstractType, ma.glasnost.orika.metadata.Type<?> concreteType) {
        this.concreteTypeRegistry.put(abstractType, concreteType);
    }

    @Override
    public void registerConcreteType(Class<?> abstractType, Class<?> concreteType) {
        this.concreteTypeRegistry.put(abstractType, TypeFactory.valueOf(concreteType));
    }

    @Override
    public <T> ObjectFactory<T> lookupObjectFactory(ma.glasnost.orika.metadata.Type<T> targetType) {
        return this.lookupObjectFactory(targetType, TypeFactory.TYPE_OF_OBJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> ObjectFactory<T> lookupObjectFactory(ma.glasnost.orika.metadata.Type<T> targetType, ma.glasnost.orika.metadata.Type<S> sourceType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            ObjectFactory<T> objectFactory = this.lookupObjectFactory(targetType, sourceType, context);
            return objectFactory;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    protected <T, S> ObjectFactory<T> lookupExistingObjectFactory(ma.glasnost.orika.metadata.Type<T> destinationType, ma.glasnost.orika.metadata.Type<S> sourceType, MappingContext context) {
        ObjectFactory<? extends Object> result;
        if (destinationType == null || sourceType == null) {
            return null;
        }
        ma.glasnost.orika.metadata.Type<T> targetType = destinationType;
        ConcurrentHashMap<ma.glasnost.orika.metadata.Type<Object>, ObjectFactory<Object>> localCache = this.objectFactoryRegistry.get(targetType);
        if (localCache == null) {
            localCache = new ConcurrentHashMap();
            ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ObjectFactory<? extends Object>> existing = this.objectFactoryRegistry.putIfAbsent(targetType, localCache);
            if (existing != null) {
                localCache = existing;
            }
            result = null;
        } else {
            ma.glasnost.orika.metadata.Type<Object> checkSourceType = sourceType;
            do {
                result = localCache.get(checkSourceType);
                checkSourceType = checkSourceType.getSuperType();
            } while (result == null && !TypeFactory.TYPE_OF_OBJECT.equals(checkSourceType));
            if (result == null) {
                result = localCache.get(TypeFactory.TYPE_OF_OBJECT);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> ObjectFactory<T> lookupObjectFactory(ma.glasnost.orika.metadata.Type<T> destinationType, ma.glasnost.orika.metadata.Type<S> sourceType, MappingContext context) {
        ObjectFactory<Object> result;
        block13: {
            if (destinationType == null || sourceType == null) {
                return null;
            }
            ma.glasnost.orika.metadata.Type<Object> targetType = destinationType;
            result = this.lookupExistingObjectFactory(targetType, sourceType, context);
            if (result != null) break block13;
            DefaultMapperFactory defaultMapperFactory = this;
            synchronized (defaultMapperFactory) {
                Constructor<?>[] constructors;
                block14: {
                    Object existing;
                    block12: {
                        if (!targetType.isConcrete()) {
                            targetType = this.resolveConcreteType(targetType, targetType);
                        }
                        constructors = ((Class)targetType.getRawType()).getConstructors();
                        if (!this.useAutoMapping && this.isBuilt) break block14;
                        if (constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
                            result = new DefaultConstructorObjectFactory(targetType.getRawType());
                        } else {
                            try {
                                result = this.objectFactoryGenerator.build(targetType, sourceType, context);
                            }
                            catch (MappingException e) {
                                for (Constructor<?> c : constructors) {
                                    if (c.getParameterTypes().length != 0) continue;
                                    result = new DefaultConstructorObjectFactory(targetType.getRawType());
                                    break;
                                }
                                if (result != null) break block12;
                                throw this.exceptionUtil.decorate(e);
                            }
                        }
                    }
                    Object localCache = this.objectFactoryRegistry.get(targetType);
                    if (localCache == null && (existing = this.objectFactoryRegistry.putIfAbsent((ma.glasnost.orika.metadata.Type<? extends Object>)targetType, (ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ObjectFactory<? extends Object>>)(localCache = new ConcurrentHashMap()))) != null) {
                        localCache = existing;
                    }
                    if ((existing = ((ConcurrentHashMap)localCache).putIfAbsent(sourceType, (ObjectFactory<? extends Object>)result)) == null) break block13;
                    result = existing;
                    break block13;
                }
                for (Constructor<?> constructor : constructors) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    result = new DefaultConstructorObjectFactory(targetType.getRawType());
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <S, D> ma.glasnost.orika.metadata.Type<? extends D> lookupConcreteDestinationType(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, MappingContext context) {
        void var4_10;
        void var4_8;
        ma.glasnost.orika.metadata.Type<D> type;
        ma.glasnost.orika.metadata.Type<D> type2 = type = context == null ? null : context.getConcreteClass(sourceType, destinationType);
        if (type != null) {
            return type;
        }
        Set<ma.glasnost.orika.metadata.Type<?>> destinationSet = this.explicitAToBRegistry.get(sourceType);
        if (destinationSet != null && !destinationSet.isEmpty()) {
            for (ma.glasnost.orika.metadata.Type<?> type3 : destinationSet) {
                if (!destinationType.isAssignableFrom(type3) || !type3.isConcrete() || !type3.equals(destinationType) && !this.existsRegisteredMapper(sourceType, type3, false) && destinationType.isConcrete()) continue;
                return type3;
            }
        }
        if (destinationType.isConcrete()) {
            return destinationType;
        }
        destinationSet = this.dynamicAToBRegistry.get(sourceType);
        if (destinationSet != null && !destinationSet.isEmpty()) {
            for (ma.glasnost.orika.metadata.Type<?> type3 : destinationSet) {
                if (!destinationType.isAssignableFrom(type3) || !type3.isConcrete() || !type3.equals(destinationType) && !this.existsRegisteredMapper(sourceType, type3, false) && destinationType.isConcrete()) continue;
                return type3;
            }
        } else {
            Mapper<S, D> registeredMapper = this.getRegisteredMapper(sourceType, destinationType, true);
            if (registeredMapper != null) {
                ma.glasnost.orika.metadata.Type<Object> type4;
                ma.glasnost.orika.metadata.Type<Object> type5 = type4 = registeredMapper.getAType().isAssignableFrom(sourceType) ? registeredMapper.getBType() : registeredMapper.getAType();
                if (type4.isConcrete()) return null;
                ma.glasnost.orika.metadata.Type<?> type6 = this.resolveConcreteType(type4, destinationType);
            } else {
                ma.glasnost.orika.metadata.Type<?> type7 = this.resolveConcreteType(destinationType, destinationType);
            }
        }
        if (var4_8 != null) return var4_10;
        ma.glasnost.orika.metadata.Type<?> type8 = this.resolveConcreteType(destinationType, destinationType);
        return var4_10;
    }

    protected ma.glasnost.orika.metadata.Type<?> resolveConcreteType(ma.glasnost.orika.metadata.Type<?> type, ma.glasnost.orika.metadata.Type<?> originalType) {
        ma.glasnost.orika.metadata.Type<?> concreteType = this.concreteTypeOf(type);
        if (concreteType != null && !concreteType.isAssignableFrom(originalType)) {
            concreteType = originalType.isConcrete() ? originalType : this.concreteTypeOf(originalType);
        }
        return concreteType;
    }

    private ma.glasnost.orika.metadata.Type<?> concreteTypeOf(ma.glasnost.orika.metadata.Type<?> type) {
        ma.glasnost.orika.metadata.Type<Object> concreteType = this.concreteTypeRegistry.get(type);
        if (concreteType == null && (concreteType = this.concreteTypeRegistry.get(type.getRawType())) != null) {
            concreteType = TypeFactory.resolveValueOf(concreteType.getRawType(), type);
        }
        return concreteType;
    }

    @Override
    public synchronized <A, B> void registerClassMap(ClassMap<A, B> classMap) {
        this.classMapRegistry.put((Object)new MapperKey(classMap.getAType(), classMap.getBType()), classMap);
        if (this.isBuilding || this.isBuilt) {
            MappingContext context = this.contextFactory.getContext();
            try {
                if (classMap.getUsedMappers().isEmpty()) {
                    classMap = classMap.copyWithUsedMappers(this.discoverUsedMappers(classMap));
                }
                this.buildMapper(classMap, this.isBuilding, context);
                this.buildObjectFactories(classMap, context);
                this.initializeUsedMappers(classMap, context);
                this.mapperFacade.factoryModified(this);
            }
            finally {
                this.contextFactory.release(context);
            }
        }
    }

    @Override
    public <A, B> void registerClassMap(ClassMapBuilder<A, B> builder) {
        this.registerClassMap(builder.toClassMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void build() {
        if (!this.isBuilding && !this.isBuilt) {
            this.isBuilding = true;
            MappingContext context = this.contextFactory.getContext();
            try {
                if (this.useBuiltinConverters) {
                    BuiltinConverters.register(this.converterFactory);
                }
                this.converterFactory.setMapperFacade(this.mapperFacade);
                for (Map.Entry classMapEntry : this.classMapRegistry.entrySet()) {
                    ClassMap classMap = (ClassMap)classMapEntry.getValue();
                    if (!classMap.getUsedMappers().isEmpty()) continue;
                    classMapEntry.setValue(classMap.copyWithUsedMappers(this.discoverUsedMappers(classMap)));
                }
                this.buildClassMapRegistry();
                for (ClassMap classMap : this.classMapRegistry.values()) {
                    this.buildMapper(classMap, false, context);
                }
                for (ClassMap classMap : this.classMapRegistry.values()) {
                    this.buildObjectFactories(classMap, context);
                    this.initializeUsedMappers(classMap, context);
                }
            }
            finally {
                this.contextFactory.release(context);
            }
            this.isBuilt = true;
            this.isBuilding = false;
        }
    }

    @Override
    public Set<ClassMap<Object, Object>> lookupUsedClassMap(MapperKey mapperKey) {
        Set<ClassMap<Object, Object>> usedClassMapSet = this.usedMapperMetadataRegistry.get(mapperKey);
        if (usedClassMapSet == null) {
            usedClassMapSet = Collections.emptySet();
        }
        return usedClassMapSet;
    }

    private void buildClassMapRegistry() {
        HashMap<MapperKey, ClassMap> classMapsDictionary = new HashMap<MapperKey, ClassMap>();
        for (ClassMap classMap : this.classMapRegistry.values()) {
            classMapsDictionary.put(new MapperKey(classMap.getAType(), classMap.getBType()), classMap);
        }
        for (ClassMap classMap : this.classMapRegistry.values()) {
            MapperKey key = new MapperKey(classMap.getAType(), classMap.getBType());
            LinkedHashSet<ClassMap> usedClassMapSet = new LinkedHashSet<ClassMap>();
            for (MapperKey parentMapperKey : classMap.getUsedMappers()) {
                ClassMap usedClassMap = (ClassMap)classMapsDictionary.get(parentMapperKey);
                if (usedClassMap == null) {
                    throw this.exceptionUtil.newMappingException("Cannot find class mapping using mapper : " + classMap.getMapperClassName());
                }
                usedClassMapSet.add(usedClassMap);
            }
            this.usedMapperMetadataRegistry.put(key, usedClassMapSet);
        }
    }

    private <S, D> void buildObjectFactories(ClassMap<S, D> classMap, MappingContext context) {
        GeneratedObjectFactory objectFactory;
        ma.glasnost.orika.metadata.Type<S> aType = classMap.getAType();
        ma.glasnost.orika.metadata.Type<D> bType = classMap.getBType();
        if (classMap.getConstructorA() != null && this.lookupExistingObjectFactory(aType, TypeFactory.TYPE_OF_OBJECT, context) == null) {
            objectFactory = this.objectFactoryGenerator.build(aType, bType, context);
            this.registerObjectFactory((ObjectFactory<D>)objectFactory, (ma.glasnost.orika.metadata.Type<D>)aType);
        }
        if (classMap.getConstructorB() != null && this.lookupExistingObjectFactory(bType, TypeFactory.TYPE_OF_OBJECT, context) == null) {
            objectFactory = this.objectFactoryGenerator.build(bType, aType, context);
            this.registerObjectFactory((ObjectFactory<D>)objectFactory, bType);
        }
    }

    private Set<MapperKey> discoverUsedMappers(MappedTypePair<?, ?> classMapBuilder) {
        LinkedHashSet<MapperKey> mappers = new LinkedHashSet<MapperKey>();
        for (ClassMap map : this.classMapRegistry.values()) {
            MapperKey key;
            if (map.getAType().isAssignableFrom(classMapBuilder.getAType()) && map.getBType().isAssignableFrom(classMapBuilder.getBType())) {
                if (map.getAType().equals(classMapBuilder.getAType()) && map.getBType().equals(classMapBuilder.getBType())) continue;
                key = new MapperKey(map.getAType(), map.getBType());
                mappers.add(key);
                continue;
            }
            if (!map.getAType().isAssignableFrom(classMapBuilder.getBType()) || !map.getBType().isAssignableFrom(classMapBuilder.getAType()) || map.getAType().equals(classMapBuilder.getBType()) && map.getBType().equals(classMapBuilder.getAType())) continue;
            key = new MapperKey(map.getBType(), map.getAType());
            mappers.add(key);
        }
        return mappers;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeUsedMappers(ClassMap<?, ?> classMap, MappingContext context) {
        void var6_12;
        void var6_10;
        Mapper<Object, Object> mapper = this.lookupMapper(new MapperKey(classMap.getAType(), classMap.getBType()), context);
        LinkedHashSet<Mapper<Object, Object>> parentMappers = new LinkedHashSet<Mapper<Object, Object>>();
        if (!classMap.getUsedMappers().isEmpty()) {
            for (MapperKey mapperKey : classMap.getUsedMappers()) {
                this.collectUsedMappers(classMap, parentMappers, mapperKey, context);
            }
        }
        parentMappers.remove(mapper);
        for (Mapper mapper2 : parentMappers) {
            if (GeneratedMapperBase.isUsedMappersInitialized(mapper2)) continue;
            this.initializeUsedMappers(this.getClassMap(new MapperKey(mapper2.getAType(), mapper2.getBType())), context);
        }
        Mapper[] usedMappers = parentMappers.toArray(new Mapper[parentMappers.size()]);
        parentMappers.clear();
        boolean bl = false;
        int len = usedMappers.length;
        while (var6_10 < len) {
            boolean exists = false;
            for (int j = 0; j < len; ++j) {
                if (var6_10 == j || !GeneratedMapperBase.isUsedMapperOf(usedMappers[var6_10], usedMappers[j])) continue;
                exists = true;
                break;
            }
            if (!exists) {
                parentMappers.add(usedMappers[var6_10]);
            }
            ++var6_10;
        }
        if (parentMappers.size() < usedMappers.length) {
            usedMappers = parentMappers.toArray(new Mapper[parentMappers.size()]);
        }
        boolean bl2 = false;
        while (var6_12 < usedMappers.length) {
            Mapper usedMapper = usedMappers[var6_12];
            if (usedMapper.getAType().isAssignableFrom(classMap.getBType()) && usedMapper.getBType().isAssignableFrom(classMap.getAType())) {
                usedMappers[var6_12] = ReversedMapper.reverse(usedMapper);
            }
            ++var6_12;
        }
        mapper.setUsedMappers(usedMappers);
    }

    private void collectUsedMappers(ClassMap<?, ?> classMap, Set<Mapper<Object, Object>> parentMappers, MapperKey parentMapperKey, MappingContext context) {
        Mapper<Object, Object> parentMapper = this.lookupMapper(parentMapperKey, context);
        if (parentMapper == null) {
            throw this.exceptionUtil.newMappingException("Cannot find used mappers for : " + classMap.getMapperClassName());
        }
        parentMappers.add(parentMapper);
        Set<ClassMap<Object, Object>> usedClassMapSet = this.usedMapperMetadataRegistry.get(parentMapperKey);
        if (usedClassMapSet != null) {
            for (ClassMap<Object, Object> cm : usedClassMapSet) {
                this.collectUsedMappers(cm, parentMappers, new MapperKey(cm.getAType(), cm.getBType()), context);
            }
        }
    }

    private GeneratedMapperBase buildMapper(ClassMap<?, ?> classMap, boolean isAutoGenerated, MappingContext context) {
        this.register(classMap.getAType(), classMap.getBType(), isAutoGenerated);
        this.register(classMap.getBType(), classMap.getAType(), isAutoGenerated);
        MapperKey mapperKey = new MapperKey(classMap.getAType(), classMap.getBType());
        GeneratedMapperBase mapper = this.mapperGenerator.build(classMap, context);
        mapper.setMapperFacade(this.mapperFacade);
        mapper.setFromAutoMapping(isAutoGenerated);
        if (classMap.getCustomizedMapper() != null) {
            Mapper<Object, Object> customizedMapper = classMap.getCustomizedMapper();
            mapper.setCustomMapper(customizedMapper);
        }
        this.mappersRegistry.remove(mapper);
        this.mappersRegistry.add(mapper);
        this.classMapRegistry.put((Object)mapperKey, classMap);
        return mapper;
    }

    protected <S, D> void register(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, boolean isAutoGenerated) {
        Set<ma.glasnost.orika.metadata.Type<?>> existing;
        ConcurrentHashMap<ma.glasnost.orika.metadata.Type<?>, Set<ma.glasnost.orika.metadata.Type<?>>> registry = isAutoGenerated ? this.dynamicAToBRegistry : this.explicitAToBRegistry;
        Set<ma.glasnost.orika.metadata.Type<?>> destinationSet = registry.get(sourceType);
        if (destinationSet == null && (existing = registry.putIfAbsent(sourceType, destinationSet = new TreeSet())) != null) {
            destinationSet = existing;
        }
        destinationSet.add(destinationType);
    }

    @Override
    public <A, B> ClassMap<A, B> getClassMap(MapperKey mapperKey) {
        return (ClassMap)this.classMapRegistry.get((Object)mapperKey);
    }

    @Override
    public Set<ma.glasnost.orika.metadata.Type<? extends Object>> lookupMappedClasses(ma.glasnost.orika.metadata.Type<?> type) {
        TreeSet<ma.glasnost.orika.metadata.Type<? extends Object>> mappedClasses = new TreeSet<ma.glasnost.orika.metadata.Type<? extends Object>>();
        Set<ma.glasnost.orika.metadata.Type<?>> types = this.explicitAToBRegistry.get(type);
        if (types != null) {
            mappedClasses.addAll(types);
        }
        if ((types = this.dynamicAToBRegistry.get(type)) != null) {
            mappedClasses.addAll(types);
        }
        return mappedClasses;
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    @Override
    public <T> void registerObjectFactory(ObjectFactory<T> objectFactory, Class<T> targetClass) {
        this.registerObjectFactory((ObjectFactory<D>)objectFactory, (ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(targetClass));
    }

    protected ClassMapBuilderFactory getClassMapBuilderFactory() {
        if (!this.classMapBuilderFactory.isInitialized()) {
            this.classMapBuilderFactory.setDefaultFieldMappers(this.defaultFieldMappers.toArray(new DefaultFieldMapper[this.defaultFieldMappers.size()]));
        }
        return this.classMapBuilderFactory;
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(ma.glasnost.orika.metadata.Type<A> aType, ma.glasnost.orika.metadata.Type<B> bType) {
        ClassMapBuilderFactory classMapBuilderFactory = this.chainClassMapBuilderFactory.chooseClassMapBuilderFactory(aType, bType);
        if (classMapBuilderFactory != null) {
            return classMapBuilderFactory.map(aType, bType);
        }
        return this.getClassMapBuilderFactory().map(aType, bType);
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(Class<A> aType, ma.glasnost.orika.metadata.Type<B> bType) {
        return this.classMap(TypeFactory.valueOf(aType), bType);
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(ma.glasnost.orika.metadata.Type<A> aType, Class<B> bType) {
        return this.classMap(aType, TypeFactory.valueOf(bType));
    }

    @Override
    public <A, B> ClassMapBuilder<A, B> classMap(Class<A> aType, Class<B> bType) {
        return this.classMap(TypeFactory.valueOf(aType), TypeFactory.valueOf(bType));
    }

    @Override
    public synchronized <A, B> void registerMapper(Mapper<A, B> mapper) {
        this.mappersRegistry.add(mapper);
        mapper.setMapperFacade(this.mapperFacade);
        this.register(mapper.getAType(), mapper.getBType(), false);
        this.register(mapper.getBType(), mapper.getAType(), false);
        if (this.isBuilding || this.isBuilt) {
            this.mapperFacade.factoryModified(this);
        }
    }

    public <S, D> BoundMapperFacade<S, D> getMapperFacade(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType) {
        return this.getMapperFacade(sourceType, destinationType, true);
    }

    public <S, D> BoundMapperFacade<S, D> getMapperFacade(ma.glasnost.orika.metadata.Type<S> sourceType, ma.glasnost.orika.metadata.Type<D> destinationType, boolean containsCycles) {
        this.getMapperFacade();
        MappingContextFactory ctxFactory = containsCycles ? this.contextFactory : this.nonCyclicContextFactory;
        return new DefaultBoundMapperFacade(this, ctxFactory, sourceType, destinationType);
    }

    @Override
    public <A, B> BoundMapperFacade<A, B> getMapperFacade(Class<A> aType, Class<B> bType) {
        return this.getMapperFacade((ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(aType), (ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(bType));
    }

    @Override
    public <A, B> BoundMapperFacade<A, B> getMapperFacade(Class<A> aType, Class<B> bType, boolean containsCycles) {
        return this.getMapperFacade((ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(aType), (ma.glasnost.orika.metadata.Type)TypeFactory.valueOf(bType), containsCycles);
    }

    @Override
    public UnenhanceStrategy getUserUnenhanceStrategy() {
        return this.userUnenahanceStrategy;
    }

    @Override
    public void registerFilter(Filter<?, ?> filter) {
        this.filtersRegistry.add(filter);
    }

    @Override
    public void reportCurrentState(StringBuilder out) {
        out.append("\n-------------------------------------------------------------");
        out.append("\nRegistered object factories: ").append(this.objectFactoryRegistry.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.objectFactoryRegistry)).append(")");
        for (Map.Entry<ma.glasnost.orika.metadata.Type<? extends Object>, ConcurrentHashMap<ma.glasnost.orika.metadata.Type<? extends Object>, ObjectFactory<? extends Object>>> entry : this.objectFactoryRegistry.entrySet()) {
            out.append("\n  [").append(entry.getKey()).append("] : ").append(entry.getValue());
        }
        out.append("\n-------------------------------------------------------------");
        out.append("\nRegistered mappers: ").append(this.mappersRegistry.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.mappersRegistry)).append(")");
        int index = 0;
        for (Mapper<Object, Object> mapper : this.mappersRegistry) {
            out.append("\n  [").append(index++).append("] : ").append(mapper);
        }
        out.append("\n-------------------------------------------------------------");
        out.append("\nRegistered concrete types: ").append(this.concreteTypeRegistry.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.concreteTypeRegistry)).append(")");
        for (Map.Entry entry : this.concreteTypeRegistry.entrySet()) {
            out.append("\n  [").append(entry.getKey()).append("] : ").append(entry.getValue());
        }
    }

    private class ConverterFactoryFacade
    implements ConverterFactory {
        private ConverterFactory delegate;

        public ConverterFactoryFacade(ConverterFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setMapperFacade(MapperFacade mapperFacade) {
            this.delegate.setMapperFacade(mapperFacade);
        }

        @Override
        public Converter<Object, Object> getConverter(ma.glasnost.orika.metadata.Type<?> sourceType, ma.glasnost.orika.metadata.Type<?> destinationType) {
            return this.delegate.getConverter(sourceType, destinationType);
        }

        @Override
        public Converter<Object, Object> getConverter(String converterId) {
            return this.delegate.getConverter(converterId);
        }

        @Override
        public <S, D> void registerConverter(Converter<S, D> converter) {
            this.delegate.registerConverter(converter);
            if (DefaultMapperFactory.this.isBuilding || DefaultMapperFactory.this.isBuilt) {
                DefaultMapperFactory.this.mapperFacade.factoryModified(DefaultMapperFactory.this);
            }
        }

        @Override
        public <S, D> void registerConverter(String converterId, Converter<S, D> converter) {
            this.delegate.registerConverter(converterId, converter);
            if (DefaultMapperFactory.this.isBuilding || DefaultMapperFactory.this.isBuilt) {
                DefaultMapperFactory.this.mapperFacade.factoryModified(DefaultMapperFactory.this);
            }
        }

        @Override
        public boolean hasConverter(String converterId) {
            return this.delegate.hasConverter(converterId);
        }

        @Override
        public boolean canConvert(ma.glasnost.orika.metadata.Type<?> sourceType, ma.glasnost.orika.metadata.Type<?> destinationType) {
            return this.delegate.canConvert(sourceType, destinationType);
        }
    }

    public static class Builder
    extends MapperFactoryBuilder<DefaultMapperFactory, Builder> {
        @Override
        public DefaultMapperFactory build() {
            return new DefaultMapperFactory(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class MapperFactoryBuilder<F extends DefaultMapperFactory, B extends MapperFactoryBuilder<F, B>> {
        protected UnenhanceStrategy unenhanceStrategy;
        protected SuperTypeResolverStrategy superTypeStrategy;
        protected ConstructorResolverStrategy constructorResolverStrategy;
        protected CompilerStrategy compilerStrategy;
        protected Set<ClassMap<?, ?>> classMaps;
        protected ConverterFactory converterFactory = UtilityResolver.getDefaultConverterFactory();
        protected PropertyResolverStrategy propertyResolverStrategy;
        protected ClassMapBuilderFactory classMapBuilderFactory;
        protected MappingContextFactory mappingContextFactory;
        protected CodeGenerationStrategy codeGenerationStrategy;
        protected Boolean useBuiltinConverters;
        protected Boolean useAutoMapping;
        protected Boolean mapNulls;
        protected Boolean dumpStateOnException;
        protected Boolean favorExtension;
        protected Boolean captureFieldContext;

        public MapperFactoryBuilder() {
            this.constructorResolverStrategy = UtilityResolver.getDefaultConstructorResolverStrategy();
            this.compilerStrategy = UtilityResolver.getDefaultCompilerStrategy();
            this.propertyResolverStrategy = UtilityResolver.getDefaultPropertyResolverStrategy();
            this.classMapBuilderFactory = UtilityResolver.getDefaultClassMapBuilderFactory();
            this.mappingContextFactory = UtilityResolver.getDefaultMappingContextFactory();
            this.useBuiltinConverters = Boolean.valueOf(System.getProperty("ma.glasnost.orika.useBuiltinConverters", "true"));
            this.useAutoMapping = Boolean.valueOf(System.getProperty("ma.glasnost.orika.useAutoMapping", "true"));
            this.mapNulls = Boolean.valueOf(System.getProperty("ma.glasnost.orika.mapNulls", "true"));
            this.dumpStateOnException = Boolean.valueOf(System.getProperty("ma.glasnost.orika.dumpStateOnException", "false"));
            this.favorExtension = Boolean.valueOf(System.getProperty("ma.glasnost.orika.favorExtension", "false"));
            this.captureFieldContext = Boolean.valueOf(System.getProperty("ma.glasnost.orika.captureFieldContext", "false"));
            this.codeGenerationStrategy = new DefaultCodeGenerationStrategy();
        }

        protected abstract B self();

        public B classMaps(Set<ClassMap<?, ?>> classMaps) {
            this.classMaps = classMaps;
            return this.self();
        }

        public B unenhanceStrategy(UnenhanceStrategy unenhanceStrategy) {
            this.unenhanceStrategy = unenhanceStrategy;
            return this.self();
        }

        public B superTypeResolverStrategy(SuperTypeResolverStrategy superTypeStrategy) {
            this.superTypeStrategy = superTypeStrategy;
            return this.self();
        }

        public B constructorResolverStrategy(ConstructorResolverStrategy constructorResolverStrategy) {
            this.constructorResolverStrategy = constructorResolverStrategy;
            return this.self();
        }

        public B converterFactory(ConverterFactory converterFactory) {
            this.converterFactory = converterFactory;
            return this.self();
        }

        public B compilerStrategy(CompilerStrategy compilerStrategy) {
            this.compilerStrategy = compilerStrategy;
            return this.self();
        }

        public B propertyResolverStrategy(PropertyResolverStrategy propertyResolverStrategy) {
            this.propertyResolverStrategy = propertyResolverStrategy;
            return this.self();
        }

        public B classMapBuilderFactory(ClassMapBuilderFactory classMapBuilderFactory) {
            this.classMapBuilderFactory = classMapBuilderFactory;
            return this.self();
        }

        public B mappingContextFactory(MappingContextFactory mappingContextFactory) {
            this.mappingContextFactory = mappingContextFactory;
            return this.self();
        }

        public B useAutoMapping(boolean useAutoMapping) {
            this.useAutoMapping = useAutoMapping;
            return this.self();
        }

        public B useBuiltinConverters(boolean useBuiltinConverters) {
            this.useBuiltinConverters = useBuiltinConverters;
            return this.self();
        }

        @Deprecated
        public B usedBuiltinConverters(boolean useBuiltinConverters) {
            this.useBuiltinConverters = useBuiltinConverters;
            return this.self();
        }

        public B mapNulls(boolean mapNulls) {
            this.mapNulls = mapNulls;
            return this.self();
        }

        public B dumpStateOnException(boolean dumpStateOnException) {
            this.dumpStateOnException = dumpStateOnException;
            return this.self();
        }

        public B favorExtension(boolean favorExtension) {
            this.favorExtension = favorExtension;
            return this.self();
        }

        public B captureFieldContext(boolean captureFieldContext) {
            this.captureFieldContext = captureFieldContext;
            return this.self();
        }

        public CodeGenerationStrategy getCodeGenerationStrategy() {
            return this.codeGenerationStrategy;
        }

        public B codeGenerationStrategy(CodeGenerationStrategy codeGenerationStrategy) {
            this.codeGenerationStrategy = codeGenerationStrategy;
            return this.self();
        }

        public abstract F build();
    }
}

