/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslNpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslX509Certificate;
import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSLContext;

public abstract class OpenSslContext
extends SslContext {
    private static final InternalLogger logger;
    private static final List<String> DEFAULT_CIPHERS;
    private static final AtomicIntegerFieldUpdater<OpenSslContext> DESTROY_UPDATER;
    protected static final int VERIFY_DEPTH = 10;
    private final long aprPool;
    private volatile int aprPoolDestroyed;
    private final List<String> ciphers = new ArrayList<String>();
    private final List<String> unmodifiableCiphers = Collections.unmodifiableList(this.ciphers);
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    protected final long ctx;
    private final int mode;

    OpenSslContext(Iterable<String> ciphers, ApplicationProtocolConfig apnCfg, long sessionCacheSize, long sessionTimeout, int mode) throws SSLException {
        this(ciphers, OpenSslContext.toNegotiator(apnCfg, mode == 1), sessionCacheSize, sessionTimeout, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslContext(Iterable<String> ciphers, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout, int mode) throws SSLException {
        OpenSsl.ensureAvailability();
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.mode = mode;
        if (ciphers == null) {
            ciphers = DEFAULT_CIPHERS;
        }
        for (String c : ciphers) {
            if (c == null) break;
            String converted = CipherSuiteConverter.toOpenSsl(c);
            if (converted != null) {
                c = converted;
            }
            this.ciphers.add(c);
        }
        this.apn = (OpenSslApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)apn, (String)"apn");
        this.aprPool = Pool.create((long)0L);
        boolean success = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                try {
                    this.ctx = SSLContext.make((long)this.aprPool, (int)28, (int)mode);
                }
                catch (Exception e) {
                    throw new SSLException("failed to create an SSL_CTX", e);
                }
                SSLContext.setOptions((long)this.ctx, (int)4095);
                SSLContext.setOptions((long)this.ctx, (int)0x1000000);
                SSLContext.setOptions((long)this.ctx, (int)0x2000000);
                SSLContext.setOptions((long)this.ctx, (int)0x400000);
                SSLContext.setOptions((long)this.ctx, (int)524288);
                SSLContext.setOptions((long)this.ctx, (int)0x100000);
                SSLContext.setOptions((long)this.ctx, (int)65536);
                try {
                    SSLContext.setCipherSuite((long)this.ctx, (String)CipherSuiteConverter.toOpenSsl(this.ciphers));
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set cipher suite: " + this.ciphers, e);
                }
                List<String> nextProtoList = apn.protocols();
                if (!nextProtoList.isEmpty()) {
                    StringBuilder nextProtocolBuf = new StringBuilder();
                    for (String p : nextProtoList) {
                        nextProtocolBuf.append(p);
                        nextProtocolBuf.append(',');
                    }
                    nextProtocolBuf.setLength(nextProtocolBuf.length() - 1);
                    SSLContext.setNextProtos((long)this.ctx, (String)nextProtocolBuf.toString());
                }
                if (sessionCacheSize > 0L) {
                    this.sessionCacheSize = sessionCacheSize;
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                } else {
                    this.sessionCacheSize = sessionCacheSize = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)sessionCacheSize);
                }
                if (sessionTimeout > 0L) {
                    this.sessionTimeout = sessionTimeout;
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                } else {
                    this.sessionTimeout = sessionTimeout = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)sessionTimeout);
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroyPools();
            }
        }
        {
            return;
        }
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc, String peerHost, int peerPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator alloc) {
        List<String> protos = this.applicationProtocolNegotiator().protocols();
        OpenSslEngineMap engineMap = this.engineMap();
        OpenSslEngine engine = protos.isEmpty() ? new OpenSslEngine(this.ctx, alloc, null, this.isClient(), this.sessionContext(), engineMap) : new OpenSslEngine(this.ctx, alloc, protos.get(protos.size() - 1), this.isClient(), this.sessionContext(), engineMap);
        engineMap.add(engine);
        return engine;
    }

    abstract OpenSslEngineMap engineMap();

    public final long context() {
        return this.ctx;
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        super.finalize();
        Class<OpenSslContext> clazz = OpenSslContext.class;
        synchronized (OpenSslContext.class) {
            if (this.ctx != 0L) {
                SSLContext.free((long)this.ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.destroyPools();
            return;
        }
    }

    @Deprecated
    public final void setTicketKeys(byte[] keys) {
        this.sessionContext().setTicketKeys(keys);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    protected final void destroyPools() {
        if (this.aprPool != 0L && DESTROY_UPDATER.compareAndSet(this, 0, 1)) {
            Pool.destroy((long)this.aprPool);
        }
    }

    protected static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSslX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config, boolean isServer) {
        if (config == null) {
            return OpenSslDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (config.protocol()) {
            case NONE: {
                return OpenSslDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case NPN: {
                if (isServer) {
                    switch (config.selectedListenerFailureBehavior()) {
                        case CHOOSE_MY_LAST_PROTOCOL: {
                            return new OpenSslNpnApplicationProtocolNegotiator(config.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)config.selectedListenerFailureBehavior()) + " behavior");
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support client mode");
            }
        }
        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)config.protocol()) + " protocol");
    }

    static OpenSslEngineMap newEngineMap(X509TrustManager trustManager) {
        if (OpenSslContext.useExtendedTrustManager(trustManager)) {
            return new DefaultOpenSslEngineMap();
        }
        return OpenSslEngineMap.EMPTY;
    }

    static boolean useExtendedTrustManager(X509TrustManager trustManager) {
        return PlatformDependent.javaVersion() >= 7 && trustManager instanceof X509ExtendedTrustManager;
    }

    static {
        AtomicIntegerFieldUpdater<OpenSslContext> updater;
        logger = InternalLoggerFactory.getInstance(OpenSslContext.class);
        ArrayList ciphers = new ArrayList();
        Collections.addAll(ciphers, "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA", "AES256-SHA", "DES-CBC3-SHA", "RC4-SHA");
        DEFAULT_CIPHERS = Collections.unmodifiableList(ciphers);
        if (logger.isDebugEnabled()) {
            logger.debug("Default cipher suite (OpenSSL): " + ciphers);
        }
        if ((updater = PlatformDependent.newAtomicIntegerFieldUpdater(OpenSslContext.class, (String)"aprPoolDestroyed")) == null) {
            updater = AtomicIntegerFieldUpdater.newUpdater(OpenSslContext.class, "aprPoolDestroyed");
        }
        DESTROY_UPDATER = updater;
    }

    private static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, OpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        @Override
        public OpenSslEngine remove(long ssl) {
            return this.engines.remove(ssl);
        }

        @Override
        public void add(OpenSslEngine engine) {
            this.engines.put(engine.ssl(), engine);
        }
    }

    static abstract class AbstractCertificateVerifier
    implements CertificateVerifier {
        AbstractCertificateVerifier() {
        }

        public final boolean verify(long ssl, byte[][] chain, String auth) {
            X509Certificate[] peerCerts = OpenSslContext.certificates(chain);
            try {
                this.verify(ssl, peerCerts, auth);
                return true;
            }
            catch (Exception e) {
                logger.debug("verification of certificate failed", (Throwable)e);
                return false;
            }
        }

        abstract void verify(long var1, X509Certificate[] var3, String var4) throws Exception;
    }
}

