/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.dson;

import de.ruedigermoeller.serialization.dson.DsonCharInput;

public class DsonStringCharInput
implements DsonCharInput {
    String s;
    int pos;
    int end;

    public DsonStringCharInput(String s) {
        this.s = s;
        this.pos = 0;
        this.end = s.length();
    }

    public DsonStringCharInput(String s, int pos, int len) {
        this.s = s;
        this.pos = pos;
        this.end = pos + len;
    }

    @Override
    public int readChar() {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.s.charAt(this.pos++);
    }

    @Override
    public int peekChar() {
        if (this.pos > this.end) {
            return -1;
        }
        return this.s.charAt(this.pos);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public int back(int num) {
        return this.pos--;
    }

    @Override
    public String getString(int pos, int length) {
        return this.s.substring(Math.max(0, pos), Math.min(this.s.length(), pos + length));
    }
}

