/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.api.resumableio;

import com.qiniu.api.config.Config;
import com.qiniu.api.io.PutRet;
import com.qiniu.api.net.CallRet;
import com.qiniu.api.net.EncodeUtils;
import com.qiniu.api.resumableio.ChunkUploadCallRet;
import com.qiniu.api.resumableio.UploadBlock;
import com.qiniu.api.resumableio.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public abstract class SliceUpload {
    protected static final int BLOCK_SIZE = 0x400000;
    public static int triedTimes = 3;
    public String host = Config.UP_HOST;
    public HttpClient httpClient;
    protected String token;
    protected String key;
    protected String mimeType;
    protected long contentLength = -1L;
    protected long lastUploadLength = 0L;
    protected long currentUploadLength = 0L;

    public SliceUpload(String token, String key, String mimeType) {
        this.token = token;
        this.key = key;
        this.mimeType = mimeType;
    }

    public PutRet execute() {
        List<ChunkUploadCallRet> rets = this.sliceAndUpload();
        CallRet ret = this.mkfile(rets);
        this.doClean();
        return new PutRet(ret);
    }

    protected List<ChunkUploadCallRet> sliceAndUpload() {
        ArrayList<ChunkUploadCallRet> rets = new ArrayList<ChunkUploadCallRet>();
        while (this.hasNext()) {
            ChunkUploadCallRet ret = this.nextUploadBlock();
            rets.add(ret);
        }
        return rets;
    }

    protected ChunkUploadCallRet nextUploadBlock() {
        try {
            UploadBlock upload = this.buildNextBlockUpload();
            ChunkUploadCallRet ret = upload.execute();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean hasNext();

    protected abstract UploadBlock buildNextBlockUpload() throws IOException;

    protected CallRet mkfile(List<ChunkUploadCallRet> rets) {
        String ctx = this.mkCtx(rets);
        return this.mkfile(ctx, 0);
    }

    protected String mkCtx(List<ChunkUploadCallRet> rets) {
        StringBuffer sb = new StringBuffer();
        for (ChunkUploadCallRet ret : rets) {
            sb.append(",").append(ret.getCtx());
        }
        return sb.substring(1);
    }

    private CallRet mkfile(String ctx, int time) {
        try {
            String url = this.buildMkfileUrl();
            HttpPost post = Util.buildUpPost(url, this.token);
            post.setEntity((HttpEntity)new StringEntity(ctx));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            CallRet ret = Util.handleResult(response);
            if ((ret.statusCode == 406 || ret.statusCode == 701 || ret.statusCode / 100 == 5) && time < triedTimes) {
                return this.mkfile(ctx, time + 1);
            }
            return ret;
        }
        catch (Exception e) {
            if (time < triedTimes) {
                return this.mkfile(ctx, time + 1);
            }
            throw new RuntimeException(e);
        }
    }

    private String buildMkfileUrl() {
        String url = this.host + "/mkfile/" + (this.currentUploadLength + this.lastUploadLength);
        if (null != this.key) {
            url = url + "/key/" + EncodeUtils.urlsafeEncode(this.key);
        }
        if (null != this.mimeType && this.mimeType.trim().length() != 0) {
            url = url + "/mimeType/" + EncodeUtils.urlsafeEncode(this.mimeType);
        }
        return url;
    }

    private void doClean() {
        try {
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void clean() throws Exception;

    protected void addSuccessLength(long size) {
        this.currentUploadLength += size;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastUploadLength() {
        return this.lastUploadLength;
    }

    public long getCurrentUploadLength() {
        return this.currentUploadLength;
    }
}

