/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockInstances {
    private final List<Object> mocks = new ArrayList<Object>();
    private final Map<Object, Object> mockedInstancesToMocks = new HashMap<Object, Object>();

    public boolean containsInstance(Object mock) {
        return this.mocks.contains(mock);
    }

    public int getInstanceCount() {
        return this.mocks.size();
    }

    public Object getMock(int index) {
        return this.mocks.get(index);
    }

    public Object getMock(Class<?> mockClass, Object mockedInstance) {
        Object mock = this.mockedInstancesToMocks.get(mockedInstance);
        if (mock == null) {
            mock = Utilities.newInstance(mockClass);
            this.mockedInstancesToMocks.put(mockedInstance, mock);
        }
        return mock;
    }

    public int addMock(Object mock) {
        this.mocks.add(mock);
        return this.mocks.size() - 1;
    }

    void removeInstances(int fromIndex) {
        for (int i = this.mocks.size() - 1; i >= fromIndex; --i) {
            this.mocks.remove(i);
        }
    }

    public void discardInstances() {
        this.mocks.clear();
    }
}

