/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockFixture {
    private final Map<String, byte[]> fixedClassDefinitions = new HashMap<String, byte[]>();
    private final Map<String, byte[]> transformedClasses = new HashMap<String, byte[]>(2);
    private final Map<Class<?>, byte[]> redefinedClasses = new HashMap(8);
    private final Set<String> redefinedClassesWithNativeMethods = new HashSet<String>();
    private final Map<Class<?>, String> realClassesToMockClasses = new HashMap(8);
    private final Map<Class<?>, InstanceFactory> mockedTypesAndInstances = new HashMap();

    public void addFixedClass(String className, byte[] fixedClassfile) {
        this.fixedClassDefinitions.put(className, fixedClassfile);
    }

    public void addTransformedClass(String className, byte[] pretransformClassfile) {
        this.transformedClasses.put(className, pretransformClassfile);
    }

    public void addRedefinedClass(String mockClassInternalName, Class<?> redefinedClass, byte[] modifiedClassfile) {
        String previousNames;
        if (mockClassInternalName != null && (previousNames = this.realClassesToMockClasses.put(redefinedClass, mockClassInternalName)) != null) {
            this.realClassesToMockClasses.put(redefinedClass, previousNames + ' ' + mockClassInternalName);
        }
        this.addRedefinedClass(redefinedClass, modifiedClassfile);
    }

    public void addRedefinedClass(Class<?> redefinedClass, byte[] modifiedClassfile) {
        this.redefinedClasses.put(redefinedClass, modifiedClassfile);
    }

    public void addInstanceForMockedType(Class<?> mockedType, InstanceFactory mockInstanceFactory) {
        this.mockedTypesAndInstances.put(mockedType, mockInstanceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNewInstanceForMockedType(Class<?> mockedType) {
        InstanceFactory instanceFactory = this.mockedTypesAndInstances.get(mockedType);
        if (instanceFactory == null) {
            return null;
        }
        TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(true);
        try {
            Object object = instanceFactory.create();
            return object;
        }
        finally {
            TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(false);
        }
    }

    public void restoreAndRemoveTransformedClasses(Set<String> transformedClassesToRestore) {
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (String transformedClassName : transformedClassesToRestore) {
            byte[] definitionToRestore = this.transformedClasses.get(transformedClassName);
            redefinitionEngine.restoreToDefinition(transformedClassName, definitionToRestore);
        }
        this.transformedClasses.keySet().removeAll(transformedClassesToRestore);
    }

    public void restoreAndRemoveRedefinedClasses(Set<Class<?>> redefinedClassesToRestore) {
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (Class<?> redefinedClass : redefinedClassesToRestore) {
            redefinitionEngine.restoreOriginalDefinition(redefinedClass);
            if (this.redefinedClassesWithNativeMethods.contains(redefinedClass.getName())) {
                this.reregisterNativeMethodsForRestoredClass(redefinedClass);
            }
            this.discardStateForCorrespondingMockClassIfAny(redefinedClass);
        }
        this.redefinedClasses.keySet().removeAll(redefinedClassesToRestore);
        this.mockedTypesAndInstances.keySet().removeAll(redefinedClassesToRestore);
    }

    private void discardStateForCorrespondingMockClassIfAny(Class<?> redefinedClass) {
        String mockClassesInternalNames = this.realClassesToMockClasses.remove(redefinedClass);
        TestRun.getMockClasses().getMockStates().removeClassState(redefinedClass, mockClassesInternalNames);
    }

    public void addRedefinedClassWithNativeMethods(String redefinedClassInternalName) {
        this.redefinedClassesWithNativeMethods.add(redefinedClassInternalName.replace('/', '.'));
    }

    private void reregisterNativeMethodsForRestoredClass(Class<?> realClass) {
        Method registerNatives = null;
        try {
            registerNatives = realClass.getDeclaredMethod("registerNatives", new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            try {
                registerNatives = realClass.getDeclaredMethod("initIDs", new Class[0]);
            }
            catch (NoSuchMethodException alsoIgnore) {
                // empty catch block
            }
        }
        if (registerNatives != null) {
            try {
                registerNatives.setAccessible(true);
                registerNatives.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public byte[] getFixedClassfile(String className) {
        return this.fixedClassDefinitions.get(className);
    }

    public int getRedefinedClassCount() {
        return this.redefinedClasses.size();
    }

    public byte[] getRedefinedClassfile(Class<?> redefinedClass) {
        return this.redefinedClasses.get(redefinedClass);
    }

    public Set<String> getTransformedClasses() {
        return this.transformedClasses.keySet();
    }

    public Set<Class<?>> getRedefinedClasses() {
        return this.redefinedClasses.keySet();
    }

    public boolean containsRedefinedClass(Class<?> redefinedClass) {
        return this.redefinedClasses.containsKey(redefinedClass);
    }

    public void turnRedefinedClassesIntoFixedOnes() {
        Iterator<Map.Entry<Class<?>, byte[]>> itr = this.redefinedClasses.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Class<?>, byte[]> classAndBytecode = itr.next();
            itr.remove();
            this.addFixedClass(classAndBytecode.getKey().getName(), classAndBytecode.getValue());
        }
    }
}

