/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.invocation.MockedTypeCascade;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutingTest {
    private RecordAndReplayExecution currentRecordAndReplay;
    private RecordAndReplayExecution recordAndReplayForLastTestMethod;
    private boolean shouldIgnoreMockingCallbacks;
    private ParameterTypeRedefinitions parameterTypeRedefinitions;
    private final Map<MockedType, Object> finalLocalMockFields = new HashMap<MockedType, Object>(4);
    private final List<Object> injectableMocks = new ArrayList<Object>();
    private final Map<Object, Object> originalToCapturedInstance = new IdentityHashMap<Object, Object>(4);
    private final List<Object> nonStrictMocks = new ArrayList<Object>();
    private final List<Object> strictMocks = new ArrayList<Object>();
    private final Map<String, MockedTypeCascade> cascadingTypes = new HashMap<String, MockedTypeCascade>(4);

    RecordAndReplayExecution getRecordAndReplay(boolean createIfUndefined) {
        if (this.currentRecordAndReplay == null && createIfUndefined) {
            this.setRecordAndReplay(new RecordAndReplayExecution());
        }
        return this.currentRecordAndReplay;
    }

    public RecordAndReplayExecution getRecordAndReplay() {
        this.recordAndReplayForLastTestMethod = null;
        RecordAndReplayExecution previous = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        return previous;
    }

    public void setRecordAndReplay(RecordAndReplayExecution newRecordAndReplay) {
        this.recordAndReplayForLastTestMethod = null;
        this.currentRecordAndReplay = newRecordAndReplay;
    }

    public boolean isShouldIgnoreMockingCallbacks() {
        return this.shouldIgnoreMockingCallbacks;
    }

    public void setShouldIgnoreMockingCallbacks(boolean flag) {
        this.shouldIgnoreMockingCallbacks = flag;
    }

    public void clearRecordAndReplayForVerifications() {
        this.recordAndReplayForLastTestMethod = null;
    }

    public RecordAndReplayExecution getRecordAndReplayForVerifications() {
        if (this.currentRecordAndReplay == null) {
            this.currentRecordAndReplay = this.recordAndReplayForLastTestMethod != null ? this.recordAndReplayForLastTestMethod : new RecordAndReplayExecution();
        }
        return this.currentRecordAndReplay;
    }

    public ParameterTypeRedefinitions getParameterTypeRedefinitions() {
        return this.parameterTypeRedefinitions;
    }

    public void setParameterTypeRedefinitions(ParameterTypeRedefinitions redefinitions) {
        this.parameterTypeRedefinitions = redefinitions;
    }

    public void clearInjectableAndNonStrictMocks() {
        this.injectableMocks.clear();
        this.clearNonStrictMocks();
        this.originalToCapturedInstance.clear();
    }

    public void addInjectableMock(Object mock) {
        if (!this.isInjectableMock(mock)) {
            this.injectableMocks.add(mock);
        }
    }

    public boolean isInjectableMock(Object mock) {
        for (Object injectableMock : this.injectableMocks) {
            if (mock != injectableMock) continue;
            return true;
        }
        return false;
    }

    public void addCapturedInstanceForInjectableMock(Object originalInstance, Object capturedInstance) {
        this.injectableMocks.add(capturedInstance);
        this.addCapturedInstance(originalInstance, capturedInstance);
    }

    public void addCapturedInstance(Object originalInstance, Object capturedInstance) {
        this.originalToCapturedInstance.put(capturedInstance, originalInstance);
    }

    public boolean isInvokedInstanceEquivalentToCapturedInstance(Object invokedInstance, Object capturedInstance) {
        return invokedInstance == this.originalToCapturedInstance.get(capturedInstance) || capturedInstance == this.originalToCapturedInstance.get(invokedInstance);
    }

    public void discardCascadedMockWhenInjectable(Object oldMock) {
        int n = this.injectableMocks.size();
        for (int i = 0; i < n; ++i) {
            if (this.injectableMocks.get(i) != oldMock) continue;
            this.injectableMocks.remove(i);
            return;
        }
    }

    public void addNonStrictMock(Class<?> mockedClass) {
        String mockedClassDesc = mockedClass.getName().replace('.', '/');
        String uniqueClassDesc = mockedClassDesc.intern();
        if (!this.containsNonStrictMockedClass(uniqueClassDesc)) {
            this.nonStrictMocks.add(uniqueClassDesc);
        }
    }

    private boolean containsNonStrictMockedClass(Object mockOrClassDesc) {
        for (Object nonStrictMock : this.nonStrictMocks) {
            if (mockOrClassDesc != nonStrictMock) continue;
            return true;
        }
        return false;
    }

    public void addNonStrictMock(Object mock) {
        if (!this.containsNonStrictMockedClass(mock)) {
            this.nonStrictMocks.add(mock);
        }
        this.addNonStrictMock(mock.getClass());
    }

    public void addFinalLocalMockField(Object owner, MockedType typeMetadata) {
        this.finalLocalMockFields.put(typeMetadata, owner);
    }

    public void addStrictMock(Object mock, String mockClassDesc) {
        String uniqueMockClassDesc;
        this.addStrictMock(mock);
        if (mockClassDesc != null && !this.containsStrictMock(uniqueMockClassDesc = mockClassDesc.intern()) && !this.containsNonStrictMockedClass(uniqueMockClassDesc)) {
            this.strictMocks.add(uniqueMockClassDesc);
        }
    }

    private void addStrictMock(Object mock) {
        if (mock != null && !this.containsStrictMock(mock)) {
            this.strictMocks.add(mock);
        }
    }

    private boolean containsStrictMock(Object mockOrClass) {
        for (Object strictMock : this.strictMocks) {
            if (mockOrClass != strictMock) continue;
            return true;
        }
        return false;
    }

    public boolean isNonStrictInvocation(Object mock, String mockClassDesc, String mockNameAndDesc) {
        boolean instanceMethod = this.isInstanceMethod(mock, mockNameAndDesc);
        if (instanceMethod && this.isOverrideOfObjectMethod(mockNameAndDesc)) {
            return true;
        }
        for (Object nonStrictMock : this.nonStrictMocks) {
            if (!(!instanceMethod ? nonStrictMock == mockClassDesc : nonStrictMock == mock)) continue;
            return true;
        }
        return false;
    }

    private boolean isInstanceMethod(Object mock, String mockNameAndDesc) {
        return mock != null && mockNameAndDesc.charAt(0) != '<';
    }

    private boolean isOverrideOfObjectMethod(String mockNameAndDesc) {
        return "equals(Ljava/lang/Object;)Z hashCode()I toString()Ljava/lang/String;".contains(mockNameAndDesc);
    }

    public void registerAdditionalMocksFromFinalLocalMockFieldsIfAny() {
        if (!this.finalLocalMockFields.isEmpty()) {
            Iterator<Map.Entry<MockedType, Object>> itr = this.finalLocalMockFields.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<MockedType, Object> fieldAndOwner = itr.next();
                MockedType typeMetadata = fieldAndOwner.getKey();
                Object mock = Utilities.getFieldValue(typeMetadata.field, fieldAndOwner.getValue());
                if (mock == null) continue;
                this.registerMock(typeMetadata, mock);
                itr.remove();
            }
        }
    }

    public void registerMock(MockedType typeMetadata, Object mock) {
        if (typeMetadata.injectable) {
            this.addInjectableMock(mock);
        }
        if (typeMetadata.nonStrict) {
            this.addNonStrictMock(mock);
        }
    }

    public boolean isStrictInvocation(Object mock, String mockClassDesc, String mockNameAndDesc) {
        if (this.isInstanceMethod(mock, mockNameAndDesc) && this.isOverrideOfObjectMethod(mockNameAndDesc)) {
            return false;
        }
        for (Object strictMock : this.strictMocks) {
            if (strictMock == mock) {
                return true;
            }
            if (strictMock != mockClassDesc) continue;
            this.addStrictMock(mock);
            return true;
        }
        return false;
    }

    public void clearNonStrictMocks() {
        this.finalLocalMockFields.clear();
        this.nonStrictMocks.clear();
    }

    public void addCascadingType(String mockedTypeDesc, boolean mockFieldFromTestClass) {
        if (!this.cascadingTypes.containsKey(mockedTypeDesc)) {
            this.cascadingTypes.put(mockedTypeDesc, new MockedTypeCascade(mockFieldFromTestClass));
        }
    }

    public MockedTypeCascade getMockedTypeCascade(String mockedTypeDesc, Object mockInstance) {
        if (this.cascadingTypes.isEmpty()) {
            return null;
        }
        MockedTypeCascade cascade = this.cascadingTypes.get(mockedTypeDesc);
        if (cascade != null || mockInstance == null) {
            return cascade;
        }
        return this.getMockedTypeCascade(mockedTypeDesc, mockInstance.getClass());
    }

    private MockedTypeCascade getMockedTypeCascade(String invokedTypeDesc, Class<?> mockedType) {
        Class<?> typeToLookFor = mockedType;
        do {
            String typeDesc;
            if (invokedTypeDesc.equals(typeDesc = typeToLookFor.getName().replace('.', '/'))) {
                return null;
            }
            MockedTypeCascade cascade = this.cascadingTypes.get(typeDesc);
            if (cascade == null) continue;
            return cascade;
        } while ((typeToLookFor = typeToLookFor.getSuperclass()) != Object.class);
        return null;
    }

    void finishExecution() {
        this.recordAndReplayForLastTestMethod = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        if (this.parameterTypeRedefinitions != null) {
            this.parameterTypeRedefinitions.cleanUp();
            this.parameterTypeRedefinitions = null;
        }
        this.clearNonStrictMocks();
        this.strictMocks.clear();
        this.clearNonSharedCascadingTypes();
    }

    private void clearNonSharedCascadingTypes() {
        Iterator<MockedTypeCascade> itr = this.cascadingTypes.values().iterator();
        while (itr.hasNext()) {
            MockedTypeCascade cascade = itr.next();
            if (cascade.mockFieldFromTestClass) continue;
            itr.remove();
        }
    }
}

