/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

final class StartupConfiguration {
    private static final String DEFAULT_TOOLS_KEY = "defaultTools";
    private static final String DEFAULT_TOOLS_VALUE = "mockit.coverage.CodeCoverage mockit.integration.junit4.IncrementalJUnit4Runner mockit.emulation.hibernate3.ConfigurationEmul";
    private static final String STARTUP_TOOL_PREFIX = "startupTools.";
    private final Properties startupTools = new Properties();
    final List<String> defaultTools;
    String toolClassName;
    String toolArguments;

    StartupConfiguration() throws IOException {
        this.loadPropertiesFile();
        this.loadSystemProperties();
        this.defaultTools = new ArrayList<String>();
        this.fillListOfDefaultTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertiesFile() throws IOException {
        InputStream properties = this.getClass().getResourceAsStream("/jmockit.properties");
        try {
            this.startupTools.load(properties);
        }
        finally {
            properties.close();
        }
    }

    private void loadSystemProperties() {
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> prop : this.startupTools.entrySet()) {
            String name = (String)prop.getKey();
            if (DEFAULT_TOOLS_KEY.equals(name) || name.startsWith(STARTUP_TOOL_PREFIX)) continue;
            this.addToSystemProperties(systemProperties, name, prop.getValue());
        }
    }

    private void addToSystemProperties(Properties systemProperties, String name, Object value) {
        String sysPropName;
        String string = sysPropName = name.startsWith("jmockit-") ? name : "jmockit-" + name;
        if (!systemProperties.containsKey(sysPropName)) {
            systemProperties.put(sysPropName, value);
        }
    }

    private void fillListOfDefaultTools() {
        String specifiedTools = System.getProperty("jmockit-tools");
        String[] defaultToolsArray = specifiedTools == null ? this.startupTools.getProperty(DEFAULT_TOOLS_KEY, DEFAULT_TOOLS_VALUE).split("\\s+") : specifiedTools.split(",");
        Collections.addAll(this.defaultTools, defaultToolsArray);
    }

    void extractClassNameAndArgumentsFromToolSpecification(String toolSpec, boolean byDefault) {
        String toolKey;
        String[] classAndArgs = toolSpec.split("\\s*=\\s*");
        this.toolClassName = classAndArgs[0];
        String string = this.toolArguments = classAndArgs.length == 1 ? null : classAndArgs[1];
        if (!byDefault) {
            this.defaultTools.remove(this.toolClassName);
        }
        if (this.startupTools.containsKey(toolKey = STARTUP_TOOL_PREFIX + this.toolClassName)) {
            this.toolClassName = this.startupTools.getProperty(toolKey);
        }
    }

    public String toString() {
        String toolArgsDescription = this.toolArguments == null ? "" : '=' + this.toolArguments;
        return this.toolClassName + toolArgsDescription;
    }
}

