/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;
import mockit.internal.expectations.transformation.ActiveInvocations;

final class InvocationBlockModifier
extends MethodAdapter {
    private static final String CLASS_DESC = ActiveInvocations.class.getName().replace('.', '/');
    private final int[] matcherStacks = new int[20];
    private final MethodWriter mw;
    private final String fieldOwner;
    private int matchers;

    InvocationBlockModifier(MethodWriter mw, String fieldOwner) {
        super(mw);
        this.mw = mw;
        this.fieldOwner = fieldOwner;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if ((opcode == 178 || opcode == 179) && this.fieldOwner.equals(owner)) {
            if (opcode == 179) {
                if ("result".equals(name)) {
                    this.mw.visitMethodInsn(184, CLASS_DESC, "addResult", "(Ljava/lang/Object;)V");
                    return;
                }
                if ("forEachInvocation".equals(name)) {
                    this.mw.visitMethodInsn(184, CLASS_DESC, "setHandler", "(Ljava/lang/Object;)V");
                    return;
                }
                if ("times".equals(name) || "minTimes".equals(name) || "maxTimes".equals(name)) {
                    this.mw.visitMethodInsn(184, CLASS_DESC, name, "(I)V");
                    return;
                }
                if ("$".equals(name)) {
                    this.mw.visitMethodInsn(184, CLASS_DESC, "setErrorMessage", "(Ljava/lang/CharSequence;)V");
                    return;
                }
            } else if (name.startsWith("any")) {
                this.mw.visitFieldInsn(178, owner, name, desc);
                this.mw.visitMethodInsn(184, CLASS_DESC, "addArgMatcher", "()V");
                this.matcherStacks[this.matchers++] = this.mw.stackSize2;
                return;
            }
        }
        this.mw.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type[] argTypes;
        int stackSize;
        int stackAfter;
        if (opcode == 182 && owner.equals(this.fieldOwner) && name.startsWith("with")) {
            this.mw.visitMethodInsn(182, owner, name, desc);
            this.matcherStacks[this.matchers++] = this.mw.stackSize2;
            return;
        }
        if (this.matchers > 0 && (stackAfter = (stackSize = this.mw.stackSize2) - this.sumOfSizes(argTypes = Type.getArgumentTypes(desc))) < this.matcherStacks[0]) {
            this.generateCallsToMoveArgMatchers(argTypes, stackAfter);
            this.matchers = 0;
        }
        this.mw.visitMethodInsn(opcode, owner, name, desc);
    }

    private int sumOfSizes(Type[] argTypes) {
        int sum = 0;
        for (Type argType : argTypes) {
            sum += argType.getSize();
        }
        return sum;
    }

    private void generateCallsToMoveArgMatchers(Type[] argTypes, int initialStack) {
        int stack = initialStack;
        int nextMatcher = 0;
        int matcherStack = this.matcherStacks[0];
        for (int i = 0; i < argTypes.length && nextMatcher < this.matchers; ++i) {
            if ((stack += argTypes[i].getSize()) != matcherStack && stack != matcherStack + 1) continue;
            if (nextMatcher < i) {
                this.generateCallToMoveArgMatcher(nextMatcher, i);
            }
            matcherStack = this.matcherStacks[++nextMatcher];
        }
    }

    private void generateCallToMoveArgMatcher(int originalMatcherIndex, int toIndex) {
        this.mw.visitIntInsn(17, originalMatcherIndex);
        this.mw.visitIntInsn(17, toIndex);
        this.mw.visitMethodInsn(184, CLASS_DESC, "moveArgMatcher", "(II)V");
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (end.position > 0) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    public void visitInsn(int opcode) {
        if (opcode == 177) {
            this.mw.visitMethodInsn(184, CLASS_DESC, "endInvocations", "()V");
        }
        this.mw.visitInsn(opcode);
    }
}

