/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import mockit.Expectations;
import mockit.FullVerifications;
import mockit.FullVerificationsInOrder;
import mockit.NonStrictExpectations;
import mockit.Verifications;
import mockit.VerificationsInOrder;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.transformation.InvocationBlockModifier;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import mockit.internal.util.VisitInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpectationsTransformer
implements ClassFileTransformer {
    private final SuperClassAnalyser superClassAnalyser = new SuperClassAnalyser();
    private final List<String> baseSubclasses = new ArrayList<String>();

    public ExpectationsTransformer(Instrumentation instrumentation) {
        this.baseSubclasses.add("mockit/Expectations");
        this.baseSubclasses.add("mockit/NonStrictExpectations");
        this.baseSubclasses.add("mockit/Verifications");
        this.baseSubclasses.add("mockit/FullVerifications");
        this.baseSubclasses.add("mockit/VerificationsInOrder");
        this.baseSubclasses.add("mockit/FullVerificationsInOrder");
        Class[] alreadyLoaded = instrumentation.getInitiatedClasses(this.getClass().getClassLoader());
        this.findOtherBaseSubclasses(alreadyLoaded);
        this.modifyFinalSubclasses(alreadyLoaded);
    }

    private void findOtherBaseSubclasses(Class<?>[] alreadyLoaded) {
        for (Class<?> aClass : alreadyLoaded) {
            if (this.isFinalClass(aClass) || !this.isExpectationsOrVerificationsSubclassFromUserCode(aClass)) continue;
            String classInternalName = aClass.getName().replace('.', '/');
            this.baseSubclasses.add(classInternalName);
        }
    }

    private boolean isFinalClass(Class<?> aClass) {
        return Modifier.isFinal(aClass.getModifiers()) || Utilities.isAnonymousClass(aClass);
    }

    private boolean isExpectationsOrVerificationsSubclassFromUserCode(Class<?> aClass) {
        return aClass != Expectations.class && aClass != NonStrictExpectations.class && Expectations.class.isAssignableFrom(aClass) || aClass != Verifications.class && aClass != FullVerifications.class && aClass != VerificationsInOrder.class && aClass != FullVerificationsInOrder.class && Verifications.class.isAssignableFrom(aClass);
    }

    private void modifyFinalSubclasses(Class<?>[] alreadyLoaded) {
        for (Class<?> aClass : alreadyLoaded) {
            if (!this.isFinalClass(aClass) || !this.isExpectationsOrVerificationsSubclassFromUserCode(aClass)) continue;
            ClassReader cr = ClassFile.createClassFileReader(aClass.getName());
            EndOfBlockModifier modifier = new EndOfBlockModifier(cr, true);
            try {
                cr.accept(modifier, false);
            }
            catch (VisitInterruptedException ignore) {
                continue;
            }
            byte[] modifiedClassfile = modifier.toByteArray();
            RedefinitionEngine.redefineMethods(new ClassDefinition(aClass, modifiedClassfile));
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        int p;
        if (classBeingRedefined == null && TestRun.isRunningTestCode(protectionDomain) && (p = className.lastIndexOf(36)) > 0) {
            boolean isAnonymousClass = Utilities.hasPositiveDigit(className, p);
            ClassReader cr = new ClassReader(classfileBuffer);
            EndOfBlockModifier modifier = new EndOfBlockModifier(cr, isAnonymousClass);
            cr.accept(modifier, false);
            return modifier.toByteArray();
        }
        return null;
    }

    private final class SuperClassAnalyser
    extends EmptyVisitor {
        private boolean classExtendsBaseSubclass;

        private SuperClassAnalyser() {
        }

        boolean classExtendsInvocationsClass(String classOfInterest) {
            if ("java/lang/Object".equals(classOfInterest)) {
                return false;
            }
            String className = classOfInterest.replace('/', '.');
            ClassReader cr = ClassFile.createClassFileReader(className);
            try {
                cr.accept(this, true);
            }
            catch (VisitInterruptedException ignore) {
                // empty catch block
            }
            return this.classExtendsBaseSubclass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classExtendsBaseSubclass = ExpectationsTransformer.this.baseSubclasses.contains(superName);
            if (!this.classExtendsBaseSubclass && !"java/lang/Object".equals(superName)) {
                this.classExtendsInvocationsClass(superName);
            }
            throw VisitInterruptedException.INSTANCE;
        }
    }

    private final class EndOfBlockModifier
    extends ClassWriter {
        final boolean isAnonymousClass;
        MethodVisitor mw;
        String classDesc;

        EndOfBlockModifier(ClassReader cr, boolean isAnonymousClass) {
            super(cr, true);
            this.isAnonymousClass = isAnonymousClass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            boolean superClassIsKnownInvocationsSubclass = ExpectationsTransformer.this.baseSubclasses.contains(superName);
            if (Modifier.isFinal(access) || this.isAnonymousClass) {
                if (superClassIsKnownInvocationsSubclass || ExpectationsTransformer.this.superClassAnalyser.classExtendsInvocationsClass(superName)) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    this.classDesc = name;
                    return;
                }
            } else if (superClassIsKnownInvocationsSubclass) {
                ExpectationsTransformer.this.baseSubclasses.add(name);
            }
            throw VisitInterruptedException.INSTANCE;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.mw = super.visitMethod(access, name, desc, signature, exceptions);
            if ("<init>".equals(name)) {
                return new InvocationBlockModifier((MethodWriter)this.mw, this.classDesc);
            }
            return this.mw;
        }
    }
}

