/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mockit.Tested;
import mockit.external.asm.ClassReader;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TestedClassModifier;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestedClassRedefinitions {
    private final List<Field> testedFields = new LinkedList<Field>();
    private final List<MockedType> mockedTypes = new ArrayList<MockedType>();

    public boolean redefineTestedClasses(Object objectWithTestedFields) {
        for (Field field : objectWithTestedFields.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Tested.class)) {
                this.testedFields.add(field);
                continue;
            }
            MockedType mockedType = new MockedType(field, true);
            if (!mockedType.isMockField()) continue;
            this.mockedTypes.add(mockedType);
        }
        for (Field testedField : this.testedFields) {
            this.redefineTestedClass(testedField.getType());
        }
        return !this.testedFields.isEmpty();
    }

    private void redefineTestedClass(Class<?> testedClass) {
        ClassReader cr = ClassFile.createClassFileReader(testedClass.getName());
        TestedClassModifier modifier = new TestedClassModifier(cr, this.mockedTypes);
        cr.accept(modifier, false);
        byte[] modifiedClass = modifier.toByteArray();
        ClassDefinition classDefinition = new ClassDefinition(testedClass, modifiedClass);
        RedefinitionEngine.redefineClasses(classDefinition);
    }

    public void assignNewInstancesToTestedFields(Object objectWithMockFields) {
        for (Field testedField : this.testedFields) {
            Class<?> testedClass;
            Constructor<?>[] publicConstructors;
            Object testedObject = Utilities.getFieldValue(testedField, objectWithMockFields);
            if (testedObject != null || (publicConstructors = (testedClass = testedField.getType()).getConstructors()).length != 1) continue;
            Object newTestedObject = this.instantiateWithPublicConstructor(objectWithMockFields, publicConstructors[0]);
            this.injectMocksIntoFieldsThatAreStillNull(objectWithMockFields, testedClass, newTestedObject);
            Utilities.setFieldValue(testedField, objectWithMockFields, newTestedObject);
        }
    }

    private Object instantiateWithPublicConstructor(Object objectWithMockFields, Constructor<?> constructor) {
        Object[] mockArguments = this.obtainInjectableMocks(objectWithMockFields, constructor.getGenericParameterTypes());
        return Utilities.invoke(constructor, mockArguments);
    }

    private Object[] obtainInjectableMocks(Object parentObject, Type[] parameterTypes) {
        int n = parameterTypes.length;
        Object[] parameterValues = new Object[n];
        for (int i = 0; i < n; ++i) {
            parameterValues[i] = this.getRequiredMockObject(parentObject, parameterTypes[i]);
        }
        return parameterValues;
    }

    private Object getRequiredMockObject(Object parentObject, Type declaredType) {
        MockedType mockedType = this.findInjectableMockedType(declaredType);
        if (mockedType == null) {
            throw new IllegalArgumentException("No injectable mock field of " + declaredType);
        }
        Object mock = Utilities.getFieldValue(mockedType.field, parentObject);
        if (mock == null) {
            throw new IllegalArgumentException("No injectable mock instance available of " + declaredType);
        }
        return mock;
    }

    private MockedType findInjectableMockedType(Type declaredType) {
        for (MockedType mockedType : this.mockedTypes) {
            if (!mockedType.injectable || mockedType.declaredType != declaredType) continue;
            return mockedType;
        }
        return null;
    }

    private void injectMocksIntoFieldsThatAreStillNull(Object objectWithMockFields, Class<?> testedClass, Object tested) {
        Class<?> superClass = testedClass.getSuperclass();
        if (superClass != null && superClass.getProtectionDomain() == testedClass.getProtectionDomain()) {
            this.injectMocksIntoFieldsThatAreStillNull(objectWithMockFields, superClass, tested);
        }
        for (Field field : testedClass.getDeclaredFields()) {
            if (Utilities.getFieldValue(field, tested) != null) continue;
            Object mock = this.getMockObjectIfAvailable(objectWithMockFields, field);
            Utilities.setFieldValue(field, tested, mock);
        }
    }

    private Object getMockObjectIfAvailable(Object parentObject, Field fieldToBeInjected) {
        MockedType mockedType = this.findInjectableMockedType(fieldToBeInjected);
        return mockedType == null ? null : Utilities.getFieldValue(mockedType.field, parentObject);
    }

    private MockedType findInjectableMockedType(Field fieldToBeInjected) {
        Type declaredType = fieldToBeInjected.getGenericType();
        String fieldName = fieldToBeInjected.getName();
        boolean multipleFieldsOfSameTypeFound = false;
        MockedType found = null;
        for (MockedType mockedType : this.mockedTypes) {
            if (!mockedType.injectable || mockedType.declaredType != declaredType) continue;
            if (found == null) {
                found = mockedType;
                continue;
            }
            multipleFieldsOfSameTypeFound = true;
            if (!fieldName.equals(mockedType.field.getName())) continue;
            return mockedType;
        }
        if (multipleFieldsOfSameTypeFound && !fieldName.equals(found.field.getName())) {
            return null;
        }
        return found;
    }
}

