/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassReader;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubclassGenerationModifier
extends BaseClassModifier {
    private static final int CLASS_ACCESS_MASK = 64511;
    private final MockingConfiguration mockingCfg;
    private final Class<?> abstractClass;
    private final String subclassName;
    private String superClassName;
    private String superClassOfSuperClass;
    private String[] initialSuperInterfaces;
    private final List<String> implementedMethods;

    SubclassGenerationModifier(MockingConfiguration mockingConfiguration, Class<?> abstractClass, ClassReader classReader, String subclassName) {
        super(classReader);
        this.mockingCfg = mockingConfiguration;
        this.abstractClass = abstractClass;
        this.subclassName = subclassName.replace('.', '/');
        this.implementedMethods = new ArrayList<String>();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access & 0xFBFF, this.subclassName, signature, name, null);
        this.superClassName = name;
        this.superClassOfSuperClass = superName;
        this.initialSuperInterfaces = interfaces;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitSource(String file, String debug) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!"<init>".equals(name)) {
            this.generateImplementationIfAbstractMethod(this.superClassName, access, name, desc, signature, exceptions);
        }
        return null;
    }

    private void generateImplementationIfAbstractMethod(String className, int access, String name, String desc, String signature, String[] exceptions) {
        String methodNameAndDesc = name + desc;
        if (!this.implementedMethods.contains(methodNameAndDesc)) {
            if (Modifier.isAbstract(access)) {
                this.generateMethodImplementation(className, access, name, desc, signature, exceptions);
            }
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    private void generateMethodImplementation(String className, int access, String name, String desc, String signature, String[] exceptions) {
        boolean noFiltersToMatch;
        this.mw = super.visitMethod(1, name, desc, signature, exceptions);
        boolean bl = noFiltersToMatch = this.mockingCfg == null;
        if (noFiltersToMatch && !this.isMethodFromObject(name, desc) || !noFiltersToMatch && this.mockingCfg.matchesFilters(name, desc)) {
            this.generateDirectCallToHandler(className, access, name, desc, 0);
            this.generateReturnWithObjectAtTopOfTheStack(desc);
            this.mw.visitMaxs(1, 0);
        } else {
            this.generateEmptyImplementation(desc);
        }
    }

    @Override
    public void visitEnd() {
        this.generateImplementationsForInheritedAbstractMethods(this.superClassOfSuperClass);
        for (String superInterface : this.initialSuperInterfaces) {
            this.generateImplementationsForInterfaceMethods(superInterface);
        }
    }

    private void generateImplementationsForInheritedAbstractMethods(String superName) {
        if (!"java/lang/Object".equals(superName)) {
            new MethodModifierForSuperclass(superName);
        }
    }

    private void generateImplementationsForInterfaceMethods(String superName) {
        if (!"java/lang/Object".equals(superName)) {
            new MethodModifierForImplementedInterface(superName);
        }
    }

    private final class MethodModifierForImplementedInterface
    extends BaseMethodModifier {
        String[] superInterfaces;

        MethodModifierForImplementedInterface(String interfaceName) {
            super(interfaceName);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superInterfaces = interfaces;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.generateImplementationForInterfaceMethodIfMissing(access, name, desc, signature, exceptions);
            return null;
        }

        private void generateImplementationForInterfaceMethodIfMissing(int access, String name, String desc, String signature, String[] exceptions) {
            String methodNameAndDesc = name + desc;
            if (!SubclassGenerationModifier.this.implementedMethods.contains(methodNameAndDesc)) {
                if (!this.hasMethodImplementation(name, desc)) {
                    SubclassGenerationModifier.this.generateMethodImplementation(this.typeName, access, name, desc, signature, exceptions);
                }
                SubclassGenerationModifier.this.implementedMethods.add(methodNameAndDesc);
            }
        }

        private boolean hasMethodImplementation(String name, String desc) {
            Class<?>[] paramTypes = Utilities.getParameterTypes(desc);
            try {
                Method method = SubclassGenerationModifier.this.abstractClass.getMethod(name, paramTypes);
                return !method.getDeclaringClass().isInterface();
            }
            catch (NoSuchMethodException ignore) {
                return false;
            }
        }

        public void visitEnd() {
            for (String superName : this.superInterfaces) {
                SubclassGenerationModifier.this.generateImplementationsForInterfaceMethods(superName);
            }
        }
    }

    private final class MethodModifierForSuperclass
    extends BaseMethodModifier {
        String superName;

        MethodModifierForSuperclass(String className) {
            super(className);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superName = superName;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            SubclassGenerationModifier.this.generateImplementationIfAbstractMethod(this.typeName, access, name, desc, signature, exceptions);
            return null;
        }

        public void visitEnd() {
            SubclassGenerationModifier.this.generateImplementationsForInheritedAbstractMethods(this.superName);
        }
    }

    private class BaseMethodModifier
    extends EmptyVisitor {
        final String typeName;

        BaseMethodModifier(String typeName) {
            this.typeName = typeName;
            ClassFile.visitClass(typeName, this);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }
    }
}

