/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TestedClassRedefinitions;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class SharedFieldTypeRedefinitions
extends FieldTypeRedefinitions {
    private TestedClassRedefinitions testedClassRedefinitions;
    private final Map<MockedType, InstanceFactory> mockInstanceFactories = new HashMap<MockedType, InstanceFactory>();
    private final List<MockedType> finalMockFields = new ArrayList<MockedType>();

    public SharedFieldTypeRedefinitions(Object objectWithMockFields) {
        super(objectWithMockFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redefineTypesForTestClass() {
        TestRun.enterNoMockingZone();
        try {
            this.testedClassRedefinitions = new TestedClassRedefinitions();
            this.testedClassRedefinitions.redefineTestedClasses(this.parentObject);
            Class<?> testClass = this.parentObject.getClass();
            this.targetClasses.clear();
            this.redefineFieldTypes(testClass, true);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    protected void redefineTypeForMockField() {
        TypeRedefinition typeRedefinition = new TypeRedefinition(this.parentObject, this.typeMetadata);
        if (this.finalField) {
            typeRedefinition.redefineTypeForFinalField();
            this.finalMockFields.add(this.typeMetadata);
        } else {
            typeRedefinition.redefineType();
            InstanceFactory factory = typeRedefinition.instanceFactory;
            if (factory != null) {
                this.mockInstanceFactories.put(this.typeMetadata, factory);
            } else {
                this.finalMockFields.add(this.typeMetadata);
            }
        }
        this.targetClasses.add(typeRedefinition.targetClass);
    }

    public void assignNewInstancesToMockFields(Object target) {
        TestRun.getExecutingTest().clearInjectableAndNonStrictMocks();
        for (Map.Entry<MockedType, InstanceFactory> metadataAndFactory : this.mockInstanceFactories.entrySet()) {
            this.typeMetadata = metadataAndFactory.getKey();
            InstanceFactory instanceFactory = metadataAndFactory.getValue();
            Object mock = this.assignNewInstanceToMockField(target, instanceFactory);
            this.registerMock(mock);
        }
        this.obtainAndRegisterInstancesOfFinalFields(target);
    }

    private void obtainAndRegisterInstancesOfFinalFields(Object target) {
        for (MockedType metadata : this.finalMockFields) {
            Object mock = Utilities.getFieldValue(metadata.field, target);
            this.typeMetadata = metadata;
            if (mock == null) {
                this.registerMockedClassIfNonStrict();
                continue;
            }
            this.registerMock(mock);
        }
    }

    private Object assignNewInstanceToMockField(Object target, InstanceFactory instanceFactory) {
        Field mockField = this.typeMetadata.field;
        Object mock = Utilities.getFieldValue(mockField, target);
        if (mock == null) {
            try {
                mock = instanceFactory.create();
            }
            catch (ExceptionInInitializerError e) {
                Utilities.filterStackTrace(e);
                Utilities.filterStackTrace(e.getCause());
                e.printStackTrace();
                throw e;
            }
            Utilities.setFieldValue(mockField, target, mock);
            if (this.typeMetadata.getMaxInstancesToCapture() > 0) {
                this.getCaptureOfNewInstances().resetCaptureCount(mockField);
            }
        }
        return mock;
    }

    public boolean captureNewInstanceForApplicableMockField(Object mock) {
        if (this.captureOfNewInstances == null) {
            return false;
        }
        Object fieldOwner = TestRun.getCurrentTestInstance();
        return this.getCaptureOfNewInstances().captureNewInstanceForApplicableMockField(fieldOwner, mock);
    }

    public TestedClassRedefinitions getTestedClassRedefinitions() {
        return this.testedClassRedefinitions;
    }
}

