/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import mockit.internal.expectations.mocking.CaptureOfNewInstancesForParameters;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.state.TestRun;

public final class ParameterTypeRedefinitions
extends TypeRedefinitions {
    private final Type[] paramTypes;
    private final Annotation[][] paramAnnotations;
    private final Object[] paramValues;
    private final MockedType[] mockParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterTypeRedefinitions(Object owner, Method testMethod) {
        super(owner);
        TestRun.enterNoMockingZone();
        try {
            this.paramTypes = testMethod.getGenericParameterTypes();
            this.paramAnnotations = testMethod.getParameterAnnotations();
            int n = this.paramTypes.length;
            this.paramValues = new Object[n];
            this.mockParameters = new MockedType[n];
            for (int i = 0; i < n; ++i) {
                this.getMockedTypeFromMockParameterDeclaration(i);
            }
            this.redefineAndInstantiateMockedTypes();
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private void getMockedTypeFromMockParameterDeclaration(int paramIndex) {
        Type paramType = this.paramTypes[paramIndex];
        Annotation[] annotationsOnParameter = this.paramAnnotations[paramIndex];
        this.typeMetadata = new MockedType(paramIndex, paramType, annotationsOnParameter);
        if (this.typeMetadata.isMockParameter()) {
            this.mockParameters[paramIndex] = this.typeMetadata;
        }
    }

    private void redefineAndInstantiateMockedTypes() {
        for (int i = 0; i < this.mockParameters.length; ++i) {
            this.typeMetadata = this.mockParameters[i];
            if (this.typeMetadata == null) continue;
            this.paramValues[i] = this.redefineAndInstantiateMockedType();
        }
    }

    private Object redefineAndInstantiateMockedType() {
        TypeRedefinition typeRedefinition = new TypeRedefinition(this.parentObject, this.typeMetadata);
        Object mock = typeRedefinition.redefineType();
        this.registerMock(mock);
        if (this.typeMetadata.getMaxInstancesToCapture() > 0) {
            this.registerCaptureOfNewInstances(mock);
        }
        this.targetClasses.add(typeRedefinition.targetClass);
        ++this.typesRedefined;
        return mock;
    }

    private void registerCaptureOfNewInstances(Object originalInstance) {
        CaptureOfNewInstancesForParameters capture = this.getCaptureOfNewInstances();
        if (capture == null) {
            capture = new CaptureOfNewInstancesForParameters();
            this.captureOfNewInstances = capture;
        }
        capture.registerCaptureOfNewInstances(this.typeMetadata, originalInstance);
        capture.makeSureAllSubtypesAreModified(this.typeMetadata);
    }

    public CaptureOfNewInstancesForParameters getCaptureOfNewInstances() {
        return (CaptureOfNewInstancesForParameters)this.captureOfNewInstances;
    }

    public Object[] getParameterValues() {
        return this.paramValues;
    }
}

