/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Constructor;
import sun.reflect.ReflectionFactory;

public interface InstanceFactory {
    public Object create();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumInstanceFactory
    implements InstanceFactory {
        private final Object anEnumValue;

        EnumInstanceFactory(Class<?> enumClass) {
            this.anEnumValue = enumClass.getEnumConstants()[0];
        }

        @Override
        public Object create() {
            return this.anEnumValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClassInstanceFactory
    implements InstanceFactory {
        private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
        private static final Constructor<?> OBJECT_CONSTRUCTOR;
        private final Constructor<?> fakeConstructor;

        ClassInstanceFactory(Class<?> concreteClass) {
            this.fakeConstructor = REFLECTION_FACTORY.newConstructorForSerialization(concreteClass, OBJECT_CONSTRUCTOR);
        }

        @Override
        public Object create() {
            try {
                return this.fakeConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                OBJECT_CONSTRUCTOR = Object.class.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class InterfaceInstanceFactory
    implements InstanceFactory {
        private final Object emptyProxy;

        InterfaceInstanceFactory(Object emptyProxy) {
            this.emptyProxy = emptyProxy;
        }

        public Object create() {
            return this.emptyProxy;
        }
    }
}

