/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.util.SuperConstructorCollector;

final class ExpectationsModifier
extends BaseClassModifier {
    private static final int METHOD_ACCESS_MASK = 5120;
    private static final Type VOID_TYPE = Type.getType("Ljava/lang/Void;");
    private static final Map<String, String> DEFAULT_FILTERS = new HashMap<String, String>(){
        {
            this.put("java/lang/Object", "<init> getClass hashCode");
            this.put("java/lang/System", "arraycopy getProperties getSecurityManager");
            this.put("java/util/Hashtable", "get");
            this.put("java/lang/Throwable", "<init> fillInStackTrace");
            this.put("java/lang/Exception", "<init>");
        }
    };
    private final MockingConfiguration mockingCfg;
    private String superClassName;
    private String className;
    private String baseClassNameForCapturedInstanceMethods;
    private boolean stubOutClassInitialization;
    private boolean ignoreConstructors;
    private int executionMode;
    private boolean isProxy;
    private String defaultFilters;

    ExpectationsModifier(ClassLoader classLoader, ClassReader classReader, MockedType typeMetadata) {
        super(classReader);
        if (typeMetadata == null) {
            this.mockingCfg = null;
        } else {
            this.mockingCfg = typeMetadata.mockingCfg;
            this.stubOutClassInitialization = typeMetadata.isClassInitializationToBeStubbedOut();
        }
        this.setUseMockingBridge(classLoader);
    }

    public void setClassNameForCapturedInstanceMethods(String internalClassName) {
        this.baseClassNameForCapturedInstanceMethods = internalClassName;
    }

    public void useDynamicMocking(boolean methodsOnly) {
        this.ignoreConstructors = methodsOnly;
        this.executionMode = 1;
    }

    public void useDynamicMockingForInstanceMethods(MockedType typeMetadata) {
        this.ignoreConstructors = typeMetadata == null || typeMetadata.getMaxInstancesToCapture() <= 0;
        this.executionMode = 2;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
        this.isProxy = "java/lang/reflect/Proxy".equals(superName);
        if (this.isProxy) {
            this.className = interfaces[0];
            this.defaultFilters = null;
        } else {
            this.className = name;
            this.defaultFilters = DEFAULT_FILTERS.get(name);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean matchesFilters;
        boolean syntheticOrAbstractMethod;
        boolean bl = syntheticOrAbstractMethod = (access & 0x1400) != 0;
        if (syntheticOrAbstractMethod || this.isProxy && this.isConstructorOrSystemMethodNotToBeMocked(name, desc)) {
            return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
        }
        boolean noFiltersToMatch = this.mockingCfg == null;
        boolean bl2 = matchesFilters = noFiltersToMatch || this.mockingCfg.matchesFilters(name, desc);
        if ("<clinit>".equals(name)) {
            return this.stubOutClassInitializationIfApplicable(access, noFiltersToMatch, matchesFilters);
        }
        if (this.stubOutFinalizeMethod(access, name, desc)) {
            return null;
        }
        if (!matchesFilters || this.isMethodFromCapturedClassNotToBeMocked(access) || noFiltersToMatch && this.isMethodOrConstructorNotToBeMocked(access, name)) {
            return this.unmodifiedBytecode(access, name, desc, signature, exceptions);
        }
        this.validateModificationOfNativeMethod(access, name);
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        boolean visitingConstructor = "<init>".equals(name);
        if (visitingConstructor && this.superClassName != null) {
            this.generateCallToSuperConstructor();
        }
        String internalClassName = this.className;
        if (this.baseClassNameForCapturedInstanceMethods != null && !visitingConstructor) {
            internalClassName = this.baseClassNameForCapturedInstanceMethods;
        }
        int actualExecutionMode = this.determineAppropriateExecutionMode(access, visitingConstructor);
        if (this.useMockingBridge) {
            return this.generateCallToHandlerThroughMockingBridge(access, name, desc, internalClassName, actualExecutionMode);
        }
        this.generateDirectCallToHandler(internalClassName, access, name, desc, actualExecutionMode);
        if (actualExecutionMode > 0) {
            this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
            return this.copyOriginalImplementationCode(access, desc, visitingConstructor);
        }
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitMaxs(1, 0);
        return null;
    }

    private MethodVisitor unmodifiedBytecode(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private boolean isConstructorOrSystemMethodNotToBeMocked(String name, String desc) {
        return "<init>".equals(name) || this.isMethodFromObject(name, desc) || "annotationType".equals(name) && "()Ljava/lang/Class;".equals(desc);
    }

    private MethodVisitor stubOutClassInitializationIfApplicable(int access, boolean noFilters, boolean matchesFilters) {
        this.mw = super.visitMethod(access, "<clinit>", "()V", null, null);
        if (!noFilters && matchesFilters || noFilters && this.stubOutClassInitialization) {
            this.generateEmptyImplementation();
            return null;
        }
        return this.mw;
    }

    private boolean stubOutFinalizeMethod(int access, String name, String desc) {
        if ("finalize".equals(name) && "()V".equals(desc)) {
            this.mw = super.visitMethod(access, name, desc, null, null);
            this.generateEmptyImplementation();
            return true;
        }
        return false;
    }

    private boolean isMethodFromCapturedClassNotToBeMocked(int access) {
        return this.baseClassNameForCapturedInstanceMethods != null && (Modifier.isStatic(access) || Modifier.isPrivate(access));
    }

    private boolean isMethodOrConstructorNotToBeMocked(int access, String name) {
        return this.isConstructorToBeIgnored(name) || this.isStaticMethodToBeIgnored(access) || this.isNativeMethodForDynamicMocking(access) || this.defaultFilters != null && this.defaultFilters.contains(name);
    }

    private boolean isConstructorToBeIgnored(String name) {
        return this.ignoreConstructors && "<init>".equals(name);
    }

    private boolean isStaticMethodToBeIgnored(int access) {
        return this.executionMode == 2 && Modifier.isStatic(access);
    }

    private boolean isNativeMethodForDynamicMocking(int access) {
        return this.executionMode > 0 && Modifier.isNative(access);
    }

    private void validateModificationOfNativeMethod(int access, String name) {
        if (Modifier.isNative(access) && !Startup.isJava6OrLater()) {
            throw new IllegalArgumentException("Mocking of native methods not supported under JDK 1.5; please filter out method \"" + name + "\", or run under JDK 1.6+");
        }
    }

    private void generateCallToSuperConstructor() {
        String constructorDesc;
        this.mw.visitVarInsn(25, 0);
        if ("java/lang/Object".equals(this.superClassName)) {
            constructorDesc = "()V";
        } else {
            constructorDesc = SuperConstructorCollector.INSTANCE.findConstructor(this.superClassName);
            this.pushDefaultValuesForParameterTypes(constructorDesc);
        }
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", constructorDesc);
    }

    private int determineAppropriateExecutionMode(int access, boolean visitingConstructor) {
        if (this.executionMode == 2) {
            if (visitingConstructor) {
                return this.ignoreConstructors ? 0 : 1;
            }
            if (Modifier.isStatic(access)) {
                return 0;
            }
        }
        return this.executionMode;
    }

    private MethodVisitor generateCallToHandlerThroughMockingBridge(int access, String name, String desc, String internalClassName, int executionMode) {
        this.generateCallToMockingBridge(1, internalClassName, access, name, desc, executionMode);
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
        return this.copyOriginalImplementationCode(access, desc, false);
    }

    private void generateDecisionBetweenReturningOrContinuingToRealImplementation(String desc) {
        this.mw.visitInsn(89);
        this.mw.visitLdcInsn(VOID_TYPE);
        Label startOfRealImplementation = new Label();
        this.mw.visitJumpInsn(165, startOfRealImplementation);
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitLabel(startOfRealImplementation);
        this.mw.visitInsn(87);
    }

    private MethodVisitor copyOriginalImplementationCode(int access, String desc, boolean specialTreatmentForConstructor) {
        if (Modifier.isNative(access)) {
            this.generateEmptyImplementation(desc);
            return null;
        }
        return specialTreatmentForConstructor ? new DynamicConstructorModifier() : new DynamicModifier();
    }

    private final class DynamicConstructorModifier
    extends DynamicModifier {
        private DynamicConstructorModifier() {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && (owner.equals(ExpectationsModifier.this.superClassName) || owner.equals(ExpectationsModifier.this.className))) {
                return;
            }
            ExpectationsModifier.this.mw.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private class DynamicModifier
    extends MethodAdapter {
        DynamicModifier() {
            super(ExpectationsModifier.this.mw);
        }

        public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int idx) {
            if (end.position > 0 && start.position > end.position) {
                start.position = end.position;
            }
            if (start.position > 0 && end.position > 0) {
                super.visitLocalVariable(name, desc, signature, start, end, idx);
            }
        }
    }
}

