/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicPartialMocking {
    private final List<Class<?>> targetClasses = new ArrayList(2);
    private final Map<Class<?>, byte[]> modifiedClassfiles = new HashMap();

    public List<Class<?>> getTargetClasses() {
        return this.targetClasses;
    }

    public void redefineTypes(Object[] classesOrInstancesToBePartiallyMocked) {
        for (Object classOrInstance : classesOrInstancesToBePartiallyMocked) {
            this.redefineTargetType(classOrInstance);
        }
        new RedefinitionEngine().redefineMethods(this.modifiedClassfiles);
        this.modifiedClassfiles.clear();
    }

    private void redefineTargetType(Object classOrInstance) {
        Class<?> targetClass;
        if (classOrInstance instanceof Class) {
            targetClass = (Class<?>)classOrInstance;
            this.validateTargetClassType(targetClass);
            this.redefineClass(targetClass, false);
        } else {
            targetClass = classOrInstance.getClass();
            this.validateTargetClassType(targetClass);
            this.redefineClassAndItsSuperClasses(targetClass);
        }
        this.targetClasses.add(targetClass);
    }

    private void validateTargetClassType(Class<?> targetClass) {
        if (targetClass.isInterface() || targetClass.isAnnotation() || targetClass.isArray() || targetClass.isPrimitive() || Utilities.isWrapperOfPrimitiveType(targetClass) || Utilities.isGeneratedImplementationClass(targetClass)) {
            throw new IllegalArgumentException("Invalid type for dynamic mocking: " + targetClass);
        }
    }

    private void redefineClassAndItsSuperClasses(Class<?> realClass) {
        this.redefineClass(realClass, true);
        Class<?> superClass = realClass.getSuperclass();
        if (superClass != Object.class && superClass != Proxy.class) {
            this.redefineClassAndItsSuperClasses(superClass);
        }
    }

    private void redefineClass(Class<?> realClass, boolean methodsOnly) {
        ClassReader classReader = new ClassFile(realClass, false).getReader();
        ExpectationsModifier modifier = new ExpectationsModifier(realClass.getClassLoader(), classReader, null);
        modifier.useDynamicMocking(methodsOnly);
        classReader.accept(modifier, false);
        byte[] modifiedClass = modifier.toByteArray();
        this.modifiedClassfiles.put(realClass, modifiedClass);
    }
}

