/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CaptureOfNewInstances
extends CaptureOfImplementations {
    final Map<Class<?>, List<Capture>> baseTypeToCaptures = new HashMap();
    private MockedType typeMetadata;
    Capture captureFound;

    CaptureOfNewInstances() {
    }

    @Override
    public final ClassWriter createModifier(ClassLoader cl, ClassReader cr, String baseTypeDesc) {
        ExpectationsModifier modifier = new ExpectationsModifier(cl, cr, this.typeMetadata);
        modifier.setClassNameForCapturedInstanceMethods(baseTypeDesc);
        if (this.typeMetadata.injectable) {
            modifier.useDynamicMockingForInstanceMethods(this.typeMetadata);
        }
        return modifier;
    }

    final void registerCaptureOfNewInstances(MockedType typeMetadata, Object mockInstance) {
        List<Capture> captures;
        this.typeMetadata = typeMetadata;
        Class<?> baseType = typeMetadata.getClassType();
        if (!typeMetadata.isFinalFieldOrParameter()) {
            this.makeSureAllSubtypesAreModified(typeMetadata);
        }
        if ((captures = this.baseTypeToCaptures.get(baseType)) == null) {
            captures = new ArrayList<Capture>();
            this.baseTypeToCaptures.put(baseType, captures);
        }
        captures.add(new Capture(typeMetadata, mockInstance));
    }

    final boolean captureNewInstance(Object fieldOwner, Object mock) {
        boolean constructorModifiedForCaptureOnly;
        this.captureFound = null;
        Class<?> mockedClass = mock.getClass();
        List<Capture> captures = this.baseTypeToCaptures.get(mockedClass);
        boolean bl = constructorModifiedForCaptureOnly = captures == null;
        if (constructorModifiedForCaptureOnly && (captures = this.findCaptures(mockedClass)) == null) {
            return false;
        }
        for (Capture capture : captures) {
            if (capture.isInstanceAlreadyCaptured(mock)) break;
            if (!capture.captureInstance(fieldOwner, mock)) continue;
            this.captureFound = capture;
            break;
        }
        if (this.typeMetadata.injectable) {
            if (this.captureFound != null) {
                TestRun.getExecutingTest().addCapturedInstanceForInjectableMock(this.captureFound.originalMockInstance, mock);
            }
            constructorModifiedForCaptureOnly = true;
        } else if (this.captureFound != null) {
            TestRun.getExecutingTest().addCapturedInstance(this.captureFound.originalMockInstance, mock);
        }
        return constructorModifiedForCaptureOnly;
    }

    private List<Capture> findCaptures(Class<?> mockedClass) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = mockedClass.getInterfaces()) {
            List<Capture> found = this.baseTypeToCaptures.get(anInterface);
            if (found == null) continue;
            return found;
        }
        Class<?> superclass = mockedClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        List<Capture> found = this.baseTypeToCaptures.get(superclass);
        return found != null ? found : this.findCaptures(superclass);
    }

    @Override
    public final void cleanUp() {
        super.cleanUp();
        this.baseTypeToCaptures.clear();
    }

    static final class Capture {
        final MockedType typeMetadata;
        private Object originalMockInstance;
        private final List<Object> instancesCaptured;

        private Capture(MockedType typeMetadata, Object originalMockInstance) {
            this.typeMetadata = typeMetadata;
            this.originalMockInstance = originalMockInstance;
            this.instancesCaptured = new ArrayList<Object>(4);
        }

        private boolean isInstanceAlreadyCaptured(Object mock) {
            return this.instancesCaptured.contains(mock);
        }

        private boolean captureInstance(Object fieldOwner, Object instance) {
            if (this.instancesCaptured.size() < this.typeMetadata.getMaxInstancesToCapture()) {
                if (fieldOwner != null && this.originalMockInstance == null) {
                    this.originalMockInstance = Utilities.getFieldValue(this.typeMetadata.field, fieldOwner);
                }
                this.instancesCaptured.add(instance);
                return true;
            }
            return false;
        }

        void reset() {
            this.instancesCaptured.clear();
        }
    }
}

