/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.HashMap;
import java.util.Map;
import mockit.internal.expectations.mocking.CascadingTypeRedefinition;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class MockedTypeCascade {
    public final boolean mockFieldFromTestClass;
    private final Map<String, Class<?>> cascadedTypesAndMocks;

    public MockedTypeCascade(boolean mockFieldFromTestClass) {
        this.mockFieldFromTestClass = mockFieldFromTestClass;
        this.cascadedTypesAndMocks = new HashMap(4);
    }

    static Object getMock(String mockedTypeDesc, Object mockInstance, String returnTypeDesc) {
        String returnTypeInternalName = MockedTypeCascade.getReturnTypeIfCascadingSupportedForIt(returnTypeDesc);
        if (returnTypeInternalName == null) {
            return null;
        }
        MockedTypeCascade cascade = TestRun.getExecutingTest().getMockedTypeCascade(mockedTypeDesc, mockInstance);
        return cascade == null ? null : cascade.getCascadedMock(returnTypeInternalName);
    }

    private static String getReturnTypeIfCascadingSupportedForIt(String typeDesc) {
        String typeInternalName = typeDesc.substring(1, typeDesc.length() - 1);
        if (typeInternalName.startsWith("java/lang/") && !typeInternalName.contains("/Process")) {
            return null;
        }
        return typeInternalName;
    }

    private Object getCascadedMock(String returnTypeInternalName) {
        Object mock;
        Class<Object> returnType = this.cascadedTypesAndMocks.get(returnTypeInternalName);
        if (returnType == null) {
            String className = returnTypeInternalName.replace('/', '.');
            returnType = Utilities.loadClass(className);
            this.cascadedTypesAndMocks.put(returnTypeInternalName, returnType);
            TestRun.getExecutingTest().addCascadingType(returnTypeInternalName, false);
        }
        if ((mock = TestRun.mockFixture().getNewInstanceForMockedType(returnType)) == null) {
            mock = new CascadingTypeRedefinition(returnType).redefineType();
        }
        TestRun.getExecutingTest().addInjectableMock(mock);
        return mock;
    }
}

