/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import mockit.external.hamcrest.Matcher;
import mockit.external.hamcrest.core.IsAnything;
import mockit.external.hamcrest.core.IsEqual;
import mockit.internal.util.MethodFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationArguments {
    private static final Object[] NULL_VARARGS = new Object[0];
    final String classDesc;
    final String methodNameAndDesc;
    private final int methodAccess;
    private Object[] invocationArgs;
    private List<Matcher<?>> matchers;

    InvocationArguments(int access, String classDesc, String methodNameAndDesc, Object[] args) {
        this.methodAccess = access;
        this.classDesc = classDesc;
        this.methodNameAndDesc = methodNameAndDesc;
        this.invocationArgs = args;
    }

    public Object[] getValues() {
        return this.invocationArgs;
    }

    public void setValuesWithNoMatchers(Object[] argsToVerify) {
        this.invocationArgs = argsToVerify;
        this.matchers = null;
    }

    public List<Matcher<?>> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(List<Matcher<?>> matchers) {
        this.matchers = matchers;
    }

    public Object[] prepareForVerification(Object[] argsToVerify, List<Matcher<?>> matchers) {
        Object[] replayArgs = this.invocationArgs;
        this.invocationArgs = argsToVerify;
        this.matchers = matchers;
        return replayArgs;
    }

    public AssertionError assertMatch(Object[] replayArgs, Map<Object, Object> instanceMap) {
        if (this.matchers == null) {
            return this.assertEquality(replayArgs, instanceMap);
        }
        int argCount = replayArgs.length;
        Object[] replayVarArgs = replayArgs;
        Object[] invocationVarArgs = this.invocationArgs;
        int varArgsCount = 0;
        if ((this.methodAccess & 0x80) != 0) {
            invocationVarArgs = this.getVarArgs(this.invocationArgs);
            replayVarArgs = this.getVarArgs(replayArgs);
            if (invocationVarArgs != NULL_VARARGS && (varArgsCount = replayVarArgs.length) != invocationVarArgs.length) {
                return this.errorForVarargsArraysOfDifferentLengths(invocationVarArgs, replayVarArgs);
            }
            --argCount;
        }
        int n = argCount + varArgsCount;
        for (int i = 0; i < n; ++i) {
            Matcher<?> expected;
            Object actual = this.getArgument(replayArgs, replayVarArgs, argCount, i);
            Matcher<?> matcher = expected = i < this.matchers.size() ? this.matchers.get(i) : null;
            if (expected == null) {
                Object arg = this.getArgument(this.invocationArgs, invocationVarArgs, argCount, i);
                Matcher<Object> matcher2 = expected = arg == null ? new IsAnything() : new IsEqual<Object>(arg);
            }
            if (expected.matches(actual)) continue;
            return this.argumentMismatchMessage(i, expected, actual);
        }
        return null;
    }

    private Object getArgument(Object[] regularArgs, Object[] varArgs, int regularArgCount, int i) {
        return i < regularArgCount ? regularArgs[i] : varArgs[i - regularArgCount];
    }

    private AssertionError assertEquality(Object[] replayArgs, Map<Object, Object> instanceMap) {
        Object[] actualValues;
        int argCount = replayArgs.length;
        if ((this.methodAccess & 0x80) == 0) {
            return this.assertEquals(this.invocationArgs, replayArgs, argCount, instanceMap);
        }
        AssertionError nonVarargsError = this.assertEquals(this.invocationArgs, replayArgs, argCount - 1, instanceMap);
        if (nonVarargsError != null) {
            return nonVarargsError;
        }
        Object[] expectedValues = this.getVarArgs(this.invocationArgs);
        if (expectedValues.length != (actualValues = this.getVarArgs(replayArgs)).length) {
            return this.errorForVarargsArraysOfDifferentLengths(expectedValues, actualValues);
        }
        AssertionError varargsError = this.assertEquals(expectedValues, actualValues, expectedValues.length, instanceMap);
        if (varargsError != null) {
            return new AssertionError((Object)("Varargs " + varargsError));
        }
        return null;
    }

    private AssertionError errorForVarargsArraysOfDifferentLengths(Object[] expectedValues, Object[] actualValues) {
        return new AssertionError((Object)("Expected " + expectedValues.length + " values for varargs parameter, got " + actualValues.length));
    }

    private AssertionError assertEquals(Object[] expectedValues, Object[] actualValues, int count, Map<Object, Object> instanceMap) {
        for (int i = 0; i < count; ++i) {
            Object expected = expectedValues[i];
            Object actual = actualValues[i];
            if (!(actual == null && expected != null || actual != null && expected == null) && (actual == null || actual == expected || actual == instanceMap.get(expected) || IsEqual.areEqual(actual, expected))) continue;
            return this.argumentMismatchMessage(i, expected, actual);
        }
        return null;
    }

    private Object[] getVarArgs(Object[] args) {
        Object lastArg = args[args.length - 1];
        if (lastArg == null) {
            return NULL_VARARGS;
        }
        if (lastArg instanceof Object[]) {
            return (Object[])lastArg;
        }
        int varArgsLength = Array.getLength(lastArg);
        Object[] results = new Object[varArgsLength];
        for (int i = 0; i < varArgsLength; ++i) {
            results[i] = Array.get(lastArg, i);
        }
        return results;
    }

    private AssertionError argumentMismatchMessage(int paramIndex, Object expected, Object actual) {
        StringBuilder message = new StringBuilder(50);
        message.append("Parameter ").append(paramIndex);
        message.append(" of ").append(new MethodFormatter(this.classDesc, this.methodNameAndDesc));
        message.append(" expected ");
        this.appendParameterValue(message, expected);
        message.append(", got ");
        this.appendParameterValue(message, actual);
        return new AssertionError((Object)message.toString());
    }

    private void appendParameterValue(StringBuilder message, Object parameterValue) {
        if (parameterValue == null) {
            message.append("null");
        } else if (parameterValue instanceof CharSequence || parameterValue instanceof Appendable) {
            message.append('\"').append(parameterValue).append('\"');
        } else if (parameterValue instanceof Character) {
            message.append('\'').append(parameterValue).append('\'');
        } else {
            message.append(parameterValue);
        }
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(30);
        desc.append(":\n").append(new MethodFormatter(this.classDesc, this.methodNameAndDesc));
        if (this.invocationArgs.length > 0) {
            desc.append("\nwith arguments: ");
            String sep = "";
            for (Object arg : this.invocationArgs) {
                desc.append(sep);
                this.appendParameterValue(desc, arg);
                sep = ", ";
            }
        }
        return desc.toString();
    }
}

