/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.Map;
import mockit.external.asm.Type;
import mockit.internal.expectations.TestOnlyPhase;
import mockit.internal.expectations.invocation.ExpectationError;
import mockit.internal.expectations.invocation.InvocationArguments;
import mockit.internal.expectations.invocation.MockedTypeCascade;
import mockit.internal.state.TestRun;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpectedInvocation {
    private static final Object UNDEFINED_DEFAULT_RETURN = new Object();
    public final Object instance;
    public boolean matchInstance;
    public final InvocationArguments arguments;
    public CharSequence customErrorMessage;
    private final ExpectationError invocationCause;
    private Object defaultReturnValue;
    private Object cascadedMock;

    public ExpectedInvocation(Object mock, int access, String mockedClassDesc, String mockNameAndDesc, boolean matchInstance, Object[] args) {
        this.instance = mock;
        this.matchInstance = matchInstance;
        this.arguments = new InvocationArguments(access, mockedClassDesc, mockNameAndDesc, args);
        this.invocationCause = new ExpectationError();
        this.determineDefaultReturnValueFromMethodSignature();
    }

    private void determineDefaultReturnValueFromMethodSignature() {
        String nameAndDesc = this.getMethodNameAndDescription();
        this.defaultReturnValue = "equals(Ljava/lang/Object;)Z".equals(nameAndDesc) ? Boolean.valueOf(this.instance == this.getArgumentValues()[0]) : ("hashCode()I".equals(nameAndDesc) ? Integer.valueOf(System.identityHashCode(this.instance)) : ("toString()Ljava/lang/String;".equals(nameAndDesc) ? Utilities.objectIdentity(this.instance) : UNDEFINED_DEFAULT_RETURN));
    }

    public String getClassDesc() {
        return this.arguments.classDesc;
    }

    public String getClassName() {
        return this.getClassDesc().replace('/', '.');
    }

    public String getMethodNameAndDescription() {
        return this.arguments.methodNameAndDesc;
    }

    public Object[] getArgumentValues() {
        return this.arguments.getValues();
    }

    public boolean isMatch(String invokedClassDesc, String invokedMethod) {
        return invokedClassDesc.equals(this.getClassDesc()) && this.isMatchingMethod(invokedMethod);
    }

    public boolean isMatch(Object replayInstance, Map<Object, Object> instanceMap) {
        return this.getMethodNameAndDescription().charAt(0) == '<' || !this.matchInstance || this.isEquivalentInstance(replayInstance, instanceMap);
    }

    public boolean isMatch(Object replayInstance, String invokedClassDesc, String invokedMethod, Map<Object, Object> instanceMap) {
        return this.isMatch(invokedClassDesc, invokedMethod) && (this.getMethodNameAndDescription().charAt(0) == '<' || !this.matchInstance || this.isEquivalentInstance(replayInstance, instanceMap));
    }

    private boolean isMatchingMethod(String invokedMethod) {
        char c;
        String nameAndDesc = this.getMethodNameAndDescription();
        int i = 0;
        do {
            if ((c = nameAndDesc.charAt(i)) != invokedMethod.charAt(i)) {
                return false;
            }
            ++i;
        } while (c != ')');
        int n = invokedMethod.length();
        if (n == nameAndDesc.length()) {
            char c2;
            int j = i;
            while ((c2 = nameAndDesc.charAt(j)) == invokedMethod.charAt(j)) {
                if (++j != n) continue;
                return true;
            }
        }
        Type rt1 = Type.getType(nameAndDesc.substring(i));
        Type rt2 = Type.getType(invokedMethod.substring(i));
        return Utilities.getClassForType(rt2).isAssignableFrom(Utilities.getClassForType(rt1));
    }

    public boolean isEquivalentInstance(Object mockedInstance, Map<Object, Object> instanceMap) {
        return mockedInstance == this.instance || mockedInstance == instanceMap.get(this.instance) || TestRun.getExecutingTest().isInvokedInstanceEquivalentToCapturedInstance(this.instance, mockedInstance);
    }

    public ExpectedInvocation(Object mockedInstance, String classDesc, String methodNameAndDesc, Object[] args) {
        this.instance = mockedInstance;
        this.matchInstance = false;
        this.arguments = new InvocationArguments(0, classDesc, methodNameAndDesc, args);
        this.invocationCause = null;
    }

    public AssertionError errorForUnexpectedInvocation() {
        return this.newErrorWithCause("Unexpected invocation", "Unexpected invocation of");
    }

    private AssertionError newErrorWithCause(String title, String message) {
        String errorMessage = message + this.toString();
        if (this.customErrorMessage != null) {
            errorMessage = this.customErrorMessage + "\n" + errorMessage;
        }
        AssertionError error = new AssertionError((Object)errorMessage);
        if (this.invocationCause != null) {
            this.invocationCause.defineCause(title, error);
        }
        return error;
    }

    public AssertionError errorForMissingInvocation() {
        return this.newErrorWithCause("Missing invocation", "Missing invocation of");
    }

    public AssertionError errorForMissingInvocations(int totalMissing) {
        String plural = totalMissing == 1 ? "" : "s";
        return this.newErrorWithCause("Missing invocations", "Missing " + totalMissing + " invocation" + plural + " to");
    }

    public AssertionError errorForUnexpectedInvocation(Object mock, String invokedClassDesc, String invokedMethod) {
        String instanceDescription = mock == null ? "" : "\non instance: " + Utilities.objectIdentity(mock);
        return this.newErrorWithCause("Unexpected invocation", "Unexpected invocation of:\n" + new MethodFormatter(invokedClassDesc, invokedMethod) + instanceDescription + "\nwhen was expecting an invocation of");
    }

    public AssertionError errorForUnexpectedInvocations(int totalUnexpected) {
        String plural = totalUnexpected == 1 ? "" : "s";
        return this.newErrorWithCause("Unexpected invocations", totalUnexpected + " unexpected invocation" + plural + " to");
    }

    public String toString() {
        String desc = this.arguments.toString();
        if (this.instance != null) {
            desc = desc + "\non mock instance: " + Utilities.objectIdentity(this.instance);
        }
        return desc;
    }

    public Object getDefaultValueForReturnType(TestOnlyPhase phase) {
        if (this.defaultReturnValue == UNDEFINED_DEFAULT_RETURN) {
            String returnTypeDesc = DefaultValues.getReturnTypeDesc(this.getMethodNameAndDescription());
            this.defaultReturnValue = DefaultValues.computeForType(returnTypeDesc);
            if (this.defaultReturnValue == null && returnTypeDesc.charAt(0) == 'L') {
                this.produceCascadedMockIfApplicable(phase, returnTypeDesc);
            }
        }
        return this.defaultReturnValue;
    }

    private void produceCascadedMockIfApplicable(TestOnlyPhase phase, String returnTypeDesc) {
        String mockedTypeDesc = this.getClassDesc();
        this.cascadedMock = MockedTypeCascade.getMock(mockedTypeDesc, this.instance, returnTypeDesc);
        if (this.cascadedMock != null) {
            if (phase != null) {
                phase.setNextInstanceToMatch(this.cascadedMock);
            }
            this.defaultReturnValue = this.cascadedMock;
        }
    }

    public Object getCascadedMock() {
        return this.cascadedMock;
    }
}

