/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import mockit.Delegate;
import mockit.external.asm.Type;
import mockit.internal.expectations.RecordPhase;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.expectations.invocation.InvocationResults;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Expectation {
    final RecordPhase recordPhase;
    public final ExpectedInvocation invocation;
    public final InvocationConstraints constraints;
    private InvocationResults results;

    Expectation(RecordPhase recordPhase, ExpectedInvocation invocation, boolean nonStrict) {
        this.recordPhase = recordPhase;
        this.invocation = invocation;
        this.constraints = new InvocationConstraints(nonStrict);
    }

    Expectation(Expectation other) {
        this.recordPhase = other.recordPhase;
        this.invocation = other.invocation;
        this.constraints = new InvocationConstraints(other.constraints);
        this.results = other.results;
    }

    public InvocationResults getResults() {
        this.createResultsHolderIfNotYetCreated();
        return this.results;
    }

    private void createResultsHolderIfNotYetCreated() {
        if (this.results == null) {
            this.results = new InvocationResults(this.invocation, this.constraints);
        }
    }

    Object produceResult(Object invokedObject, Object[] invocationArgs) throws Throwable {
        if (this.results == null) {
            return this.invocation.getDefaultValueForReturnType(null);
        }
        return this.results.produceResult(invokedObject, invocationArgs);
    }

    AssertionError verifyConstraints(int minInvocations, int maxInvocations) {
        return this.constraints.verify(this.invocation, minInvocations, maxInvocations);
    }

    public void addReturnValueOrValues(Object value) {
        this.createResultsHolderIfNotYetCreated();
        boolean valueIsArray = value != null && value.getClass().isArray();
        boolean valueIsIterable = value instanceof Iterable;
        if ((valueIsArray || valueIsIterable || value instanceof Iterator) && this.hasReturnOfDifferentType(value)) {
            if (valueIsArray) {
                this.results.addReturnValues(value);
            } else if (valueIsIterable) {
                this.results.addReturnValues((Iterable)value);
            } else {
                this.results.addDeferredReturnValues((Iterator)value);
            }
            return;
        }
        this.addSingleReturnValue(value);
    }

    private void addSingleReturnValue(Object value) {
        this.validateReturnValues(value, new Object[]{null});
        this.substituteCascadedMockToBeReturnedIfNeeded(value);
        this.results.addReturnValue(value);
    }

    private boolean hasReturnOfDifferentType(Object valueToBeReturned) {
        Class<?> returnClass = this.getReturnType();
        return returnClass == null || !returnClass.isAssignableFrom(valueToBeReturned.getClass());
    }

    private Class<?> getReturnType() {
        Type invocationReturnType = Type.getReturnType(this.invocation.getMethodNameAndDescription());
        return Utilities.getClassForType(invocationReturnType);
    }

    private void validateReturnValues(Object firstValue, Object ... remainingValues) {
        if (this.hasVoidReturnType()) {
            this.validateReturnValueForConstructorOrVoidMethod(firstValue);
            if (remainingValues != null) {
                for (Object anotherValue : remainingValues) {
                    this.validateReturnValueForConstructorOrVoidMethod(anotherValue);
                }
            }
        }
    }

    private boolean hasVoidReturnType() {
        return this.invocation.getMethodNameAndDescription().endsWith(")V");
    }

    private void validateReturnValueForConstructorOrVoidMethod(Object value) {
        if (value != null && !(value instanceof Delegate)) {
            throw new IllegalArgumentException("Non-null return value specified for constructor or void method");
        }
    }

    private void substituteCascadedMockToBeReturnedIfNeeded(Object valueToBeReturned) {
        Object cascadedMock = this.invocation.getCascadedMock();
        if (valueToBeReturned != null && cascadedMock != null) {
            TestRun.getExecutingTest().discardCascadedMockWhenInjectable(cascadedMock);
            this.recordPhase.setNextInstanceToMatch(null);
        }
    }

    public void addSequenceOfReturnValues(Object firstValue, Object[] remainingValues) {
        this.validateReturnValues(firstValue, remainingValues);
        InvocationResults sequence = this.getResults();
        if (remainingValues == null) {
            sequence.addReturnValue(firstValue);
        } else if (!this.addReturnValueForSequenceOfValues(firstValue, remainingValues)) {
            sequence.addReturnValue(firstValue);
            sequence.addReturnValues(remainingValues);
        }
    }

    private boolean addReturnValueForSequenceOfValues(Object first, Object[] remaining) {
        Class rt = this.getReturnType();
        if (rt != null) {
            int n = 1 + remaining.length;
            if (rt.isArray()) {
                if (first == null || !first.getClass().isArray()) {
                    this.addArrayAsReturnValue(rt.getComponentType(), n, first, remaining);
                    return true;
                }
            } else {
                if (Iterator.class.isAssignableFrom(rt)) {
                    this.addIteratorAsReturnValue(first, remaining, n);
                    return true;
                }
                if (Iterable.class.isAssignableFrom(rt)) {
                    if (rt.isAssignableFrom(List.class)) {
                        this.addReturnValues(new ArrayList<Object>(n), first, remaining);
                        return true;
                    }
                    if (rt.isAssignableFrom(Set.class)) {
                        this.addReturnValues(new LinkedHashSet<Object>(n), first, remaining);
                        return true;
                    }
                    if (rt.isAssignableFrom(SortedSet.class)) {
                        this.addReturnValues(new TreeSet<Object>(), first, remaining);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void addArrayAsReturnValue(Class<?> elementType, int n, Object first, Object[] remaining) {
        Object values = Array.newInstance(elementType, n);
        this.setArrayElement(elementType, values, 0, first);
        for (int i = 1; i < n; ++i) {
            this.setArrayElement(elementType, values, i, remaining[i - 1]);
        }
        this.results.addReturnValue(values);
    }

    private void setArrayElement(Class<?> elementType, Object array, int index, Object value) {
        if (elementType == Byte.TYPE || elementType == Byte.class) {
            value = ((Number)value).byteValue();
        } else if (elementType == Short.TYPE || elementType == Short.class) {
            value = ((Number)value).shortValue();
        }
        Array.set(array, index, value);
    }

    private void addIteratorAsReturnValue(Object first, Object[] remaining, int n) {
        ArrayList<Object> values = new ArrayList<Object>(n);
        this.addAllValues(values, first, remaining);
        this.results.addReturnValue(values.iterator());
    }

    private void addAllValues(Collection<Object> values, Object first, Object[] remaining) {
        values.add(first);
        Collections.addAll(values, remaining);
    }

    private void addReturnValues(Collection<Object> values, Object first, Object[] remaining) {
        this.addAllValues(values, first, remaining);
        this.results.addReturnValue(values);
    }

    public void addResult(Object value) {
        this.createResultsHolderIfNotYetCreated();
        if (value instanceof Throwable) {
            this.results.addThrowable((Throwable)value);
            return;
        }
        boolean valueIsArray = value != null && value.getClass().isArray();
        boolean valueIsIterable = value instanceof Iterable;
        if ((valueIsArray || valueIsIterable || value instanceof Iterator) && this.hasReturnOfDifferentType(value)) {
            if (valueIsArray) {
                this.results.addResults(value);
            } else if (valueIsIterable) {
                this.results.addResults((Iterable)value);
            } else {
                this.results.addDeferredResults((Iterator)value);
            }
            return;
        }
        this.addSingleReturnValue(value);
    }

    public void setCustomErrorMessage(CharSequence message) {
        this.invocation.customErrorMessage = message;
    }
}

