/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.capturing.CaptureOfImplementations;
import mockit.internal.capturing.CapturedType;
import mockit.internal.state.TestRun;
import mockit.internal.util.VisitInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CaptureTransformer
implements ClassFileTransformer {
    private final CapturedType metadata;
    private final String capturedType;
    private final CaptureOfImplementations modifierFactory;
    private final SuperTypeCollector superTypeCollector;
    private final Map<String, byte[]> transformedClasses;
    private boolean inactive;

    CaptureTransformer(CapturedType metadata, CaptureOfImplementations modifierFactory, boolean forTestClass) {
        this.metadata = metadata;
        this.capturedType = metadata.baseType.getName().replace('.', '/');
        this.modifierFactory = modifierFactory;
        this.superTypeCollector = new SuperTypeCollector();
        this.transformedClasses = forTestClass ? new HashMap(2) : null;
    }

    void deactivate() {
        this.inactive = true;
        if (this.transformedClasses != null) {
            RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
            for (Map.Entry<String, byte[]> classNameAndOriginalBytecode : this.transformedClasses.entrySet()) {
                String className = classNameAndOriginalBytecode.getKey();
                byte[] originalBytecode = classNameAndOriginalBytecode.getValue();
                redefinitionEngine.restoreToDefinition(className, originalBytecode);
            }
            this.transformedClasses.clear();
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String internalClassName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] modifiedBytecode;
        block4: {
            if (this.inactive || classBeingRedefined != null || TestRun.getCurrentTestInstance() == null || internalClassName.startsWith("mockit/internal/")) {
                return null;
            }
            String className = internalClassName.replace('/', '.');
            if (!this.metadata.isToBeCaptured(className)) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            modifiedBytecode = null;
            try {
                cr.accept(this.superTypeCollector, true);
            }
            catch (VisitInterruptedException ignore) {
                if (!this.superTypeCollector.classExtendsCapturedType) break block4;
                modifiedBytecode = this.modifyAndRegisterClass(loader, className, cr);
            }
        }
        return modifiedBytecode;
    }

    private byte[] modifyAndRegisterClass(ClassLoader loader, String className, ClassReader cr) {
        ClassWriter modifier = this.modifierFactory.createModifier(loader, cr, this.capturedType);
        cr.accept(modifier, false);
        byte[] originalBytecode = cr.b;
        if (this.transformedClasses == null) {
            TestRun.mockFixture().addTransformedClass(className, originalBytecode);
        } else {
            this.transformedClasses.put(className, originalBytecode);
        }
        return modifier.toByteArray();
    }

    private final class SuperTypeCollector
    extends EmptyVisitor {
        boolean classExtendsCapturedType;

        private SuperTypeCollector() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classExtendsCapturedType = false;
            if (CaptureTransformer.this.capturedType.equals(superName)) {
                this.classExtendsCapturedType = true;
            } else {
                for (String itfc : interfaces) {
                    if (!CaptureTransformer.this.capturedType.equals(itfc)) continue;
                    this.classExtendsCapturedType = true;
                    break;
                }
            }
            if (!this.classExtendsCapturedType && !"java/lang/Object".equals(superName)) {
                String superClassName = superName.replace('/', '.');
                ClassReader cr = ClassFile.createClassFileReader(superClassName);
                cr.accept(CaptureTransformer.this.superTypeCollector, true);
            }
            throw VisitInterruptedException.INSTANCE;
        }
    }
}

