/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.lang.reflect.Proxy;
import mockit.internal.util.MethodFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MockState {
    private final Class<?> realClass;
    final String mockNameAndDesc;
    int expectedInvocations = -1;
    int minExpectedInvocations;
    int maxExpectedInvocations = -1;
    private int invocationCount;
    private ThreadLocal<Boolean> onReentrantCall;
    private final Object invocationCountLock = new Object();

    MockState(Class<?> realClass, String mockNameAndDesc) {
        this.realClass = realClass;
        this.mockNameAndDesc = mockNameAndDesc;
    }

    Class<?> getRealClass() {
        return this.realClass;
    }

    boolean isReentrant() {
        return this.onReentrantCall != null;
    }

    void makeReentrant() {
        this.onReentrantCall = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
    }

    boolean isWithExpectations() {
        return this.expectedInvocations >= 0 || this.minExpectedInvocations > 0 || this.maxExpectedInvocations >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        Object object = this.invocationCountLock;
        synchronized (object) {
            ++this.invocationCount;
        }
        if (this.onReentrantCall != null) {
            this.onReentrantCall.set(true);
        }
    }

    boolean isOnReentrantCall() {
        return this.onReentrantCall != null && this.onReentrantCall.get() != false;
    }

    void exitReentrantCall() {
        this.onReentrantCall.set(false);
    }

    void verifyExpectations() {
        int timesInvoked = this.getTimesInvoked();
        if (this.expectedInvocations >= 0 && timesInvoked != this.expectedInvocations) {
            throw new AssertionError((Object)this.errorMessage("exactly", this.expectedInvocations, timesInvoked));
        }
        if (timesInvoked < this.minExpectedInvocations) {
            throw new AssertionError((Object)this.errorMessage("at least", this.minExpectedInvocations, timesInvoked));
        }
        if (this.maxExpectedInvocations >= 0 && timesInvoked > this.maxExpectedInvocations) {
            throw new AssertionError((Object)this.errorMessage("at most", this.maxExpectedInvocations, timesInvoked));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTimesInvoked() {
        Object object = this.invocationCountLock;
        synchronized (object) {
            return this.invocationCount;
        }
    }

    private String errorMessage(String quantifier, int numExpectedInvocations, int timesInvoked) {
        String realClassName = this.getRealClassName();
        return "Expected " + quantifier + ' ' + numExpectedInvocations + " invocation(s) of " + new MethodFormatter(realClassName, this.mockNameAndDesc) + ", but was invoked " + timesInvoked + " time(s)";
    }

    private String getRealClassName() {
        Class<?>[] interfaces;
        if (this.realClass == null) {
            return null;
        }
        if (Proxy.isProxyClass(this.realClass) && (interfaces = this.realClass.getInterfaces()).length <= 2) {
            return interfaces[0].getName();
        }
        return this.realClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.invocationCountLock;
        synchronized (object) {
            this.invocationCount = 0;
        }
    }
}

