/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.annotations.AnnotatedMockMethods;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;
import mockit.internal.util.SuperConstructorCollector;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsModifier
extends BaseClassModifier {
    private static final int IGNORED_ACCESS = 1280;
    private static final String CLASS_WITH_STATE = "mockit/internal/state/TestRun";
    private final String itFieldDesc;
    private final int mockInstanceIndex;
    private final boolean forStartupMock;
    private final AnnotatedMockMethods annotatedMocks;
    private final MockingConfiguration mockingCfg;
    private final boolean useMockingBridgeForUpdatingMockState;
    private boolean mockIsReentrant;
    private Type mockClassType;
    private String realSuperClassName;
    private String mockName;
    private int varIndex;
    private boolean mockIsStatic;
    private String methodOrConstructorDesc;
    private int initialVar;

    public AnnotationsModifier(ClassReader cr, Class<?> realClass, Object mock, AnnotatedMockMethods mockMethods, MockingConfiguration mockingConfiguration, boolean forStartupMock) {
        super(cr);
        this.itFieldDesc = this.getItFieldDescriptor(realClass);
        this.annotatedMocks = mockMethods;
        this.mockingCfg = mockingConfiguration;
        this.forStartupMock = forStartupMock;
        this.mockInstanceIndex = this.getMockInstanceIndex(mock);
        this.setUseMockingBridge(realClass.getClassLoader());
        this.useMockingBridgeForUpdatingMockState = this.useMockingBridge;
        if (!this.useMockingBridge && mock != null && Utilities.isAnonymousClass(mock.getClass()) && realClass.getPackage() != mock.getClass().getPackage()) {
            this.useMockingBridge = true;
        }
    }

    private String getItFieldDescriptor(Class<?> realClass) {
        if (Proxy.isProxyClass(realClass)) {
            realClass = realClass.getInterfaces()[0];
        }
        return Type.getDescriptor(realClass);
    }

    private int getMockInstanceIndex(Object mock) {
        if (mock != null) {
            return TestRun.getMockClasses().getMocks(this.forStartupMock).addMock(mock);
        }
        if (!this.annotatedMocks.isInnerMockClass()) {
            return -1;
        }
        throw new IllegalArgumentException("An inner mock class cannot be instantiated without its enclosing instance; you must either pass a mock instance, or make the class static");
    }

    public void useOneMockInstancePerMockedInstance(Class<?> mockClass) {
        this.mockClassType = Type.getType(mockClass);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.realSuperClassName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!this.hasMock(name, desc)) {
            return this.shouldCopyOriginalMethodBytecode(access, name, desc, signature, exceptions) ? super.visitMethod(access, name, desc, signature, exceptions) : null;
        }
        if ((access & 0x100) != 0 && !Startup.isJava6OrLater()) {
            throw new IllegalArgumentException("Mocking of native methods not supported under JDK 1.5: \"" + name + '\"');
        }
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        MethodVisitor alternativeWriter = this.getAlternativeMethodWriter(access, desc);
        if (alternativeWriter == null) {
            this.generateCallsForMockExecution(access, desc);
            this.generateMethodReturn(desc);
            this.mw.visitMaxs(1, 0);
            return null;
        }
        return alternativeWriter;
    }

    private boolean hasMock(String name, String desc) {
        this.mockName = "<init>".equals(name) ? "$init" : ("<clinit>".equals(name) ? "$clinit" : name);
        boolean hasMock = this.annotatedMocks.containsMethod(this.mockName, desc);
        if (hasMock) {
            this.mockIsStatic = this.annotatedMocks.containsStaticMethod(this.mockName, desc);
        }
        return hasMock;
    }

    private boolean shouldCopyOriginalMethodBytecode(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x500) == 0 && this.mockingCfg != null && this.mockingCfg.matchesFilters(name, desc)) {
            this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
            this.generateEmptyStubImplementation(name, desc);
            return false;
        }
        return true;
    }

    private void generateEmptyStubImplementation(String name, String desc) {
        if ("<init>".equals(name)) {
            this.generateCallToSuper();
        }
        this.generateEmptyImplementation(desc);
    }

    private MethodVisitor getAlternativeMethodWriter(int access, String desc) {
        this.mockIsReentrant = this.annotatedMocks.isReentrant();
        if (!this.mockIsReentrant) {
            return null;
        }
        if (Modifier.isNative(access)) {
            throw new IllegalArgumentException("Reentrant mocks for native methods are not supported: \"" + this.mockName + '\"');
        }
        this.generateCallToMock(access, desc);
        return new MethodAdapter(this.mw);
    }

    private void generateCallsForMockExecution(int access, String desc) {
        if ("$init".equals(this.mockName)) {
            this.generateCallToSuper();
        }
        this.generateCallToMock(access, desc);
    }

    private void generateCallToSuper() {
        this.mw.visitVarInsn(25, 0);
        String constructorDesc = SuperConstructorCollector.INSTANCE.findConstructor(this.realSuperClassName);
        this.pushDefaultValuesForParameterTypes(constructorDesc);
        this.mw.visitMethodInsn(183, this.realSuperClassName, "<init>", constructorDesc);
    }

    private void generateMockObjectInstantiation() {
        this.mw.visitTypeInsn(187, this.annotatedMocks.getMockClassInternalName());
        this.mw.visitInsn(89);
    }

    private void generateCallToMock(int access, String desc) {
        Label afterCallToMock = this.generateCallToUpdateMockStateIfAny();
        Label l1 = null;
        Label l2 = null;
        Label l3 = null;
        if (afterCallToMock != null) {
            Label l0 = new Label();
            l1 = new Label();
            l2 = new Label();
            this.mw.visitTryCatchBlock(l0, l1, l2, null);
            l3 = new Label();
            this.mw.visitTryCatchBlock(l2, l3, l2, null);
            this.mw.visitLabel(l0);
        }
        this.generateCallToMockMethod(access, desc);
        if (afterCallToMock != null) {
            this.mw.visitLabel(l1);
            this.generateCallToExitReentrantMock();
            this.generateMethodReturn(desc);
            this.mw.visitLabel(l2);
            this.mw.visitVarInsn(58, this.varIndex);
            this.mw.visitLabel(l3);
            this.generateCallToExitReentrantMock();
            this.mw.visitVarInsn(25, this.varIndex);
            this.mw.visitInsn(191);
            this.mw.visitLabel(afterCallToMock);
        }
    }

    private Label generateCallToUpdateMockStateIfAny() {
        int mockStateIndex = this.annotatedMocks.getIndexForMockExpectations();
        Label afterCallToMock = null;
        if (mockStateIndex >= 0) {
            String mockClassDesc = this.annotatedMocks.getMockClassInternalName();
            if (this.useMockingBridgeForUpdatingMockState) {
                this.generateCallToMockingBridge(5, mockClassDesc, 8, null, null, mockStateIndex);
                this.mw.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            } else {
                this.mw.visitLdcInsn(mockClassDesc);
                this.mw.visitIntInsn(17, mockStateIndex);
                this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "updateMockState", "(Ljava/lang/String;I)Z");
            }
            if (this.mockIsReentrant) {
                afterCallToMock = new Label();
                this.mw.visitJumpInsn(153, afterCallToMock);
            }
        }
        return afterCallToMock;
    }

    private void generateCallToMockMethod(int access, String desc) {
        this.methodOrConstructorDesc = desc;
        if (this.mockIsStatic) {
            this.generateStaticMethodCall(access);
        } else {
            this.generateInstanceMethodCall(access);
        }
    }

    private void generateStaticMethodCall(int access) {
        String mockClassName = this.annotatedMocks.getMockClassInternalName();
        if (this.useMockingBridge) {
            this.generateCallToMockingBridge(3, mockClassName, access, this.mockName, this.methodOrConstructorDesc, null);
        } else {
            this.initialVar = this.initialLocalVariableIndexForRealMethod(access);
            String desc = this.generateInvocationArgumentIfNeeded();
            this.generateMethodOrConstructorArguments();
            this.mw.visitMethodInsn(184, mockClassName, this.mockName, desc);
        }
    }

    private void generateInstanceMethodCall(int access) {
        if (this.useMockingBridge) {
            this.generateCallToMockingBridge(4, this.annotatedMocks.getMockClassInternalName(), access, this.mockName, this.methodOrConstructorDesc, this.mockInstanceIndex);
            return;
        }
        if (this.mockInstanceIndex < 0) {
            this.obtainMockInstanceForInvocation(access);
        } else {
            this.generateGetMockCallWithMockInstanceIndex();
        }
        if ((access & 8) == 0 && this.annotatedMocks.isWithItField()) {
            this.generateItFieldSetting();
        }
        this.generateMockInstanceMethodInvocationWithRealMethodArgs(access);
    }

    private void obtainMockInstanceForInvocation(int access) {
        if (this.mockClassType == null || Modifier.isStatic(access)) {
            this.generateMockObjectInstantiation();
            this.mw.visitMethodInsn(183, this.annotatedMocks.getMockClassInternalName(), "<init>", "()V");
        } else {
            this.generateGetMockCallWithMockClassAndMockedInstance();
        }
    }

    private void generateGetMockCallWithMockClassAndMockedInstance() {
        this.mw.visitLdcInsn(this.mockClassType);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "getMock", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;");
        this.mw.visitTypeInsn(192, this.annotatedMocks.getMockClassInternalName());
    }

    private void generateGetMockCallWithMockInstanceIndex() {
        this.mw.visitIntInsn(17, this.mockInstanceIndex);
        String methodName = this.forStartupMock ? "getStartupMock" : "getMock";
        this.mw.visitMethodInsn(184, CLASS_WITH_STATE, methodName, "(I)Ljava/lang/Object;");
        this.mw.visitTypeInsn(192, this.annotatedMocks.getMockClassInternalName());
    }

    private void generateItFieldSetting() {
        Type[] argTypes = Type.getArgumentTypes(this.methodOrConstructorDesc);
        int var = 1;
        for (Type argType : argTypes) {
            var += argType.getSize();
        }
        this.mw.visitVarInsn(58, var);
        this.mw.visitVarInsn(25, var);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitFieldInsn(181, this.annotatedMocks.getMockClassInternalName(), "it", this.itFieldDesc);
        this.mw.visitVarInsn(25, var);
    }

    private void generateMockInstanceMethodInvocationWithRealMethodArgs(int access) {
        this.initialVar = this.initialLocalVariableIndexForRealMethod(access);
        String desc = this.generateInvocationArgumentIfNeeded();
        this.generateMethodOrConstructorArguments();
        this.mw.visitMethodInsn(182, this.annotatedMocks.getMockClassInternalName(), this.mockName, desc);
    }

    private int initialLocalVariableIndexForRealMethod(int access) {
        return (access & 8) == 0 ? 1 : 0;
    }

    private String generateInvocationArgumentIfNeeded() {
        if (this.annotatedMocks.isWithInvocationParameter()) {
            this.mw.visitInsn(1);
            return "(Lmockit/Invocation;" + this.methodOrConstructorDesc.substring(1);
        }
        return this.methodOrConstructorDesc;
    }

    private void generateMethodOrConstructorArguments() {
        Type[] argTypes = Type.getArgumentTypes(this.methodOrConstructorDesc);
        this.varIndex = this.initialVar;
        for (Type argType : argTypes) {
            int opcode = argType.getOpcode(21);
            this.mw.visitVarInsn(opcode, this.varIndex);
            this.varIndex += argType.getSize();
        }
    }

    private void generateMethodReturn(String desc) {
        if (this.useMockingBridge) {
            this.generateReturnWithObjectAtTopOfTheStack(desc);
        } else {
            Type returnType = Type.getReturnType(desc);
            this.mw.visitInsn(returnType.getOpcode(172));
        }
    }

    private void generateCallToExitReentrantMock() {
        String mockClassDesc = this.annotatedMocks.getMockClassInternalName();
        int mockStateIndex = this.annotatedMocks.getIndexForMockExpectations();
        if (this.useMockingBridgeForUpdatingMockState) {
            this.generateCallToMockingBridge(6, mockClassDesc, 8, null, null, mockStateIndex);
            this.mw.visitInsn(87);
        } else {
            this.mw.visitLdcInsn(mockClassDesc);
            this.mw.visitIntInsn(17, mockStateIndex);
            this.mw.visitMethodInsn(184, CLASS_WITH_STATE, "exitReentrantMock", "(Ljava/lang/String;I)V");
        }
    }
}

