/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mockit.internal.annotations.AnnotatedMockStates;
import mockit.internal.annotations.MockClassState;
import mockit.internal.annotations.MockState;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMockMethods {
    String mockClassInternalName;
    private boolean isInnerMockClass;
    private boolean withItField;
    private boolean withInvocationParameter;
    final List<String> methods = new ArrayList<String>(20);
    private final Collection<String> staticMethods = new ArrayList<String>(20);
    final Class<?> realClass;
    private MockClassState mockStates;
    private int indexForMockExpectations = -1;

    public AnnotatedMockMethods(Class<?> realClass) {
        this.realClass = realClass;
    }

    public String addMethod(boolean fromSuperClass, String name, String desc, boolean isStatic) {
        if (fromSuperClass && this.isMethodAlreadyAdded(name, desc)) {
            return null;
        }
        String nameAndDesc = name + desc;
        if (isStatic) {
            this.staticMethods.add(nameAndDesc);
        }
        this.methods.add(nameAndDesc);
        return nameAndDesc;
    }

    private boolean isMethodAlreadyAdded(String name, String desc) {
        int p = desc.lastIndexOf(41);
        String nameAndParams = name + desc.substring(0, p + 1);
        for (String method : this.methods) {
            if (!method.startsWith(nameAndParams)) continue;
            return true;
        }
        return false;
    }

    void addMockState(MockState mockState) {
        AnnotatedMockStates annotatedMockStates = TestRun.getMockClasses().getMockStates();
        if (this.mockStates == null) {
            this.mockStates = annotatedMockStates.addClassState(this.mockClassInternalName);
        }
        this.mockStates.addMockState(mockState);
        if (mockState.isWithExpectations()) {
            annotatedMockStates.registerMockStatesWithExpectations(mockState);
        }
    }

    public boolean containsMethod(String name, String desc) {
        boolean mockFound = this.hasMethod(name, desc);
        if (mockFound && this.mockStates != null) {
            this.indexForMockExpectations = this.mockStates.findMockState(name + desc);
        }
        return mockFound;
    }

    private boolean hasMethod(String name, String desc) {
        this.withInvocationParameter = false;
        int n = name.length();
        for (int i = 0; i < this.methods.size(); ++i) {
            String methodNameAndDesc = this.methods.get(i);
            if (!methodNameAndDesc.startsWith(name) || methodNameAndDesc.charAt(n) != '(') continue;
            if (methodNameAndDesc.endsWith(desc)) {
                this.methods.remove(i);
                return true;
            }
            if (!methodNameAndDesc.contains("(Lmockit/Invocation;") || !methodNameAndDesc.substring(n + 20).endsWith(desc.substring(1))) continue;
            this.withInvocationParameter = true;
            this.methods.remove(i);
            return true;
        }
        return false;
    }

    boolean isReentrant() {
        return this.indexForMockExpectations >= 0 && this.mockStates.getMockState(this.indexForMockExpectations).isReentrant();
    }

    public int getIndexForMockExpectations() {
        return this.indexForMockExpectations;
    }

    public boolean containsStaticMethod(String name, String desc) {
        return this.staticMethods.remove(name + desc);
    }

    public String getMockClassInternalName() {
        return this.mockClassInternalName;
    }

    public void setMockClassInternalName(String mockClassInternalName) {
        this.mockClassInternalName = mockClassInternalName;
    }

    public boolean isInnerMockClass() {
        return this.isInnerMockClass;
    }

    public void setInnerMockClass(boolean innerMockClass) {
        this.isInnerMockClass = innerMockClass;
    }

    public boolean isWithItField() {
        return this.withItField;
    }

    public void setWithItField(boolean withItField) {
        this.withItField = withItField;
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public boolean isWithInvocationParameter() {
        return this.withInvocationParameter;
    }
}

