/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.testng.internal;

import java.lang.reflect.Method;
import mockit.Mock;
import mockit.MockClass;
import mockit.Mockit;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.testng.IConfigurable;
import org.testng.IConfigureCallBack;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public final class TestNGRunnerDecorator
extends TestRunnerDecorator
implements IConfigurable,
IHookable {
    private final ThreadLocal<SavePoint> savePoint = new ThreadLocal();
    private boolean shouldPrepareForNextTest;

    private static boolean isMethodWithParametersProvidedByTestNG(Method method) {
        if (method.isAnnotationPresent(Parameters.class)) {
            return true;
        }
        Test testMetadata = method.getAnnotation(Test.class);
        return testMetadata != null && testMetadata.dataProvider().length() > 0;
    }

    public TestNGRunnerDecorator() {
        Mockit.setUpMocks(MockParameters.class);
        this.shouldPrepareForNextTest = true;
    }

    public void run(IConfigureCallBack callBack, ITestResult testResult) {
        Object instance = testResult.getInstance();
        Class testClass = testResult.getTestClass().getRealClass();
        this.updateTestClassState(instance, testClass);
        if (this.shouldPrepareForNextTest && testResult.getMethod().isBeforeMethodConfiguration()) {
            this.prepareForNextTest();
            this.shouldPrepareForNextTest = false;
        }
        TestRun.setRunningIndividualTest(instance);
        TestRun.setRunningTestMethod(null);
        try {
            callBack.runConfigurationMethod(testResult);
        }
        catch (RuntimeException t) {
            RecordAndReplayExecution.endCurrentReplayIfAny();
            Utilities.filterStackTrace(t);
            throw t;
        }
        finally {
            if (testResult.getMethod().isAfterMethodConfiguration()) {
                TestRun.getExecutingTest().setRecordAndReplay(null);
            }
        }
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Object instance = testResult.getInstance();
        Class testClass = testResult.getTestClass().getRealClass();
        this.updateTestClassState(instance, testClass);
        this.savePoint.set(new SavePoint());
        Method method = testResult.getMethod().getMethod();
        if (!TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method)) {
            Object[] parameters = testResult.getParameters();
            Object[] mockParameters = this.createInstancesForMockParametersIfAny(this, method, parameters);
            System.arraycopy(mockParameters, 0, parameters, 0, parameters.length);
        }
        if (this.shouldPrepareForNextTest) {
            this.prepareForNextTest();
        }
        TestRun.setRunningIndividualTest(instance);
        TestRun.setRunningTestMethod(method);
        this.shouldPrepareForNextTest = true;
        this.executeTestMethod(callBack, testResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestMethod(IHookCallBack callBack, ITestResult testResult) {
        try {
            callBack.runTestMethod(testResult);
            AssertionError error = RecordAndReplayExecution.endCurrentReplayIfAny();
            if (error != null) {
                Utilities.filterStackTrace((Throwable)((Object)error));
                throw error;
            }
            TestRun.verifyExpectationsOnAnnotatedMocks();
        }
        finally {
            this.cleanUpAfterTestMethodExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpAfterTestMethodExecution() {
        TestRun.enterNoMockingZone();
        try {
            TestRun.resetExpectationsOnAnnotatedMocks();
            TestRun.finishCurrentTestExecution();
            this.savePoint.get().rollback();
            this.savePoint.set(null);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @MockClass(realClass=org.testng.internal.Parameters.class, stubs={"checkParameterTypes"})
    public static final class MockParameters {
        @Mock(reentrant=true)
        public static Object getInjectedParameter(Class<?> c, Method method, ITestContext context, ITestResult testResult) {
            Object value = org.testng.internal.Parameters.getInjectedParameter(c, (Method)method, (ITestContext)context, (ITestResult)testResult);
            if (value != null) {
                return value;
            }
            return TestNGRunnerDecorator.isMethodWithParametersProvidedByTestNG(method) ? null : "";
        }
    }
}

