/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.asm;

import java.io.IOException;
import java.io.InputStream;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.Item;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;

public class ClassReader {
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    public final int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        int ll = this.items.length;
        this.strings = new String[ll];
        int max = 0;
        int index = off + 10;
        for (int i = 1; i < ll; ++i) {
            int size;
            this.items[i] = index + 1;
            byte tag = b[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        for (int i = 1; i < ll; ++i) {
            int index = this.items[i];
            byte tag = this.b[index - 1];
            Item item = new Item(i);
            switch (tag) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index + 2)];
                    item.set(tag, this.readClass(index, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index)));
                    break;
                }
                case 12: {
                    item.set(tag, this.readUTF8(index, buf), this.readUTF8(index + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index));
                    ++i;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index)));
                    ++i;
                    break;
                }
                case 1: {
                    String s = this.strings[i];
                    if (s == null) {
                        index = this.items[i];
                        s = this.strings[i] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
                    }
                    item.set(tag, s, null, null);
                    break;
                }
                default: {
                    item.set(tag, this.readUTF8(index, buf), null, null);
                }
            }
            int index2 = item.hashCode % items2.length;
            item.next = items2[index2];
            items2[index2] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        this.accept(classVisitor, NO_ATTRIBUTES, skipDebug);
    }

    /*
     * Unable to fully structure code
     */
    public void accept(ClassVisitor classVisitor, Attribute[] attrs, boolean skipDebug) {
        b = this.b;
        c = new char[this.maxStringLength];
        anns = 0;
        ianns = 0;
        cattrs = null;
        u = this.header;
        access = this.readUnsignedShort(u);
        name = this.readClass(u + 2, c);
        v = this.items[this.readUnsignedShort(u + 4)];
        superClassName = v == 0 ? null : this.readUTF8(v, c);
        implementedItfs = new String[this.readUnsignedShort(u + 6)];
        w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        signature = null;
        sourceFile = null;
        sourceDebug = null;
        enclosingOwner = null;
        enclosingName = null;
        enclosingDesc = null;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            attrName = this.readUTF8(v, c);
            if (attrName.equals("SourceFile")) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if (attrName.equals("Deprecated")) {
                access |= 131072;
            } else if (attrName.equals("Synthetic")) {
                access |= 4096;
            } else if (attrName.equals("Annotation")) {
                access |= 8192;
            } else if (attrName.equals("Enum")) {
                access |= 16384;
            } else if (attrName.equals("InnerClasses")) {
                w = v + 6;
            } else if (attrName.equals("Signature")) {
                signature = this.readUTF8(v + 6, c);
            } else if (attrName.equals("SourceDebugExtension")) {
                len = this.readInt(v + 2);
                sourceDebug = this.readUTF(v + 6, len, new char[len]);
            } else if (attrName.equals("EnclosingMethod")) {
                enclosingOwner = this.readClass(v + 6, c);
                item = this.readUnsignedShort(v + 8);
                if (item != 0) {
                    enclosingName = this.readUTF8(this.items[item], c);
                    enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                }
            } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                anns = v + 6;
            } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                ianns = v + 6;
            } else {
                attr = this.readAttribute(attrs, attrName, v + 6, this.readInt(v + 2), c, -1, null);
                if (attr != null) {
                    attr.next = cattrs;
                    cattrs = attr;
                }
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        classVisitor.visit(this.readInt(4), access, name, signature, superClassName, implementedItfs);
        if (sourceFile != null || sourceDebug != null) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        for (i = 1; i >= 0; --i) {
            v0 = v = i == 0 ? ianns : anns;
            if (v == 0) continue;
            j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                desc = this.readUTF8(v, c);
                v += 2;
                v = this.readAnnotationValues(v, c, classVisitor.visitAnnotation(desc, i != 0));
                --j;
            }
        }
        while (cattrs != null) {
            attr = cattrs.next;
            cattrs.next = null;
            classVisitor.visitAttribute(cattrs);
            cattrs = attr;
        }
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            fieldValueItem = 0;
            signature = null;
            anns = 0;
            ianns = 0;
            cattrs = null;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                if (attrName.equals("ConstantValue")) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if (attrName.equals("Synthetic")) {
                    access |= 4096;
                } else if (attrName.equals("Deprecated")) {
                    access |= 131072;
                } else if (attrName.equals("Enum")) {
                    access |= 16384;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u + 6, c);
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u + 6;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u + 6;
                } else {
                    attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += 6 + this.readInt(u + 2);
                --j;
            }
            value = fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c);
            fv = classVisitor.visitField(access, name, desc, signature, value);
            if (fv != null) {
                for (j = 1; j >= 0; --j) {
                    v1 = v = j == 0 ? ianns : anns;
                    if (v == 0) continue;
                    k = this.readUnsignedShort(v);
                    v += 2;
                    while (k > 0) {
                        desc = this.readUTF8(v, c);
                        v += 2;
                        v = this.readAnnotationValues(v, c, fv.visitAnnotation(desc, j != 0));
                        --k;
                    }
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    fv.visitAttribute(cattrs);
                    cattrs = attr;
                }
                fv.visitEnd();
            }
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            u0 = u + 6;
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
            signature = null;
            anns = 0;
            ianns = 0;
            dann = 0;
            mpanns = 0;
            impanns = 0;
            cattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                attrName = this.readUTF8(u, c);
                attrSize = this.readInt(u += 2);
                u += 4;
                if (attrName.equals("Code")) {
                    v = u;
                } else if (attrName.equals("Exceptions")) {
                    w = u;
                } else if (attrName.equals("Synthetic")) {
                    access |= 4096;
                } else if (attrName.equals("Varargs")) {
                    access |= 128;
                } else if (attrName.equals("Bridge")) {
                    access |= 64;
                } else if (attrName.equals("Deprecated")) {
                    access |= 131072;
                } else if (attrName.equals("Signature")) {
                    signature = this.readUTF8(u, c);
                } else if (attrName.equals("AnnotationDefault")) {
                    dann = u;
                } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                    anns = u;
                } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                    ianns = u;
                } else if (attrName.equals("RuntimeVisibleParameterAnnotations")) {
                    mpanns = u;
                } else if (attrName.equals("RuntimeInvisibleParameterAnnotations")) {
                    impanns = u;
                } else {
                    attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null);
                    if (attr != null) {
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                u += attrSize;
                --j;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
            mv = classVisitor.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) ** GOTO lbl314
            if (!(mv instanceof MethodWriter)) ** GOTO lbl-1000
            mw = (MethodWriter)mv;
            if (mw.cw.cr != this || signature != mw.signature) ** GOTO lbl-1000
            sameExceptions = false;
            if (exceptions == null) {
                sameExceptions = mw.exceptionCount == 0;
            } else if (exceptions.length == mw.exceptionCount) {
                sameExceptions = true;
                for (j = exceptions.length - 1; j >= 0; --j) {
                    if (mw.exceptions[j] == this.readUnsignedShort(w -= 2)) continue;
                    sameExceptions = false;
                    break;
                }
            }
            if (sameExceptions) {
                mw.classReaderOffset = u0;
                mw.classReaderLength = u - u0;
            } else lbl-1000:
            // 3 sources

            {
                if (dann != 0) {
                    dv = mv.visitAnnotationDefault();
                    this.readAnnotationValue(dann, c, null, dv);
                    dv.visitEnd();
                }
                for (j = 1; j >= 0; --j) {
                    v2 = w = j == 0 ? ianns : anns;
                    if (w == 0) continue;
                    k = this.readUnsignedShort(w);
                    w += 2;
                    while (k > 0) {
                        desc = this.readUTF8(w, c);
                        w += 2;
                        w = this.readAnnotationValues(w, c, mv.visitAnnotation(desc, j != 0));
                        --k;
                    }
                }
                if (mpanns != 0) {
                    this.readParameterAnnotations(mpanns, c, true, mv);
                }
                if (impanns != 0) {
                    this.readParameterAnnotations(impanns, c, false, mv);
                }
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
lbl314:
                // 2 sources

                if (mv != null && v != 0) {
                    maxStack = this.readUnsignedShort(v);
                    maxLocals = this.readUnsignedShort(v + 2);
                    codeLength = this.readInt(v + 4);
                    codeStart = v += 8;
                    codeEnd = v + codeLength;
                    mv.visitCode();
                    labels = new Label[codeLength + 1];
                    block50: while (v < codeEnd) {
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: 
                            case 4: {
                                ++v;
                                continue block50;
                            }
                            case 8: {
                                label = v - codeStart + this.readShort(v + 1);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                v += 3;
                                continue block50;
                            }
                            case 9: {
                                label = v - codeStart + this.readInt(v + 1);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                v += 5;
                                continue block50;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    v += 6;
                                    continue block50;
                                }
                                v += 4;
                                continue block50;
                            }
                            case 13: {
                                w = v - codeStart;
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j = this.readInt(v);
                                v += 4;
                                for (j = this.readInt(v += 4) - j + 1; j > 0; --j) {
                                    label = w + this.readInt(v);
                                    v += 4;
                                    if (labels[label] != null) continue;
                                    labels[label] = new Label();
                                }
                                continue block50;
                            }
                            case 14: {
                                w = v - codeStart;
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                j = this.readInt(v);
                                v += 4;
                                while (j > 0) {
                                    label = w + this.readInt(v += 4);
                                    v += 4;
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    --j;
                                }
                                continue block50;
                            }
                            case 1: 
                            case 3: 
                            case 10: {
                                v += 2;
                                continue block50;
                            }
                            case 2: 
                            case 5: 
                            case 6: 
                            case 11: 
                            case 12: {
                                v += 3;
                                continue block50;
                            }
                            case 7: {
                                v += 5;
                                continue block50;
                            }
                        }
                        v += 4;
                    }
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        label = this.readUnsignedShort(v);
                        start = labels[label];
                        if (start == null) {
                            labels[label] = start = new Label();
                        }
                        if ((end = labels[label = this.readUnsignedShort(v + 2)]) == null) {
                            labels[label] = end = new Label();
                        }
                        if ((handler = labels[label = this.readUnsignedShort(v + 4)]) == null) {
                            labels[label] = handler = new Label();
                        }
                        if ((type = this.readUnsignedShort(v + 6)) == 0) {
                            mv.visitTryCatchBlock(start, end, handler, null);
                        } else {
                            mv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                        }
                        v += 8;
                        --j;
                    }
                    varTable = 0;
                    varTypeTable = 0;
                    cattrs = null;
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        attrName = this.readUTF8(v, c);
                        if (attrName.equals("LocalVariableTable")) {
                            if (!skipDebug) {
                                varTable = v + 6;
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                        labels[label] = new Label();
                                    }
                                    w += 10;
                                }
                            }
                        } else if (attrName.equals("LocalVariableTypeTable")) {
                            varTypeTable = v + 6;
                        } else if (attrName.equals("LineNumberTable")) {
                            if (!skipDebug) {
                                w = v + 8;
                                for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                    label = this.readUnsignedShort(w);
                                    if (labels[label] == null) {
                                        labels[label] = new Label();
                                    }
                                    labels[label].line = this.readUnsignedShort(w + 2);
                                    w += 4;
                                }
                            }
                        } else {
                            for (k = 0; k < attrs.length; ++k) {
                                if (!attrs[k].type.equals(attrName) || (attr = attrs[k].read(this, v + 6, this.readInt(v + 2))) == null) continue;
                                attr.next = cattrs;
                                cattrs = attr;
                            }
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                    v = codeStart;
                    block58: while (v < codeEnd) {
                        w = v - codeStart;
                        l = labels[w];
                        if (l != null) {
                            mv.visitLabel(l);
                            if (!skipDebug && l.line > 0) {
                                mv.visitLineNumber(l.line, l);
                            }
                        }
                        opcode = b[v] & 255;
                        switch (ClassWriter.TYPE[opcode]) {
                            case 0: {
                                mv.visitInsn(opcode);
                                ++v;
                                continue block58;
                            }
                            case 4: {
                                if (opcode > 54) {
                                    mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                                } else {
                                    mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                                }
                                ++v;
                                continue block58;
                            }
                            case 8: {
                                mv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                                v += 3;
                                continue block58;
                            }
                            case 9: {
                                mv.visitJumpInsn(opcode - 33, labels[w + this.readInt(v + 1)]);
                                v += 5;
                                continue block58;
                            }
                            case 16: {
                                opcode = b[v + 1] & 255;
                                if (opcode == 132) {
                                    mv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                    v += 6;
                                    continue block58;
                                }
                                mv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                                v += 4;
                                continue block58;
                            }
                            case 13: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                min = this.readInt(v += 4);
                                max = this.readInt(v += 4);
                                v += 4;
                                table = new Label[max - min + 1];
                                for (j = 0; j < table.length; ++j) {
                                    table[j] = labels[w + this.readInt(v)];
                                    v += 4;
                                }
                                mv.visitTableSwitchInsn(min, max, labels[label], table);
                                continue block58;
                            }
                            case 14: {
                                v = v + 4 - (w & 3);
                                label = w + this.readInt(v);
                                j = this.readInt(v += 4);
                                v += 4;
                                keys = new int[j];
                                values = new Label[j];
                                for (j = 0; j < keys.length; ++j) {
                                    keys[j] = this.readInt(v);
                                    values[j] = labels[w + this.readInt(v += 4)];
                                    v += 4;
                                }
                                mv.visitLookupSwitchInsn(labels[label], keys, values);
                                continue block58;
                            }
                            case 3: {
                                mv.visitVarInsn(opcode, b[v + 1] & 255);
                                v += 2;
                                continue block58;
                            }
                            case 1: {
                                mv.visitIntInsn(opcode, b[v + 1]);
                                v += 2;
                                continue block58;
                            }
                            case 2: {
                                mv.visitIntInsn(opcode, this.readShort(v + 1));
                                v += 3;
                                continue block58;
                            }
                            case 10: {
                                mv.visitLdcInsn(this.readConst(b[v + 1] & 255, c));
                                v += 2;
                                continue block58;
                            }
                            case 11: {
                                mv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                                v += 3;
                                continue block58;
                            }
                            case 6: 
                            case 7: {
                                cpIndex = this.items[this.readUnsignedShort(v + 1)];
                                iowner = this.readClass(cpIndex, c);
                                cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                                iname = this.readUTF8(cpIndex, c);
                                idesc = this.readUTF8(cpIndex + 2, c);
                                if (opcode < 182) {
                                    mv.visitFieldInsn(opcode, iowner, iname, idesc);
                                } else {
                                    mv.visitMethodInsn(opcode, iowner, iname, idesc);
                                }
                                if (opcode == 185) {
                                    v += 5;
                                    continue block58;
                                }
                                v += 3;
                                continue block58;
                            }
                            case 5: {
                                mv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                                v += 3;
                                continue block58;
                            }
                            case 12: {
                                mv.visitIincInsn(b[v + 1] & 255, b[v + 2]);
                                v += 3;
                                continue block58;
                            }
                        }
                        mv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 255);
                        v += 4;
                    }
                    l = labels[codeEnd - codeStart];
                    if (l != null) {
                        mv.visitLabel(l);
                    }
                    if (!skipDebug && varTable != 0) {
                        typeTable = null;
                        if (varTypeTable != 0) {
                            w = varTypeTable;
                            k = this.readUnsignedShort(w) * 3;
                            w += 2;
                            typeTable = new int[k];
                            while (k > 0) {
                                typeTable[--k] = w + 6;
                                typeTable[--k] = this.readUnsignedShort(w + 8);
                                typeTable[--k] = this.readUnsignedShort(w);
                                w += 10;
                            }
                        }
                        w = varTable;
                        k = this.readUnsignedShort(w);
                        w += 2;
                        while (k > 0) {
                            start = this.readUnsignedShort(w);
                            length = this.readUnsignedShort(w + 2);
                            index = this.readUnsignedShort(w + 8);
                            vsignature = null;
                            if (typeTable != null) {
                                for (a = 0; a < typeTable.length; a += 3) {
                                    if (typeTable[a] != start || typeTable[a + 1] != index) continue;
                                    vsignature = this.readUTF8(typeTable[a + 2], c);
                                    break;
                                }
                            }
                            mv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), vsignature, labels[start], labels[start + length], index);
                            w += 10;
                            --k;
                        }
                    }
                    while (cattrs != null) {
                        attr = cattrs.next;
                        cattrs.next = null;
                        mv.visitAttribute(cattrs);
                        cattrs = attr;
                    }
                    mv.visitMaxs(maxStack, maxLocals);
                }
                if (mv != null) {
                    mv.visitEnd();
                }
            }
            --i;
        }
        classVisitor.visitEnd();
    }

    private void readParameterAnnotations(int v, char[] buf, boolean visible, MethodVisitor mv) {
        int n = this.b[v++] & 0xFF;
        for (int i = 0; i < n; ++i) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                String desc = this.readUTF8(v, buf);
                v += 2;
                AnnotationVisitor av = mv.visitParameterAnnotation(i, desc, visible);
                v = this.readAnnotationValues(v, buf, av);
                --j;
            }
        }
    }

    private int readAnnotationValues(int v, char[] buf, AnnotationVisitor av) {
        int i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String name = this.readUTF8(v, buf);
            v += 2;
            v = this.readAnnotationValue(v, buf, name, av);
            --i;
        }
        av.visitEnd();
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name, AnnotationVisitor av) {
        block0 : switch (this.readByte(v++)) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 90: {
                boolean b = this.readInt(this.items[this.readUnsignedShort(v)]) == 0;
                av.visit(name, b ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name, new Short((short)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name, new Character((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                String desc = this.readUTF8(v, buf);
                v += 2;
                v = this.readAnnotationValues(v, buf, av.visitAnnotation(name, desc));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v);
                v += 2;
                if (size == 0) {
                    av.visitArray(name).visitEnd();
                    return v;
                }
                switch (this.readByte(v++)) {
                    case 66: {
                        byte[] bv = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            bv[i] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, bv);
                        --v;
                        break block0;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        for (int i = 0; i < size; ++i) {
                            zv[i] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name, zv);
                        --v;
                        break block0;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        for (int i = 0; i < size; ++i) {
                            sv[i] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, sv);
                        --v;
                        break block0;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        for (int i = 0; i < size; ++i) {
                            cv[i] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, cv);
                        --v;
                        break block0;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        for (int i = 0; i < size; ++i) {
                            iv[i] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, iv);
                        --v;
                        break block0;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        for (int i = 0; i < size; ++i) {
                            lv[i] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, lv);
                        --v;
                        break block0;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        for (int i = 0; i < size; ++i) {
                            fv[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, fv);
                        --v;
                        break block0;
                    }
                    case 68: {
                        double[] dv = new double[size];
                        for (int i = 0; i < size; ++i) {
                            dv[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, dv);
                        --v;
                        break block0;
                    }
                }
                --v;
                AnnotationVisitor aav = av.visitArray(name);
                for (int i = size; i > 0; --i) {
                    v = this.readAnnotationValue(v, buf, null, aav);
                }
                aav.visitEnd();
            }
        }
        return v;
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].type.equals(type)) continue;
            return attrs[i].read(this, off, len);
        }
        return new Attribute(type).read(this, off, len);
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
        return this.strings[item];
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
            case 7: {
                String s = this.readUTF8(index, buf);
                return Type.getType(s.charAt(0) == '[' ? s : "L" + s + ";");
            }
        }
        return this.readUTF8(index, buf);
    }
}

