/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import mockit.Mockit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockUp<T> {
    private final T mockInstance;

    protected MockUp() {
        Class classToMock;
        ParameterizedType paramType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type typeToMock = paramType.getActualTypeArguments()[0];
        if (typeToMock instanceof Class) {
            classToMock = (Class)typeToMock;
            if (classToMock.isInterface()) {
                this.mockInstance = Mockit.newEmptyProxy(classToMock);
                classToMock = this.mockInstance.getClass();
            } else {
                this.mockInstance = null;
            }
        } else if (typeToMock instanceof TypeVariable) {
            this.mockInstance = Mockit.newEmptyProxy(typeToMock);
            classToMock = this.mockInstance.getClass();
        } else {
            classToMock = (Class)((ParameterizedType)typeToMock).getRawType();
            if (classToMock.isInterface()) {
                this.mockInstance = Mockit.newEmptyProxy(typeToMock);
                classToMock = this.mockInstance.getClass();
            } else {
                this.mockInstance = null;
            }
        }
        Mockit.setUpMock(classToMock, (Object)this);
    }

    protected MockUp(Class<?> classToMock) {
        this.mockInstance = null;
        Mockit.setUpMock(classToMock, (Object)this);
    }

    public final T getMockInstance() {
        return this.mockInstance;
    }
}

