/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;

public final class PathUtils {
    public static URL fileAsUrl(String file) {
        return PathUtils.fileAsUrl(new File(file));
    }

    public static URL fileAsUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File urlAsFile(URL url) {
        if (url == null) {
            return null;
        }
        return new File(PathUtils.urlAsPath(url));
    }

    public static String urlAsPath(URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        String file = url.getPath();
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if ("file".equals(protocol)) {
            return file;
        }
        if ("jar".equals(protocol) || "zip".equals(protocol)) {
            int ipos = file.indexOf("!/");
            if (ipos > 0) {
                file = file.substring(0, ipos);
            }
            if (file.startsWith("file:")) {
                file = file.substring("file:".length());
            }
            return file;
        }
        if ("vfs".equals(protocol)) {
            int ipos = file.indexOf("!/");
            if (ipos > 0) {
                file = file.substring(0, ipos);
            } else if (file.endsWith("/")) {
                file = file.substring(0, file.length() - 1);
            }
            return file;
        }
        return file;
    }

    public static String normalize(String originPath) {
        int pos;
        String path = originPath;
        if (path == null) {
            return null;
        }
        if (path.indexOf(92) != -1) {
            path = path.replace('\\', '/');
        }
        while ((pos = path.indexOf("./")) == 0) {
            path = path.substring(2);
        }
        if (pos == -1 && !path.contains("//")) {
            return path;
        }
        boolean absolute = path.startsWith("/");
        boolean dir = path.endsWith("/");
        String[] elements = path.split("/");
        LinkedList<String> list = new LinkedList<String>();
        for (String e : elements) {
            if ("..".equals(e)) {
                if (list.isEmpty() || "..".equals(list.getLast())) {
                    list.add(e);
                    continue;
                }
                list.removeLast();
                continue;
            }
            if (".".equals(e) || e.isEmpty()) continue;
            list.add(e);
        }
        StringBuilder sb = new StringBuilder(path.length());
        if (absolute) {
            sb.append('/');
        }
        int count = 0;
        int last = list.size() - 1;
        for (String e : list) {
            sb.append(e);
            if (count++ >= last) continue;
            sb.append('/');
        }
        if (dir && list.size() > 0) {
            sb.append('/');
        }
        if ((path = sb.toString()).startsWith("/..")) {
            throw new IllegalStateException("invalid path: " + originPath);
        }
        return path;
    }

    public static String concat(String parent, String child) {
        if (parent == null) {
            return PathUtils.normalize(child);
        }
        if (child == null) {
            return PathUtils.normalize(parent);
        }
        return PathUtils.normalize(parent + '/' + child);
    }

    public static String getRelativePath(String baseFile, String file) {
        if (file.startsWith("/")) {
            return PathUtils.normalize(file);
        }
        int separatorIndex = baseFile.lastIndexOf(47);
        if (separatorIndex != -1) {
            String newPath = baseFile.substring(0, separatorIndex + 1);
            return PathUtils.normalize(newPath + file);
        }
        return PathUtils.normalize(file);
    }

    public static String separatorsToUnix(String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static String separatorsToWindows(String path) {
        if (path == null || path.indexOf(47) == -1) {
            return path;
        }
        return path.replace('/', '\\');
    }

    public static String separatorsToSystem(String path) {
        if (path == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return PathUtils.separatorsToWindows(path);
        }
        return PathUtils.separatorsToUnix(path);
    }
}

