/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import jetbrick.io.resource.Resource;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.JdkUtils;

public final class URLConvertor
implements Convertor<URL> {
    public static final URLConvertor INSTANCE = new URLConvertor();

    @Override
    public URL convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw TypeCastException.create(value, URL.class, e);
        }
    }

    @Override
    public URL convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == URL.class) {
            return (URL)value;
        }
        if (value instanceof File) {
            try {
                return ((File)value).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw TypeCastException.create(value, URL.class, e);
            }
        }
        if (value.getClass() == URI.class) {
            try {
                return ((URI)value).toURL();
            }
            catch (MalformedURLException e) {
                throw TypeCastException.create(value, URL.class, e);
            }
        }
        if (value instanceof Resource) {
            return ((Resource)value).getURL();
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_7 && value instanceof Path) {
            try {
                return ((Path)value).toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw TypeCastException.create(value, URL.class, e);
            }
        }
        return this.convert(value.toString());
    }
}

