/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class IntegerConvertor
implements Convertor<Integer> {
    public static final IntegerConvertor INSTANCE = new IntegerConvertor();

    @Override
    public Integer convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Integer.class, e);
        }
    }

    @Override
    public Integer convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Integer.class) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return this.convert(value.toString());
    }
}

