/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.ExceptionUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.Validate;

public final class ZipEntryResource
extends AbstractResource {
    private final URL url;
    private final ZipFile zip;
    private final ZipEntry entry;
    private final String entryName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZipEntryResource(URL url) {
        this.url = url;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            try {
                URLConnection conn = url.openConnection();
                if (!(conn instanceof JarURLConnection)) throw new IllegalStateException("Unknown url format: " + url);
                JarURLConnection connection = (JarURLConnection)conn;
                this.zip = connection.getJarFile();
                this.entry = connection.getJarEntry();
                this.relativePathName = this.entryName = this.entry.getName();
                throw new IllegalStateException("Unknown url format: " + url);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (!"zip".equals(protocol)) throw new IllegalStateException("Unknown url format: " + url);
        try {
            URLConnection conn = url.openConnection();
            if (!"weblogic.utils.zip.ZipURLConnection".equals(conn.getClass().getName())) throw new IllegalStateException("Unknown url format: " + url);
            this.zip = WeblogicZipURLConnection.getZipFile(conn);
            this.entry = WeblogicZipURLConnection.getZipEntry(conn);
            this.relativePathName = this.entryName = this.entry.getName();
            throw new IllegalStateException("Unknown url format: " + url);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ZipEntryResource(ZipFile zip, String entryName) {
        Validate.notNull(zip);
        this.url = null;
        this.zip = zip;
        this.entry = zip.getEntry(entryName);
        this.entryName = entryName;
        this.relativePathName = entryName;
    }

    public ZipEntryResource(ZipFile zip, ZipEntry entry) {
        Validate.notNull(zip);
        this.url = null;
        this.zip = zip;
        this.entry = entry;
        this.relativePathName = this.entryName = entry.getName();
    }

    public ZipFile getZipFile() {
        return this.zip;
    }

    public ZipEntry getZipEntry() {
        return this.entry;
    }

    public String getZipEntryName() {
        return this.entryName;
    }

    @Override
    public InputStream openStream() throws ResourceNotFoundException {
        try {
            InputStream is = this.zip.getInputStream(this.entry);
            if (is == null) {
                throw new ResourceNotFoundException(this.entryName);
            }
            return is;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI getURI() {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URL getURL() {
        if (this.url != null) {
            return this.url;
        }
        try {
            String path = "file:" + this.zip.getName() + "!/" + this.entryName;
            return new URL("jar", null, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean exist() {
        return this.entry != null;
    }

    @Override
    public boolean isDirectory() {
        return this.entry == null ? false : this.entry.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.entry == null ? false : !this.entry.isDirectory();
    }

    @Override
    public String getFileName() {
        String name = StringUtils.removeEnd(this.entryName, "/");
        int slash = name.lastIndexOf(47);
        if (slash >= 0) {
            return name.substring(slash + 1);
        }
        return name;
    }

    @Override
    public long length() {
        return this.entry == null ? -1L : this.entry.getSize();
    }

    @Override
    public long lastModified() {
        return this.entry == null ? 0L : this.entry.getTime();
    }

    public String toString() {
        if (this.url != null) {
            return this.url.toString();
        }
        return "jar:" + this.zip.getName() + "!/" + this.entryName;
    }

    static class WeblogicZipURLConnection {
        static final Field FIELD_ZIP_FILE;
        static final Field FIELD_ZIP_ENTRY;

        WeblogicZipURLConnection() {
        }

        static ZipFile getZipFile(URLConnection conn) {
            try {
                return (ZipFile)FIELD_ZIP_FILE.get(conn);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        }

        static ZipEntry getZipEntry(URLConnection conn) {
            try {
                return (ZipEntry)FIELD_ZIP_ENTRY.get(conn);
            }
            catch (Exception e) {
                throw ExceptionUtils.unchecked(e);
            }
        }

        static {
            ClassLoader loader = WeblogicZipURLConnection.class.getClassLoader();
            try {
                Class<?> klass = loader.loadClass("weblogic.utils.zip.ZipURLConnection");
                FIELD_ZIP_FILE = klass.getDeclaredField("zip");
                FIELD_ZIP_ENTRY = klass.getDeclaredField("ze");
                FIELD_ZIP_FILE.setAccessible(true);
                FIELD_ZIP_ENTRY.setAccessible(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not detect Weblogic zip url infrastructure", e);
            }
        }
    }
}

