/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.ExceptionUtils;

public final class JbossVfsResource
extends AbstractResource {
    private final Object resource;
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private static final Method VFS_METHOD_GET_ROOT_URL;
    private static final Method VIRTUAL_FILE_METHOD_EXISTS;
    private static final Method VIRTUAL_FILE_METHOD_IS_DIRECTORY;
    private static final Method VIRTUAL_FILE_METHOD_IS_FILE;
    private static final Method VIRTUAL_FILE_METHOD_OPEN_STREAM;
    private static final Method VIRTUAL_FILE_METHOD_GET_SIZE;
    private static final Method VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED;
    private static final Method VIRTUAL_FILE_METHOD_TO_URL;
    private static final Method VIRTUAL_FILE_METHOD_TO_URI;
    private static final Method VIRTUAL_FILE_METHOD_GET_NAME;
    private static final Method VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE;
    private static final Method VIRTUAL_FILE_METHOD_GET_CHILDREN;

    public JbossVfsResource(URL url) {
        this.resource = JbossVfsResource.vfsInvokeMethod(VFS_METHOD_GET_ROOT_URL, null, new Object[]{url});
        this.relativePathName = this.getURL().toString();
    }

    private JbossVfsResource(Object resource) {
        this.resource = resource;
        this.relativePathName = this.getURL().toString();
    }

    @Override
    public InputStream openStream() {
        if (this.resource == null) {
            throw new ResourceNotFoundException();
        }
        InputStream is = (InputStream)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_OPEN_STREAM, this.resource, EMPTY_PARAMETERS);
        if (is == null) {
            throw new ResourceNotFoundException(this.getURL().toString());
        }
        return is;
    }

    @Override
    public File getFile() {
        return (File)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public URI getURI() {
        return (URI)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_TO_URI, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public URL getURL() {
        return (URL)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_TO_URL, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public boolean isDirectory() {
        return (Boolean)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_IS_DIRECTORY, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public boolean isFile() {
        return (Boolean)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_IS_FILE, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public String getFileName() {
        return (String)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_GET_NAME, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public boolean exist() {
        return (Boolean)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_EXISTS, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public long length() {
        return (Long)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_GET_SIZE, this.resource, EMPTY_PARAMETERS);
    }

    @Override
    public long lastModified() {
        return (Long)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED, this.resource, EMPTY_PARAMETERS);
    }

    public List<JbossVfsResource> getChildren() {
        List resources = (List)JbossVfsResource.vfsInvokeMethod(VIRTUAL_FILE_METHOD_GET_CHILDREN, this.resource, EMPTY_PARAMETERS);
        if (resources == null || resources.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<JbossVfsResource> children = new ArrayList<JbossVfsResource>(resources.size());
        for (Object e : children) {
            children.add(new JbossVfsResource(e));
        }
        return children;
    }

    public String toString() {
        return this.resource.toString();
    }

    static Method vfsGetMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        for (Class<?> type = clazz; type != null; type = type.getSuperclass()) {
            for (Method method : type.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || parameterTypes != null && !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
                method.setAccessible(true);
                return method;
            }
        }
        return null;
    }

    static Object vfsInvokeMethod(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    static {
        ClassLoader loader = JbossVfsResource.class.getClassLoader();
        try {
            Class<?> vfsClass = loader.loadClass("org.jboss.vfs.VFS");
            VFS_METHOD_GET_ROOT_URL = JbossVfsResource.vfsGetMethod(vfsClass, "getChild", new Class[]{URL.class});
            Class<?> virtualFileClass = loader.loadClass("org.jboss.vfs.VirtualFile");
            VIRTUAL_FILE_METHOD_EXISTS = JbossVfsResource.vfsGetMethod(virtualFileClass, "exists", null);
            VIRTUAL_FILE_METHOD_IS_DIRECTORY = JbossVfsResource.vfsGetMethod(virtualFileClass, "isDirectory", null);
            VIRTUAL_FILE_METHOD_IS_FILE = JbossVfsResource.vfsGetMethod(virtualFileClass, "isFile", null);
            VIRTUAL_FILE_METHOD_OPEN_STREAM = JbossVfsResource.vfsGetMethod(virtualFileClass, "openStream", null);
            VIRTUAL_FILE_METHOD_GET_SIZE = JbossVfsResource.vfsGetMethod(virtualFileClass, "getSize", null);
            VIRTUAL_FILE_METHOD_GET_LAST_MODIFIED = JbossVfsResource.vfsGetMethod(virtualFileClass, "getLastModified", null);
            VIRTUAL_FILE_METHOD_TO_URI = JbossVfsResource.vfsGetMethod(virtualFileClass, "toURI", null);
            VIRTUAL_FILE_METHOD_TO_URL = JbossVfsResource.vfsGetMethod(virtualFileClass, "toURL", null);
            VIRTUAL_FILE_METHOD_GET_NAME = JbossVfsResource.vfsGetMethod(virtualFileClass, "getName", null);
            VIRTUAL_FILE_METHOD_GET_PHYSICAL_FILE = JbossVfsResource.vfsGetMethod(virtualFileClass, "getPhysicalFile", null);
            VIRTUAL_FILE_METHOD_GET_CHILDREN = JbossVfsResource.vfsGetMethod(virtualFileClass, "getChildren", null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not detect JBoss VFS infrastructure", e);
        }
    }
}

