/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.InverseExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.OldOracleJoinBinaryExpression;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;

public class ExpressionDeParser
implements ExpressionVisitor,
ItemsListVisitor {
    private StringBuilder buffer;
    private SelectVisitor selectVisitor;
    private boolean useBracketsInExprList = true;

    public ExpressionDeParser() {
    }

    public ExpressionDeParser(SelectVisitor selectVisitor, StringBuilder buffer) {
        this.selectVisitor = selectVisitor;
        this.buffer = buffer;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition, " + ");
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression, " AND ");
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        if (between.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" BETWEEN ");
        between.getBetweenExpressionStart().accept(this);
        this.buffer.append(" AND ");
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitOldOracleJoinBinaryExpression(equalsTo, " = ");
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division, " / ");
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.buffer.append(doubleValue.toString());
    }

    public void visitOldOracleJoinBinaryExpression(OldOracleJoinBinaryExpression expression, String operator) {
        if (expression.isNot()) {
            this.buffer.append(" NOT ");
        }
        expression.getLeftExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 1) {
            this.buffer.append("(+)");
        }
        this.buffer.append(operator);
        expression.getRightExpression().accept(this);
        if (expression.getOldOracleJoinSyntax() == 2) {
            this.buffer.append("(+)");
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitOldOracleJoinBinaryExpression(greaterThan, " > ");
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitOldOracleJoinBinaryExpression(greaterThanEquals, " >= ");
    }

    @Override
    public void visit(InExpression inExpression) {
        if (inExpression.getLeftExpression() == null) {
            inExpression.getLeftItemsList().accept(this);
        } else {
            inExpression.getLeftExpression().accept(this);
            if (inExpression.getOldOracleJoinSyntax() == 1) {
                this.buffer.append("(+)");
            }
        }
        if (inExpression.isNot()) {
            this.buffer.append(" NOT");
        }
        this.buffer.append(" IN ");
        inExpression.getRightItemsList().accept(this);
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        this.buffer.append("-");
        inverseExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        isNullExpression.getLeftExpression().accept(this);
        if (isNullExpression.isNot()) {
            this.buffer.append(" IS NOT NULL");
        } else {
            this.buffer.append(" IS NULL");
        }
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.buffer.append("?");
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression, " LIKE ");
        String escape = likeExpression.getEscape();
        if (escape != null) {
            this.buffer.append(" ESCAPE '").append(escape).append('\'');
        }
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        if (existsExpression.isNot()) {
            this.buffer.append("NOT EXISTS ");
        } else {
            this.buffer.append("EXISTS ");
        }
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
        this.buffer.append(longValue.getStringValue());
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitOldOracleJoinBinaryExpression(minorThan, " < ");
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitOldOracleJoinBinaryExpression(minorThanEquals, " <= ");
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication, " * ");
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitOldOracleJoinBinaryExpression(notEqualsTo, " <> ");
    }

    @Override
    public void visit(NullValue nullValue) {
        this.buffer.append("NULL");
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression, " OR ");
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        if (parenthesis.isNot()) {
            this.buffer.append(" NOT ");
        }
        this.buffer.append("(");
        parenthesis.getExpression().accept(this);
        this.buffer.append(")");
    }

    @Override
    public void visit(StringValue stringValue) {
        this.buffer.append("'").append(stringValue.getValue()).append("'");
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction, " - ");
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression, String operator) {
        if (binaryExpression.isNot()) {
            this.buffer.append(" NOT ");
        }
        binaryExpression.getLeftExpression().accept(this);
        this.buffer.append(operator);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this.selectVisitor);
        this.buffer.append(")");
    }

    @Override
    public void visit(Column tableColumn) {
        Alias alias = tableColumn.getTable().getAlias();
        String tableName = null;
        if (alias != null) {
            tableName = alias.getName();
        } else if (tableName == null) {
            tableName = tableColumn.getTable().getWholeTableName();
        }
        if (tableName != null) {
            this.buffer.append(tableName).append(".");
        }
        this.buffer.append(tableColumn.getColumnName());
    }

    @Override
    public void visit(Function function) {
        if (function.isEscaped()) {
            this.buffer.append("{fn ");
        }
        this.buffer.append(function.getName());
        if (function.isAllColumns()) {
            this.buffer.append("(*)");
        } else if (function.getParameters() == null) {
            this.buffer.append("()");
        } else {
            boolean oldUseBracketsInExprList = this.useBracketsInExprList;
            if (function.isDistinct()) {
                this.useBracketsInExprList = false;
                this.buffer.append("(DISTINCT ");
            }
            this.visit(function.getParameters());
            this.useBracketsInExprList = oldUseBracketsInExprList;
            if (function.isDistinct()) {
                this.buffer.append(")");
            }
        }
        if (function.isEscaped()) {
            this.buffer.append("}");
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        if (this.useBracketsInExprList) {
            this.buffer.append("(");
        }
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        if (this.useBracketsInExprList) {
            this.buffer.append(")");
        }
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(DateValue dateValue) {
        this.buffer.append("{d '").append(dateValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.buffer.append("{ts '").append(timestampValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.buffer.append("{t '").append(timeValue.getValue().toString()).append("'}");
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.buffer.append("CASE ");
        Expression switchExp = caseExpression.getSwitchExpression();
        if (switchExp != null) {
            switchExp.accept(this);
            this.buffer.append(" ");
        }
        for (Expression exp : caseExpression.getWhenClauses()) {
            exp.accept(this);
        }
        Expression elseExp = caseExpression.getElseExpression();
        if (elseExp != null) {
            this.buffer.append("ELSE ");
            elseExp.accept(this);
            this.buffer.append(" ");
        }
        this.buffer.append("END");
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.buffer.append("WHEN ");
        whenClause.getWhenExpression().accept(this);
        this.buffer.append(" THEN ");
        whenClause.getThenExpression().accept(this);
        this.buffer.append(" ");
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.buffer.append(" ALL ");
        allComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.buffer.append(" ANY ");
        anyComparisonExpression.getSubSelect().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat, " || ");
    }

    @Override
    public void visit(Matches matches) {
        this.visitOldOracleJoinBinaryExpression(matches, " @@ ");
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd, " & ");
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr, " | ");
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor, " ^ ");
    }

    @Override
    public void visit(CastExpression cast) {
        if (cast.isUseCastKeyword()) {
            this.buffer.append("CAST(");
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append(" AS ");
            this.buffer.append(cast.getType());
            this.buffer.append(")");
        } else {
            this.buffer.append(cast.getLeftExpression());
            this.buffer.append("::");
            this.buffer.append(cast.getType());
        }
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo, " % ");
    }

    @Override
    public void visit(AnalyticExpression aexpr) {
        this.buffer.append(aexpr.toString());
    }

    @Override
    public void visit(ExtractExpression eexpr) {
        this.buffer.append(eexpr.toString());
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        Iterator<ExpressionList> it = multiExprList.getExprList().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(IntervalExpression iexpr) {
        this.buffer.append(iexpr.toString());
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
        this.buffer.append(jdbcNamedParameter.toString());
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        this.buffer.append(oexpr.toString());
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr, " " + rexpr.getStringExpression() + " ");
    }
}

