/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.schema;

import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.IntoTableVisitor;
import net.sf.jsqlparser.statement.select.Pivot;

public class Table
implements FromItem {
    private String schemaName;
    private String name;
    private Alias alias;
    private Pivot pivot;

    public Table() {
    }

    public Table(String name) {
        this.name = name;
    }

    public Table(String schemaName, String name) {
        this.schemaName = schemaName;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public String getWholeTableName() {
        String tableWholeName = null;
        if (this.name == null) {
            return null;
        }
        tableWholeName = this.schemaName != null ? this.schemaName + "." + this.name : this.name;
        return tableWholeName;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    public void accept(IntoTableVisitor intoTableVisitor) {
        intoTableVisitor.visit(this);
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    public String toString() {
        return this.getWholeTableName() + (this.pivot != null ? " " + this.pivot : "") + (this.alias != null ? this.alias.toString() : "");
    }
}

