/*
 * Decompiled with CFR 0.152.
 */
package sortpom;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import sortpom.SortPomImpl;
import sortpom.exception.ExceptionHandler;
import sortpom.exception.FailureException;
import sortpom.logger.MavenLogger;
import sortpom.logger.SortPomLogger;
import sortpom.parameter.PluginParameters;
import sortpom.parameter.PluginParametersBuilder;

public class SortMojo
extends AbstractMojo {
    private File pomFile;
    private boolean createBackupFile;
    private String backupFileExtension;
    private String encoding;
    private String lineSeparator;
    private boolean expandEmptyElements;
    private boolean keepBlankLines;
    private int nrOfIndentSpace;
    private boolean indentBlankLines;
    private String predefinedSortOrder;
    private String sortOrderFile;
    private String sortDependencies;
    private String sortPlugins;
    private boolean sortProperties;
    private boolean skip;
    private final SortPomImpl sortPomImpl = new SortPomImpl();

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping sortpom");
        } else {
            this.setup();
            this.sortPom();
        }
    }

    public void setup() throws MojoFailureException {
        try {
            PluginParameters pluginParameters = new PluginParametersBuilder().setPomFile(this.pomFile).setBackupInfo(this.createBackupFile, this.backupFileExtension).setEncoding(this.encoding).setFormatting(this.lineSeparator, this.expandEmptyElements, this.keepBlankLines).setIndent(this.nrOfIndentSpace, this.indentBlankLines).setSortOrder(this.sortOrderFile, this.predefinedSortOrder).setSortEntities(this.sortDependencies, this.sortPlugins, this.sortProperties).createPluginParameters();
            this.sortPomImpl.setup((SortPomLogger)new MavenLogger(this.getLog()), pluginParameters);
        }
        catch (FailureException fex) {
            new ExceptionHandler(fex).throwMojoFailureException();
        }
    }

    private void sortPom() throws MojoFailureException {
        try {
            this.sortPomImpl.sortPom();
        }
        catch (FailureException fex) {
            new ExceptionHandler(fex).throwMojoFailureException();
        }
    }
}

