/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Record;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class ArrayRecord
implements Record {
    private static final int STRING_MAX_LENTH = 0x800000;
    private static final long DATETIME_MAX_TICKS = 253402271999000L;
    private static final long DATETIME_MIN_TICKS = -62135798400000L;
    private Column[] columns;
    private final Object[] values;
    private static final String STRING_CHARSET = "UTF-8";
    private HashMap<String, Integer> nameMap = new HashMap();

    public ArrayRecord(Column[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.nameMap.put(columns[i].getName(), i);
        }
    }

    @Override
    public int getColumnCount() {
        return this.values.length;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void set(int idx, Object value) {
        switch (this.columns[idx].getType()) {
            case STRING: {
                if (value instanceof String) {
                    this.setString(idx, (String)value);
                    break;
                }
                this.setString(idx, (byte[])value);
                break;
            }
            case BIGINT: {
                this.setBigint(idx, (Long)value);
                break;
            }
            case BOOLEAN: {
                this.setBoolean(idx, (Boolean)value);
                break;
            }
            case DOUBLE: {
                this.setDouble(idx, (Double)value);
                break;
            }
            case DATETIME: {
                this.setDatetime(idx, (Date)value);
                break;
            }
            case DECIMAL: {
                this.setDecimal(idx, (BigDecimal)value);
            }
        }
    }

    @Override
    public Object get(int idx) {
        return this.values[idx];
    }

    @Override
    public void set(String columnName, Object value) {
        this.set(this.getColumnIndex(columnName), value);
    }

    @Override
    public Object get(String columnName) {
        return this.values[this.getColumnIndex(columnName)];
    }

    @Override
    public void setBigint(int idx, Long value) {
        if (value != null && (value > Long.MAX_VALUE || value <= Long.MIN_VALUE)) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
        this.values[idx] = value;
    }

    @Override
    public Long getBigint(int idx) {
        return (Long)this.get(idx);
    }

    @Override
    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getColumnIndex(columnName), value);
    }

    @Override
    public Long getBigint(String columnName) {
        return (Long)this.get(columnName);
    }

    @Override
    public void setDouble(int idx, Double value) {
        this.values[idx] = value;
    }

    @Override
    public Double getDouble(int idx) {
        return (Double)this.get(idx);
    }

    @Override
    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getColumnIndex(columnName), value);
    }

    @Override
    public Double getDouble(String columnName) {
        return (Double)this.get(columnName);
    }

    @Override
    public void setBoolean(int idx, Boolean value) {
        this.values[idx] = value;
    }

    @Override
    public Boolean getBoolean(int idx) {
        return (Boolean)this.get(idx);
    }

    @Override
    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getColumnIndex(columnName), value);
    }

    @Override
    public Boolean getBoolean(String columnName) {
        return (Boolean)this.get(columnName);
    }

    @Override
    public void setDatetime(int idx, Date value) {
        if (value != null && (value.getTime() > 253402271999000L || value.getTime() < -62135798400000L)) {
            throw new IllegalArgumentException("InvalidData: Datetime out of range.");
        }
        this.values[idx] = value;
    }

    @Override
    public Date getDatetime(int idx) {
        return (Date)this.get(idx);
    }

    @Override
    public void setDatetime(String columnName, Date value) {
        this.setDatetime(this.getColumnIndex(columnName), value);
    }

    @Override
    public Date getDatetime(String columnName) {
        return (Date)this.get(columnName);
    }

    @Override
    public void setDecimal(int idx, BigDecimal value) {
        this.values[idx] = value;
    }

    @Override
    public BigDecimal getDecimal(int idx) {
        return (BigDecimal)this.get(idx);
    }

    @Override
    public void setDecimal(String columnName, BigDecimal value) {
        this.setDecimal(this.getColumnIndex(columnName), value);
    }

    @Override
    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, String value) {
        if (value == null) {
            this.values[idx] = value;
            return;
        }
        try {
            if (value.length() * 6 > 0x800000 && value.getBytes(STRING_CHARSET).length > 0x800000) {
                throw new IllegalArgumentException("InvalidData: The string's length is more than 8M.");
            }
            this.values[idx] = value;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public String getString(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            try {
                return new String((byte[])o, STRING_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return (String)this.get(idx);
    }

    @Override
    public void setString(String columnName, String value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, byte[] value) {
        if (value == null) {
            this.values[idx] = value;
            return;
        }
        if (value.length > 0x800000) {
            throw new IllegalArgumentException("InvalidData: The string's length is more than 8M.");
        }
        this.values[idx] = value;
    }

    @Override
    public void setString(String columnName, byte[] value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public byte[] getBytes(int idx) {
        Object o = this.get(idx);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                return ((String)o).getBytes(STRING_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        return (byte[])this.get(idx);
    }

    @Override
    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    @Override
    public void set(Object[] values) {
        if (values == null || this.columns.length != values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Override
    public Object[] toArray() {
        return this.values;
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }
}

