/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.remoting.netty;

import com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.alibaba.rocketmq.remoting.InvokeCallback;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.common.Pair;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import com.alibaba.rocketmq.remoting.common.ServiceThread;
import com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyRemotingAbstract {
    private static final Logger plog = LoggerFactory.getLogger((String)"RocketmqRemoting");
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentHashMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap(256);
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessor;
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyEventExecuter nettyEventExecuter = new NettyEventExecuter();

    public abstract ChannelEventListener getChannelEventListener();

    public abstract RPCHook getRPCHook();

    public void putNettyEvent(NettyEvent event) {
        this.nettyEventExecuter.putNettyEvent(event);
    }

    public NettyRemotingAbstract(int permitsOneway, int permitsAsync) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
    }

    public void processRequestCommand(final ChannelHandlerContext ctx, final RemotingCommand cmd) {
        Pair<NettyRequestProcessor, ExecutorService> pair;
        Pair<NettyRequestProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        Pair<NettyRequestProcessor, ExecutorService> pair2 = pair = null == matched ? this.defaultRequestProcessor : matched;
        if (pair != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            RPCHook rpcHook = NettyRemotingAbstract.this.getRPCHook();
                            if (rpcHook != null) {
                                rpcHook.doBeforeRequest(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd);
                            }
                            RemotingCommand response = ((NettyRequestProcessor)pair.getObject1()).processRequest(ctx, cmd);
                            if (rpcHook != null) {
                                rpcHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd, response);
                            }
                            if (!cmd.isOnewayRPC() && response != null) {
                                response.setOpaque(cmd.getOpaque());
                                response.markResponseType();
                                try {
                                    ctx.writeAndFlush((Object)response);
                                }
                                catch (Throwable e) {
                                    plog.error("process request over, but response failed", e);
                                    plog.error(cmd.toString());
                                    plog.error(response.toString());
                                }
                            }
                        }
                        catch (Throwable e) {
                            plog.error("process request exception", e);
                            plog.error(cmd.toString());
                            if (cmd.isOnewayRPC()) break block7;
                            RemotingCommand response = RemotingCommand.createResponseCommand(1, RemotingHelper.exceptionSimpleDesc(e));
                            response.setOpaque(cmd.getOpaque());
                            ctx.writeAndFlush((Object)response);
                        }
                    }
                }
            };
            try {
                pair.getObject2().submit(run);
            }
            catch (RejectedExecutionException e) {
                if (System.currentTimeMillis() % 10000L == 0L) {
                    plog.warn(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getObject2().toString() + " request code: " + cmd.getCode());
                }
                if (!cmd.isOnewayRPC()) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(2, "too many requests and system thread pool busy, please try another server");
                    response.setOpaque(cmd.getOpaque());
                    ctx.writeAndFlush((Object)response);
                }
            }
        } else {
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(3, error);
            response.setOpaque(cmd.getOpaque());
            ctx.writeAndFlush((Object)response);
            plog.error(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + error);
        }
    }

    public void processResponseCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        final ResponseFuture responseFuture = this.responseTable.get(cmd.getOpaque());
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            responseFuture.release();
            this.responseTable.remove(cmd.getOpaque());
            if (responseFuture.getInvokeCallback() != null) {
                boolean runInThisThread = false;
                ExecutorService executor = this.getCallbackExecutor();
                if (executor != null) {
                    try {
                        executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    responseFuture.executeInvokeCallback();
                                }
                                catch (Throwable e) {
                                    plog.warn("excute callback in executor exception, and callback throw", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        runInThisThread = true;
                        plog.warn("excute callback in executor exception, maybe executor busy", (Throwable)e);
                    }
                } else {
                    runInThisThread = true;
                }
                if (runInThisThread) {
                    try {
                        responseFuture.executeInvokeCallback();
                    }
                    catch (Throwable e) {
                        plog.warn("executeInvokeCallback Exception", e);
                    }
                }
            } else {
                responseFuture.putResponse(cmd);
            }
        } else {
            plog.warn("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            plog.warn(cmd.toString());
        }
    }

    public void processMessageReceived(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
        RemotingCommand cmd = msg;
        if (cmd != null) {
            switch (cmd.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(ctx, cmd);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(ctx, cmd);
                    break;
                }
            }
        }
    }

    public abstract ExecutorService getCallbackExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResponseTable() {
        Iterator<Map.Entry<Integer, ResponseFuture>> it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ResponseFuture> next = it.next();
            ResponseFuture rep = next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            it.remove();
            try {
                rep.executeInvokeCallback();
            }
            catch (Throwable e) {
                plog.warn("scanResponseTable, operationComplete Exception", e);
            }
            finally {
                rep.release();
            }
            plog.warn("remove timeout request, " + rep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        try {
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, null, null);
            this.responseTable.put(request.getOpaque(), responseFuture);
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    NettyRemotingAbstract.this.responseTable.remove(request.getOpaque());
                    responseFuture.setCause(f.cause());
                    responseFuture.putResponse(null);
                    plog.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                    plog.warn(request.toString());
                }
            });
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseChannelRemoteAddr(channel), timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            this.responseTable.remove(request.getOpaque());
        }
    }

    public void invokeAsyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, invokeCallback, once);
            this.responseTable.put(request.getOpaque(), responseFuture);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (f.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        responseFuture.setSendRequestOK(false);
                        responseFuture.putResponse(null);
                        NettyRemotingAbstract.this.responseTable.remove(request.getOpaque());
                        try {
                            responseFuture.executeInvokeCallback();
                        }
                        catch (Throwable e) {
                            plog.warn("excute callback in writeAndFlush addListener, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                        plog.warn("send a request command to channel <{}> failed.", (Object)RemotingHelper.parseChannelRemoteAddr(channel));
                        plog.warn(request.toString());
                    }
                });
            }
            catch (Exception e) {
                responseFuture.release();
                plog.warn("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception", (Throwable)e);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            plog.warn(info);
            plog.warn(request.toString());
            throw new RemotingTimeoutException(info);
        }
    }

    public void invokeOnewayImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        request.markOnewayRPC();
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        once.release();
                        if (!f.isSuccess()) {
                            plog.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                            plog.warn(request.toString());
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                plog.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String info = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            plog.warn(info);
            plog.warn(request.toString());
            throw new RemotingTimeoutException(info);
        }
    }

    class NettyEventExecuter
    extends ServiceThread {
        private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();
        private final int MaxSize = 10000;

        NettyEventExecuter() {
        }

        public void putNettyEvent(NettyEvent event) {
            if (this.eventQueue.size() <= 10000) {
                this.eventQueue.add(event);
            } else {
                plog.warn("event queue size[{}] enough, so drop this event {}", (Object)this.eventQueue.size(), (Object)event.toString());
            }
        }

        @Override
        public void run() {
            plog.info(this.getServiceName() + " service started");
            ChannelEventListener listener = NettyRemotingAbstract.this.getChannelEventListener();
            while (!this.isStoped()) {
                try {
                    NettyEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null || listener == null) continue;
                    switch (event.getType()) {
                        case IDLE: {
                            listener.onChannelIdle(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    plog.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            plog.info(this.getServiceName() + " service end");
        }

        @Override
        public String getServiceName() {
            return NettyEventExecuter.class.getSimpleName();
        }
    }
}

