/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.p3.cg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.p3.cg.ColumnData;
import org.jeecgframework.p3.cg.TableInfo;
import org.jeecgframework.p3.cg.def.CodeResourceUtil;
import org.jeecgframework.p3.cg.def.TableConvert;

public class CreateBean {
    private Connection connection = null;
    static String url;
    static String username;
    static String password;
    static String rt;
    String SQLTables = "show tables";
    private String method;
    private String argv;
    static String selectStr;
    static String from;

    static {
        rt = "\r\t";
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        selectStr = "select ";
        from = " from ";
    }

    public void setMysqlInfo(String url, String username, String password) {
        CreateBean.url = url;
        CreateBean.username = username;
        CreateBean.password = password;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, username, password);
    }

    public List<String> getTables() throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(this.SQLTables);
        ResultSet rs = ps.executeQuery();
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            String tableName = rs.getString(1).toUpperCase();
            list.add(tableName);
        }
        rs.close();
        ps.close();
        con.close();
        return list;
    }

    public List<TableInfo> getTablesInfo() throws SQLException {
        String SQLTables = "select t.TABLE_NAME ,t.TABLE_COMMENT from information_schema.tables  t  WHERE table_schema = '" + CodeResourceUtil.getDATABASE_NAME() + "'";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(SQLTables);
        ResultSet rs = ps.executeQuery();
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        while (rs.next()) {
            TableInfo tableInfo = new TableInfo();
            String tableName = rs.getString(1);
            String tableComment = rs.getString(2);
            tableInfo.setTableName(tableName);
            tableInfo.setTableComment(tableComment);
            list.add(tableInfo);
        }
        rs.close();
        ps.close();
        con.close();
        return list;
    }

    public Map<String, String> getTableCommentMap() throws SQLException {
        String SQLTables = "select t.TABLE_NAME ,t.TABLE_COMMENT from information_schema.tables  t  WHERE table_schema = '" + CodeResourceUtil.getDATABASE_NAME() + "'";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(SQLTables);
        ResultSet rs = ps.executeQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            String tableName = rs.getString(1).toUpperCase();
            String tableComment = rs.getString(2);
            map.put(tableName, tableComment);
        }
        rs.close();
        ps.close();
        con.close();
        return map;
    }

    public List<ColumnData> getColumnDatas(String tableName) throws SQLException {
        String SQLColumns = "select column_name ,data_type,column_comment,0,0,character_maximum_length,is_nullable nullable,COLUMN_KEY from information_schema.columns where table_name =  '" + tableName + "' " + "and table_schema =  '" + CodeResourceUtil.DATABASE_NAME + "'";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(SQLColumns);
        ArrayList<ColumnData> columnList = new ArrayList<ColumnData>();
        ResultSet rs = ps.executeQuery();
        StringBuffer str = new StringBuffer();
        StringBuffer getset = new StringBuffer();
        while (rs.next()) {
            String name = rs.getString(1);
            String type = rs.getString(2);
            String comment = rs.getString(3);
            String precision = rs.getString(4);
            String scale = rs.getString(5);
            String charmaxLength = rs.getString(6) == null ? "" : rs.getString(6);
            String nullable = TableConvert.getNullAble(rs.getString(7));
            String columnKey = rs.getString(8) == null ? "" : rs.getString(8);
            String dataType = this.getType(type, precision, scale);
            String domainPropertyName = this.getcolumnNameToDomainPropertyName(name);
            String jdbcType = this.getJdbcType(type, precision, scale);
            ColumnData cd = new ColumnData();
            cd.setColumnName(name);
            cd.setDataType(dataType);
            cd.setJdbcType(jdbcType);
            cd.setColumnType(rs.getString(2));
            if (comment == null || "".equals(comment.trim())) {
                cd.setColumnComment(name);
            } else {
                cd.setColumnComment(comment);
            }
            cd.setPrecision(precision);
            cd.setScale(scale);
            cd.setCharmaxLength(charmaxLength);
            cd.setNullable(nullable);
            cd.setDomainPropertyName(domainPropertyName);
            cd.setColumnKey(columnKey);
            columnList.add(cd);
        }
        this.argv = str.toString();
        this.method = getset.toString();
        rs.close();
        ps.close();
        con.close();
        return columnList;
    }

    public List<ColumnData> getColumnKeyDatas(List<ColumnData> columnList) {
        ArrayList<ColumnData> columnKeyList = new ArrayList<ColumnData>();
        if (columnList != null && columnList.size() > 0) {
            for (ColumnData column : columnList) {
                if (!"PRI".equals(column.getColumnKey())) continue;
                columnKeyList.add(column);
            }
        }
        return columnKeyList;
    }

    public String getColumnKeyParam(List<ColumnData> columnList) {
        String str;
        StringBuffer sb = new StringBuffer("");
        if (columnList != null && columnList.size() > 0) {
            for (ColumnData column : columnList) {
                sb.append(column.getDataType()).append(" ").append(column.getDomainPropertyName()).append(",");
            }
        }
        if ((str = sb.toString()).length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getColumnKeyUseParam(List<ColumnData> columnList) {
        String str;
        StringBuffer sb = new StringBuffer("");
        if (columnList != null && columnList.size() > 0) {
            for (ColumnData column : columnList) {
                sb.append(column.getDomainPropertyName()).append(",");
            }
        }
        if ((str = sb.toString()).length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String getBeanFeilds(String tableName, String className) throws SQLException {
        List<ColumnData> dataList = this.getColumnDatas(tableName);
        StringBuffer str = new StringBuffer();
        StringBuffer getset = new StringBuffer();
        for (ColumnData d : dataList) {
            String name = d.getDomainPropertyName();
            String type = d.getDataType();
            String comment = d.getColumnComment();
            String maxChar = name.substring(0, 1).toUpperCase();
            str.append("\r\t").append("/**");
            str.append("\r\t").append(" *").append(comment);
            str.append("\r\t").append(" */");
            str.append("\r\t").append("private ").append(String.valueOf(type) + " ").append(name).append(";");
            String method = String.valueOf(maxChar) + name.substring(1, name.length());
            getset.append("\r\t").append("public ").append(String.valueOf(type) + " ").append("get" + method + "() {\r\t");
            getset.append("    return this.").append(name).append(";\r\t}");
            getset.append("\r\t").append("public void ").append("set" + method + "(" + type + " " + name + ") {\r\t");
            getset.append("    this." + name + "=").append(name).append(";\r\t}");
        }
        this.argv = str.toString();
        this.method = getset.toString();
        return String.valueOf(this.argv) + this.method;
    }

    public String getQueryBeanFeilds(String tableName, String className) throws SQLException {
        List<ColumnData> dataList = this.getColumnDatas(tableName);
        StringBuffer str = new StringBuffer();
        StringBuffer getset = new StringBuffer();
        for (ColumnData d : dataList) {
            String name = d.getDomainPropertyName();
            String type = d.getDataType();
            String comment = d.getColumnComment();
            String maxChar = name.substring(0, 1).toUpperCase();
            str.append("\r\t").append("/**");
            str.append("\r\t").append(" *").append(comment);
            str.append("\r\t").append(" */");
            str.append("\r\t").append("private ").append(String.valueOf(type) + " ").append(name).append(";");
            String method = String.valueOf(maxChar) + name.substring(1, name.length());
            getset.append("\r\t").append("public ").append(String.valueOf(type) + " ").append("get" + method + "() {\r\t");
            getset.append("    return this.").append(name).append(";\r\t}");
            getset.append("\r\t").append("public void ").append("set" + method + "(" + type + " " + name + ") {\r\t");
            getset.append("    this." + name + "=").append(name).append(";\r\t}");
        }
        this.argv = str.toString();
        this.method = getset.toString();
        return String.valueOf(this.argv) + this.method;
    }

    public String getJdbcType(String dataType, String precision, String scale) {
        dataType = (dataType = dataType.toLowerCase()).contains("int") ? "INTEGER" : (dataType.contains("date") ? "TIMESTAMP" : (dataType.contains("time") ? "TIMESTAMP" : (dataType.contains("clob") ? "VARCHAR" : (dataType.contains("text") ? "VARCHAR" : dataType.toUpperCase()))));
        return dataType;
    }

    public String getType(String dataType, String precision, String scale) {
        dataType = (dataType = dataType.toLowerCase()).contains("char") ? "String" : (dataType.contains("text") ? "String" : (dataType.contains("bigint") ? "Long" : (dataType.contains("int") ? "Integer" : (dataType.contains("float") ? "Float" : (dataType.contains("double") ? "Double" : (dataType.contains("number") ? (StringUtils.isNotBlank((String)scale) && Integer.parseInt(scale) > 0 ? "BigDecimal" : (StringUtils.isNotBlank((String)precision) && Integer.parseInt(precision) > 6 ? "Long" : "Integer")) : (dataType.contains("decimal") ? "BigDecimal" : (dataType.contains("date") ? "Date" : (dataType.contains("time") ? "Date" : (dataType.contains("clob") ? "Clob" : "Object"))))))))));
        return dataType;
    }

    public void getPackage(int type, String createPath, String content, String packageName, String className, String extendsClassName, String ... importName) throws Exception {
        if (packageName == null) {
            packageName = "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("package ").append(packageName).append(";\r");
        sb.append("\r");
        int i = 0;
        while (i < importName.length) {
            sb.append("import ").append(importName[i]).append(";\r");
            ++i;
        }
        sb.append("\r");
        sb.append("/**\r *  entity. @author wolf Date:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\r */");
        sb.append("\r");
        sb.append("\rpublic class ").append(className);
        if (extendsClassName != null) {
            sb.append(" extends ").append(extendsClassName);
        }
        if (type == 1) {
            sb.append(" ").append("implements java.io.Serializable {\r");
        } else {
            sb.append(" {\r");
        }
        sb.append("\r\t");
        sb.append("private static final long serialVersionUID = 1L;\r\t");
        String temp = className.substring(0, 1).toLowerCase();
        temp = String.valueOf(temp) + className.substring(1, className.length());
        if (type == 1) {
            sb.append("private " + className + " " + temp + "; // entity ");
        }
        sb.append(content);
        sb.append("\r}");
        System.out.println(sb.toString());
        this.createFile(createPath, "", sb.toString());
    }

    public String getTablesNameToClassName(String tableName) {
        String[] split = (tableName = tableName.toLowerCase()).split("_");
        if (split.length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < split.length) {
                String tempTableName = String.valueOf(split[i].substring(0, 1).toUpperCase()) + split[i].substring(1, split[i].length());
                sb.append(tempTableName);
                ++i;
            }
            return sb.toString();
        }
        String tempTables = String.valueOf(split[0].substring(0, 1).toUpperCase()) + split[0].substring(1, split[0].length());
        return tempTables;
    }

    public String getTablesASName(String tableName) {
        String[] split = (tableName = tableName.toLowerCase()).split("_");
        if (split.length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < split.length) {
                String tempTableName = split[i].substring(0, 1).toLowerCase();
                sb.append(tempTableName);
                ++i;
            }
            return sb.toString();
        }
        String tempTables = split[0].substring(0, 1).toLowerCase();
        return tempTables;
    }

    public String getcolumnNameToDomainPropertyName(String columnName) {
        String[] split = (columnName = columnName.toLowerCase()).split("_");
        if (split.length > 1) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < split.length) {
                String tempTableName = String.valueOf(split[i].substring(0, 1).toUpperCase()) + split[i].substring(1, split[i].length());
                sb.append(tempTableName);
                ++i;
            }
            columnName = sb.toString();
            columnName = String.valueOf(columnName.substring(0, 1).toLowerCase()) + columnName.substring(1, columnName.length());
            return columnName;
        }
        columnName = String.valueOf(split[0].substring(0, 1).toLowerCase()) + split[0].substring(1, split[0].length());
        return columnName;
    }

    public void createFile(String path, String fileName, String str) throws IOException {
        FileWriter writer = new FileWriter(new File(String.valueOf(path) + fileName));
        writer.write(new String(str.getBytes("utf-8")));
        writer.flush();
        writer.close();
    }

    public Map<String, Object> getAutoCreateSql(String tableName) throws Exception {
        HashMap<String, Object> sqlMap = new HashMap<String, Object>();
        List<ColumnData> columnDatas = this.getColumnDatas(tableName);
        String columns = null;
        try {
            columns = this.getColumnSplit(columnDatas);
        }
        catch (Exception e) {
            throw new Exception("\u9519\u8bef\u63d0\u9192\uff1a\u8bf7\u786e\u8ba4\uff0c\u6570\u636e\u5e93\u914d\u7f6e\u662f\u5426\u9519\u8bef\uff0c\u6216\u8005\u8868\u540d\u662f\u5426\u5b58\u5728!!!");
        }
        String[] columnList = this.getColumnList(columns);
        String columnFields = this.getColumnFields(columns);
        String insert = "INSERT INTO " + tableName + "(" + columns.replaceAll("\\|", ",") + ")\n values(#{" + columns.replaceAll("\\|", "},#{") + "})";
        String update = this.getUpdateSql(tableName, columnList);
        String updateSelective = this.getUpdateSelectiveSql(tableName, columnDatas);
        String selectById = this.getSelectByIdSql(tableName, columnList);
        String delete = this.getDeleteSql(tableName, columnList);
        sqlMap.put("columnList", columnList);
        sqlMap.put("columnFields", columnFields);
        sqlMap.put("insert", insert);
        sqlMap.put("update", update);
        sqlMap.put("delete", delete);
        sqlMap.put("updateSelective", updateSelective);
        sqlMap.put("selectById", selectById);
        return sqlMap;
    }

    public String getDeleteSql(String tableName, String[] columnsList) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("delete ");
        sb.append("\t from ").append(tableName).append(" where ");
        sb.append(columnsList[0]).append(" = #{").append(columnsList[0]).append("}");
        return sb.toString();
    }

    public String getSelectByIdSql(String tableName, String[] columnsList) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("select <include refid=\"Base_Column_List\" /> \n");
        sb.append("\t from ").append(tableName).append(" where ");
        sb.append(columnsList[0]).append(" = #{").append(columnsList[0]).append("}");
        return sb.toString();
    }

    public String getColumnFields(String columns) throws SQLException {
        String fields = columns;
        if (fields != null && !"".equals(fields)) {
            fields = fields.replaceAll("[|]", ",");
        }
        return fields;
    }

    public String[] getColumnList(String columns) throws SQLException {
        String[] columnList = columns.split("[|]");
        return columnList;
    }

    public String getUpdateSql(String tableName, String[] columnsList) throws SQLException {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < columnsList.length) {
            String column = columnsList[i];
            if (!"CREATETIME".equals(column.toUpperCase())) {
                if ("UPDATETIME".equals(column.toUpperCase())) {
                    sb.append(String.valueOf(column) + "=now()");
                } else {
                    sb.append(String.valueOf(column) + "=#{" + column + "}");
                }
                if (i + 1 < columnsList.length) {
                    sb.append(",");
                }
            }
            ++i;
        }
        String update = "update " + tableName + " set " + sb.toString() + " where " + columnsList[0] + "=#{" + columnsList[0] + "}";
        return update;
    }

    public String getUpdateSelectiveSql(String tableName, List<ColumnData> columnList) throws SQLException {
        StringBuffer sb = new StringBuffer();
        ColumnData cd = columnList.get(0);
        sb.append("\t<trim  suffixOverrides=\",\" >\n");
        int i = 1;
        while (i < columnList.size()) {
            ColumnData data = columnList.get(i);
            String columnName = data.getColumnName();
            sb.append("\t<if test=\"").append(columnName).append(" != null ");
            if ("String" == data.getDataType()) {
                sb.append(" and ").append(columnName).append(" != ''");
            }
            sb.append(" \">\n\t\t");
            sb.append(String.valueOf(columnName) + "=#{" + columnName + "},\n");
            sb.append("\t</if>\n");
            ++i;
        }
        sb.append("\t</trim>");
        String update = "update " + tableName + " set \n" + sb.toString() + " where " + cd.getColumnName() + "=#{" + cd.getColumnName() + "}";
        return update;
    }

    public String getColumnSplit(List<ColumnData> columnList) throws SQLException {
        StringBuffer commonColumns = new StringBuffer();
        for (ColumnData data : columnList) {
            commonColumns.append(String.valueOf(data.getColumnName()) + "|");
        }
        return commonColumns.delete(commonColumns.length() - 1, commonColumns.length()).toString();
    }
}

