/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.p3.cg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jeecgframework.p3.cg.def.CodeResourceUtil;
import org.jeecgframework.p3.cg.factory.CodeGenerateFactory;

public class CommonPageParser {
    private static VelocityEngine ve;
    private static final String CONTENT_ENCODING = "UTF-8";
    private static final Log log;
    private static boolean isReplace;

    static {
        log = LogFactory.getLog(CommonPageParser.class);
        isReplace = true;
        try {
            String templateBasePath = String.valueOf(CodeGenerateFactory.getProjectPath()) + CodeResourceUtil.getConfigInfo("templatepath_vm");
            Properties properties = new Properties();
            properties.setProperty("resource.loader", "file");
            properties.setProperty("file.resource.loader.description", "Velocity File Resource Loader");
            properties.setProperty("file.resource.loader.path", templateBasePath);
            properties.setProperty("file.resource.loader.cache", "true");
            properties.setProperty("file.resource.loader.modificationCheckInterval", "30");
            properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
            properties.setProperty("runtime.log.logsystem.log4j.logger", "org.apache.velocity");
            properties.setProperty("directive.set.null.allowed", "true");
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(properties);
            ve = velocityEngine;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static void WriterPage(VelocityContext context, String templateName, String fileDirPath, String targetFile) {
        try {
            String workspasePath = CodeResourceUtil.getConfigInfo("workspace_path");
            File file = new File(String.valueOf(workspasePath) + File.separator + fileDirPath + File.separator + targetFile);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            } else if (isReplace) {
                log.info((Object)("\u66ff\u6362\u6587\u4ef6:" + file.getAbsolutePath()));
            }
            Template template = ve.getTemplate(templateName, CONTENT_ENCODING);
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, CONTENT_ENCODING));
            template.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
            fos.close();
            log.info((Object)("\u751f\u6210\u6587\u4ef6\uff1a" + file.getAbsolutePath()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

