/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.web;

import com.alibaba.fastjson.JSON;
import com.jeecg.chat.entity.ChatMessage;
import com.jeecg.chat.entity.P3ImTSBaseUser;
import com.jeecg.chat.entity.SocketUser;
import com.jeecg.chat.service.ChatMessageHistoryService;
import com.jeecg.chat.service.ImService;
import com.jeecg.chat.service.impl.UserManager;
import java.io.IOException;
import java.util.List;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.utils.common.ApplicationContextUtil;
import org.springframework.context.ApplicationContext;

@ServerEndpoint(value="/WebSocket/{id}")
public class WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(WebSocket.class);
    private static int onlineCount = 0;
    private ChatMessageHistoryService chatMessageHistoryService;
    private ImService imService;

    public WebSocket() {
        ApplicationContext ctx = ApplicationContextUtil.getContext();
        if (ctx.containsBean("chatMessageHistoryService")) {
            this.chatMessageHistoryService = (ChatMessageHistoryService)ctx.getBean("chatMessageHistoryService");
        }
        if (ctx.containsBean("imService")) {
            this.imService = (ImService)ctx.getBean("imService");
        }
    }

    @OnOpen
    public void onOpen(@PathParam(value="id") String id, Session session) {
        SocketUser socketUser = new SocketUser();
        socketUser.setSession(session);
        socketUser.setUserId(id);
        UserManager.getInstance().addUser(socketUser);
        logger.info("\u6709\u65b0\u8fde\u63a5\u52a0\u5165\uff01\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a" + UserManager.getInstance().getOnlineCount());
    }

    @OnClose
    public void close(Session session, @PathParam(value="id") String id) {
        SocketUser user = new SocketUser();
        user.setSession(session);
        user.setUserId(id);
        UserManager.getInstance().removeUser(user);
        logger.info("\u5f53\u524d\u5728\u7ebf\u7528\u6237\uff1a" + UserManager.getInstance().getOnlineCount());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        logger.info("\u6765\u81ea\u5ba2\u6237\u7aef\u7684\u6d88\u606f:" + message);
        ChatMessage chatMessage = (ChatMessage)JSON.parseObject((String)message, ChatMessage.class);
        this.chatMessageHistoryService.insert(chatMessage);
        if ("friend".equals(chatMessage.getTo().getType())) {
            this.sendToFriend(chatMessage);
        } else if ("group".equals(chatMessage.getTo().getType())) {
            this.sendTOGroup(chatMessage);
        }
    }

    private void sendToFriend(ChatMessage chatMessage) {
        try {
            if (UserManager.getInstance().getUser(chatMessage.getTo().getId()).getSession() != null) {
                UserManager.getInstance().getUser(chatMessage.getTo().getId()).getSession().getBasicRemote().sendText(JSON.toJSONString((Object)chatMessage));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendTOGroup(ChatMessage chatMessage) {
        List<P3ImTSBaseUser> imTSBaseUsers = this.imService.getUsers();
        P3ImTSBaseUser myuser = null;
        for (P3ImTSBaseUser user : imTSBaseUsers) {
            if (!chatMessage.getMine().getId().equals(user.getId())) continue;
            myuser = user;
        }
        for (P3ImTSBaseUser user : imTSBaseUsers) {
            if (!myuser.getMaindepartid().equals(user.getMaindepartid()) || myuser.getId().equals(user.getId())) continue;
            try {
                if (UserManager.getInstance().getUser(user.getId()).getSession() == null) continue;
                UserManager.getInstance().getUser(user.getId()).getSession().getBasicRemote().sendText(JSON.toJSONString((Object)chatMessage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        logger.info("\u53d1\u751f\u9519\u8bef");
        logger.debug(error.getMessage());
    }
}

