/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.chat.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.chat.entity.P3ImTSBaseUser;
import com.jeecg.chat.entity.P3ImTSDepart;
import com.jeecg.chat.service.ImService;
import com.jeecg.chat.util.ChatResourceConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.author.LoginUser;
import org.jeecgframework.p3.core.util.plugin.ContextHolderUtils;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/chat/imController"})
public class ImController
extends BaseController {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String localPath = "D://upFiles";
    @Autowired
    private ImService imService;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public void index(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        try {
            VelocityContext velocityContext = new VelocityContext();
            String viewName = "chat/index.vm";
            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(params={"getMembers"}, method={RequestMethod.GET, RequestMethod.POST})
    public JSONObject getMembers(HttpServletResponse response, HttpServletRequest request) throws Exception {
        List<P3ImTSBaseUser> imTSUsers = this.imService.getUsers();
        LoginUser u = ContextHolderUtils.getLoginSessionUser();
        JSONArray list = new JSONArray();
        for (P3ImTSBaseUser tsBaseUser : imTSUsers) {
            if (!this.imService.isInThisOrg(u.getDepartid(), tsBaseUser.getMaindepartid())) continue;
            JSONObject json = new JSONObject();
            json.put("username", (Object)tsBaseUser.getRealname());
            json.put("id", (Object)tsBaseUser.getId());
            json.put("avatar", (Object)"http://tp1.sinaimg.cn/1571889140/180/40030060651/1");
            json.put("sign", (Object)tsBaseUser.getUsername());
            list.add((Object)json);
        }
        JSONObject jsonObject = new JSONObject();
        JSONObject data = new JSONObject();
        data.put("list", (Object)list);
        jsonObject.put("data", (Object)data);
        jsonObject.put("members", (Object)(list.size() + 1));
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"");
        return jsonObject;
    }

    @ResponseBody
    @RequestMapping(params={"getUsers"}, method={RequestMethod.GET, RequestMethod.POST})
    public JSONObject getUsers(HttpServletResponse response, HttpServletRequest request) throws Exception {
        LoginUser u = ContextHolderUtils.getLoginSessionUser();
        JSONObject jsonObject = new JSONObject();
        JSONArray groups = new JSONArray();
        JSONObject group = new JSONObject();
        List<P3ImTSBaseUser> imTSUsers = this.imService.getUsers();
        P3ImTSBaseUser imTSBaseUser = new P3ImTSBaseUser();
        int i = 0;
        while (i < imTSUsers.size()) {
            if (imTSUsers.get(i).getId().equals(u.getId())) {
                imTSBaseUser = imTSUsers.get(i);
                imTSUsers.remove(i);
            }
            ++i;
        }
        jsonObject.put("code", (Object)"0");
        jsonObject.put("msg", (Object)"");
        JSONObject jsonObjectData = new JSONObject();
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("username", (Object)u.getRealName());
        jsonObject1.put("id", (Object)u.getId());
        jsonObject1.put("status", (Object)"online");
        jsonObject1.put("sign", (Object)(StringUtils.isEmpty((Object)imTSBaseUser.getImsign()) ? "\u8fd9\u5bb6\u4f19\u5f88\u61d2\u6ca1\u6709\u7b7e\u540d" : imTSBaseUser.getImsign()));
        String basePath = request.getContextPath();
        jsonObject1.put("avatar", (Object)(StringUtils.isEmpty((Object)imTSBaseUser.getPortrait()) ? "content/chat/layui/images/portrait/qq.jpg" : String.valueOf(basePath) + "/chat/imController/showOrDownByurl.do?dbPath=" + imTSBaseUser.getPortrait()));
        jsonObjectData.put("mine", (Object)jsonObject1);
        JSONArray jsonArray1 = new JSONArray();
        List<P3ImTSDepart> departs = this.imService.getDeparts();
        for (P3ImTSDepart depart : departs) {
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put("groupname", (Object)depart.getDepartname());
            jsonObject2.put("id", (Object)depart.getId());
            JSONArray jsonArray = new JSONArray();
            if (this.imService.isInThisOrg(u.getDepartid(), depart.getOrgCode())) {
                group.put("groupname", (Object)depart.getDepartname());
                group.put("id", (Object)depart.getId());
                group.put("avatar", (Object)"content/chat/layui/images/portrait/group.jpg");
                groups.add((Object)group);
            }
            for (P3ImTSBaseUser tsBaseUser : imTSUsers) {
                if (!tsBaseUser.getMaindepartid().equals(depart.getOrgCode())) continue;
                JSONObject json = new JSONObject();
                json.put("username", (Object)tsBaseUser.getRealname());
                json.put("id", (Object)tsBaseUser.getId());
                json.put("avatar", (Object)(StringUtils.isEmpty((Object)tsBaseUser.getPortrait()) ? "content/chat/layui/images/portrait/qq.jpg" : String.valueOf(basePath) + "/chat/imController/showOrDownByurl.do?dbPath=" + tsBaseUser.getPortrait()));
                json.put("sign", (Object)(StringUtils.isEmpty((Object)tsBaseUser.getImsign()) ? "\u8fd9\u5bb6\u4f19\u5f88\u61d2\u6ca1\u6709\u7b7e\u540d" : tsBaseUser.getImsign()));
                jsonArray.add((Object)json);
            }
            jsonObject2.put("list", (Object)jsonArray);
            jsonArray1.add((Object)jsonObject2);
        }
        jsonObjectData.put("friend", (Object)jsonArray1);
        jsonObjectData.put("group", (Object)groups);
        jsonObject.put("data", (Object)jsonObjectData);
        return jsonObject;
    }

    @ResponseBody
    @RequestMapping(params={"getUserid"}, method={RequestMethod.GET, RequestMethod.POST})
    public String getUserid() {
        LoginUser u = ContextHolderUtils.getLoginSessionUser();
        System.out.println("\u5f53\u524d\u767b\u5f55\u4ebaid\u4e3a\uff1a" + u.getId());
        return u.getId();
    }

    @RequestMapping(params={"uploadImage"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject uploadImage(MultipartHttpServletRequest request) {
        JSONObject resultJson = new JSONObject();
        try {
            MultipartFile uploadify = request.getFile("file");
            byte[] bytes = uploadify.getBytes();
            String realFilename = uploadify.getOriginalFilename();
            String fileExtension = realFilename.substring(realFilename.lastIndexOf("."));
            String filename = String.valueOf(System.currentTimeMillis()) + fileExtension;
            StringBuffer path = new StringBuffer();
            path.append(this.localPath);
            path.append(File.separator);
            StringBuffer dbPath = new StringBuffer();
            dbPath.append("chat");
            dbPath.append(File.separator);
            dbPath.append("uploadImage");
            dbPath.append(new SimpleDateFormat(String.valueOf(File.separator) + "YYYY" + File.separator + "MM" + File.separator + "dd").format(new Date()));
            path.append(dbPath.toString());
            String uploadDir = path.toString();
            File dirPath = new File(uploadDir);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            File uploadedFile = new File(String.valueOf(uploadDir) + File.separator + filename);
            FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
            JSONObject jsonObject = new JSONObject();
            String basePath = request.getContextPath();
            jsonObject.put("src", (Object)(String.valueOf(basePath) + "/chat/imController/showOrDownByurl.do?dbPath=" + dbPath.toString() + "/" + filename));
            this.log.info((Object)("\u4e0a\u4f20\u8def\u5f84\u4e3a=" + jsonObject.get((Object)"src")));
            jsonObject.put("name", (Object)filename);
            resultJson.put("code", (Object)0);
            resultJson.put("msg", (Object)"success");
            resultJson.put("data", (Object)jsonObject);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage());
            resultJson.put("code", (Object)1);
            resultJson.put("msg", (Object)("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return resultJson;
    }

    @ResponseBody
    @RequestMapping(params={"uploadFile"})
    public JSONObject uploadFile(MultipartHttpServletRequest request) {
        JSONObject resultJson = new JSONObject();
        try {
            MultipartFile uploadify = request.getFile("file");
            byte[] bytes = uploadify.getBytes();
            String realFilename = uploadify.getOriginalFilename();
            String fileExtension = realFilename.substring(realFilename.lastIndexOf("."));
            String filename = String.valueOf(System.currentTimeMillis()) + fileExtension;
            StringBuffer path = new StringBuffer();
            path.append(this.localPath);
            path.append(File.separator);
            StringBuffer dbPath = new StringBuffer();
            dbPath.append("chat");
            dbPath.append(File.separator);
            dbPath.append("uploadFile");
            dbPath.append(new SimpleDateFormat(String.valueOf(File.separator) + "YYYY" + File.separator + "MM" + File.separator + "dd").format(new Date()));
            path.append(dbPath);
            String uploadDir = path.toString();
            File dirPath = new File(uploadDir);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            File uploadedFile = new File(String.valueOf(uploadDir) + File.separator + filename);
            FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
            String savePath = String.valueOf(ChatResourceConfig.getDomain()) + "/" + path.toString().replace(File.separator, "/") + "/" + filename;
            JSONObject jsonObject = new JSONObject();
            String basePath = request.getContextPath();
            jsonObject.put("src", (Object)(String.valueOf(basePath) + "/chat/imController/showOrDownByurl.do?down=1&dbPath=" + dbPath.toString() + "/" + filename));
            jsonObject.put("name", (Object)realFilename);
            resultJson.put("code", (Object)0);
            resultJson.put("msg", (Object)"success");
            resultJson.put("data", (Object)jsonObject);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage());
            resultJson.put("code", (Object)1);
            resultJson.put("msg", (Object)("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return resultJson;
    }

    @RequestMapping(value={"showOrDownByurl"}, method={RequestMethod.GET})
    public void getImgByurl(HttpServletResponse response, HttpServletRequest request) throws Exception {
        String flag = request.getParameter("down");
        String dbpath = request.getParameter("dbPath");
        if ("1".equals(flag)) {
            response.setContentType("application/x-msdownload;charset=utf-8");
            String fileName = dbpath.substring(dbpath.lastIndexOf(File.separator) + 1);
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
        } else {
            response.setContentType("image/jpeg;charset=utf-8");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            try {
                int len;
                String imgurl = String.valueOf(this.localPath) + File.separator + dbpath;
                inputStream = new BufferedInputStream(new FileInputStream(imgurl));
                outputStream = response.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
                response.flushBuffer();
            }
            catch (Exception e) {
                this.log.info((Object)("--\u901a\u8fc7\u6d41\u7684\u65b9\u5f0f\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38--" + e.getMessage()));
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @ResponseBody
    @RequestMapping(params={"changeSign"})
    public String changeSign(String sign) {
        LoginUser u = ContextHolderUtils.getLoginSessionUser();
        this.imService.updateSign(sign, u.getId());
        return "success";
    }
}

